/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.BaseDDLExporter;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import java.io.Serializable;
import java.util.List;

public class DDLXMLExporter
extends BaseDDLExporter {
    protected void addFieldElement(Element fieldsElement, String label, Serializable value, int status) {
        Element fieldElement = fieldsElement.addElement("field");
        Element labelElement = fieldElement.addElement("label");
        labelElement.addText(label);
        Element valueElement = fieldElement.addElement("value");
        valueElement.addText(String.valueOf(value));
        Element statusElement = fieldElement.addElement("status");
        statusElement.addText(this.getStatusMessage(status));
    }

    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        List ddmFormFields = this.getDDMFormFields(recordSetId);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        List records = DDLRecordLocalServiceUtil.getRecords((long)recordSetId, (int)status, (int)start, (int)end, orderByComparator);
        for (DDLRecord record : records) {
            Element fieldsElement = rootElement.addElement("fields");
            DDLRecordVersion recordVersion = record.getRecordVersion();
            Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
            for (DDMFormField ddmFormField : ddmFormFields) {
                LocalizedValue label = ddmFormField.getLabel();
                String name = ddmFormField.getName();
                String value = "";
                if (fields.contains(name)) {
                    Field field = fields.get(name);
                    value = field.getRenderedValue(this.getLocale());
                }
                this.addFieldElement(fieldsElement, label.getString(this.getLocale()), (Serializable)((Object)value), recordVersion.getStatus());
            }
        }
        String xml = document.asXML();
        return xml.getBytes();
    }
}

