/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.BaseDDLExporter;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import java.util.List;
import java.util.Locale;

public class DDLCSVExporter
extends BaseDDLExporter {
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        StringBundler sb = new StringBundler();
        List ddmFormFields = this.getDDMFormFields(recordSetId);
        for (DDMFormField ddmFormField : ddmFormFields) {
            LocalizedValue label = ddmFormField.getLabel();
            sb.append(label.getString(this.getLocale()));
            sb.append(',');
        }
        sb.append(LanguageUtil.get((Locale)this.getLocale(), (String)"status"));
        sb.append("\n");
        List records = DDLRecordLocalServiceUtil.getRecords((long)recordSetId, (int)status, (int)start, (int)end, orderByComparator);
        for (DDLRecord record : records) {
            DDLRecordVersion recordVersion = record.getRecordVersion();
            Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
            for (DDMFormField ddmFormField : ddmFormFields) {
                String name = ddmFormField.getName();
                String value = "";
                if (fields.contains(name)) {
                    Field field = fields.get(name);
                    value = field.getRenderedValue(this.getLocale());
                }
                sb.append(CSVUtil.encode((String)value));
                sb.append(',');
            }
            sb.append(this.getStatusMessage(recordVersion.getStatus()));
            sb.append("\n");
        }
        String csv = sb.toString();
        return csv.getBytes();
    }
}

