/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.permission.DDLRecordSetPermission;

public class DDLRecordPermission {
    public static void check(PermissionChecker permissionChecker, DDLRecord record, String actionId) throws PortalException {
        if (!DDLRecordPermission.contains(permissionChecker, record, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long recordId, String actionId) throws PortalException {
        if (!DDLRecordPermission.contains(permissionChecker, recordId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDLRecord record, String actionId) throws PortalException {
        DDLRecordSet recordSet = record.getRecordSet();
        return DDLRecordSetPermission.contains(permissionChecker, recordSet, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long recordId, String actionId) throws PortalException {
        DDLRecord record = DDLRecordLocalServiceUtil.getRecord((long)recordId);
        return DDLRecordPermission.contains(permissionChecker, record, actionId);
    }
}

