/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.lar.xstream.XStreamAliasRegistryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordImpl;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordSetImpl;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStructureImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMTemplateImpl;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;

public class DDLPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "dynamic_data_lists";

    public DDLPortletDataHandler() {
        this.setDataLocalized(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(DDLRecord.class), new StagedModelType(DDLRecordSet.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "record-sets", true, false, null, DDLRecordSet.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "records", true, false, null, DDLRecord.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "data-definitions", true, false, null, DDMStructure.class.getName(), DDLRecordSet.class.getName())});
        XStreamAliasRegistryUtil.register(DDLRecordImpl.class, (String)"DDLRecord");
        XStreamAliasRegistryUtil.register(DDLRecordSetImpl.class, (String)"DDLRecordSet");
        XStreamAliasRegistryUtil.register(DDMStructureImpl.class, (String)"DDMStructure");
        XStreamAliasRegistryUtil.register(DDMTemplateImpl.class, (String)"DDMTemplate");
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(DDLPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        DDLRecordSetLocalServiceUtil.deleteRecordSets((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.portlet.dynamicdatalists");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (portletDataContext.getBooleanParameter(NAMESPACE, "data-definitions")) {
            ArrayList<DDMTemplate> ddmTemplates = new ArrayList<DDMTemplate>();
            ActionableDynamicQuery ddmStructureActionableDynamicQuery = this.getDDMStructureActionableDynamicQuery(portletDataContext, ddmTemplates);
            ddmStructureActionableDynamicQuery.performActions();
            for (DDMTemplate ddmTemplate : ddmTemplates) {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "record-sets")) {
            ExportActionableDynamicQuery recordSetActionableDynamicQuery = DDLRecordSetLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
            recordSetActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "records")) {
            ActionableDynamicQuery recordActionableDynamicQuery = this.getRecordActionableDynamicQuery(portletDataContext);
            recordActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.portlet.dynamicdatalists");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "data-definitions")) {
            Element ddmStructuresElement = portletDataContext.getImportDataGroupElement(DDMStructure.class);
            List ddmStructureElements = ddmStructuresElement.elements();
            for (Element ddmStructureElement : ddmStructureElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmStructureElement);
            }
            Element ddmTemplatesElement = portletDataContext.getImportDataGroupElement(DDMTemplate.class);
            List ddmTemplateElements = ddmTemplatesElement.elements();
            for (Element ddmTemplateElement : ddmTemplateElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmTemplateElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "record-sets")) {
            Element recordSetsElement = portletDataContext.getImportDataGroupElement(DDLRecordSet.class);
            List recordSetElements = recordSetsElement.elements();
            for (Element recordSetElement : recordSetElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)recordSetElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "records")) {
            Element recordsElement = portletDataContext.getImportDataGroupElement(DDLRecord.class);
            List recordElements = recordsElement.elements();
            for (Element recordElement : recordElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)recordElement);
            }
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ArrayList<DDMTemplate> ddmTemplates = new ArrayList<DDMTemplate>();
        ActionableDynamicQuery ddmStructureActionableDynamicQuery = this.getDDMStructureActionableDynamicQuery(portletDataContext, ddmTemplates);
        ddmStructureActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery recordSetActionableDynamicQuery = DDLRecordSetLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        recordSetActionableDynamicQuery.performCount();
        ActionableDynamicQuery recordActionableDynamicQuery = this.getRecordActionableDynamicQuery(portletDataContext);
        recordActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getDDMStructureActionableDynamicQuery(final PortletDataContext portletDataContext, final List<DDMTemplate> ddmTemplates) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = DDMStructureLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                addCriteriaMethod.addCriteria(dynamicQuery);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                long classNameId = PortalUtil.getClassNameId(DDLRecordSet.class);
                dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
            }
        });
        exportActionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                DDMStructure ddmStructure = (DDMStructure)object;
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
                try {
                    ddmTemplates.addAll(ddmStructure.getTemplates());
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DDMStructure.class.getName(), DDLRecordSet.class.getName()));
        return exportActionableDynamicQuery;
    }

    protected ActionableDynamicQuery getRecordActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery actionableDynamicQuery = DDLRecordLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = actionableDynamicQuery.getAddCriteriaMethod();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                addCriteriaMethod.addCriteria(dynamicQuery);
                Property recordIdProperty = PropertyFactoryUtil.forName((String)"recordId");
                DynamicQuery recordVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(DDLRecordVersion.class, (String)"recordVersion", (ClassLoader)PortalClassLoaderUtil.getClassLoader());
                recordVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"recordId"));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DDLRecord.class.getName());
                recordVersionDynamicQuery.add(statusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                recordVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"recordVersion.version", (String)"version"));
                recordVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"recordVersion.recordId", (String)"recordId"));
                dynamicQuery.add(recordIdProperty.in(recordVersionDynamicQuery));
            }
        });
        return actionableDynamicQuery;
    }
}

