/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.asset.model.BaseDDMStructureClassTypeReader;
import com.liferay.portlet.asset.model.ClassTypeReader;
import com.liferay.portlet.dynamicdatalists.asset.DDLRecordAssetRenderer;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordVersionLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.permission.DDLRecordSetPermission;

public class DDLRecordAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "record";

    public DDLRecordAssetRendererFactory() {
        this.setCategorizable(false);
        this.setSelectable(false);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        DDLRecord record = null;
        DDLRecordVersion recordVersion = null;
        if (type == 0) {
            recordVersion = DDLRecordVersionLocalServiceUtil.getRecordVersion((long)classPK);
            record = recordVersion.getRecord();
        } else {
            record = DDLRecordLocalServiceUtil.getRecord((long)classPK);
            recordVersion = record.getRecordVersion();
        }
        DDLRecordAssetRenderer ddlRecordAssetRenderer = new DDLRecordAssetRenderer(record, recordVersion);
        ddlRecordAssetRenderer.setAssetRendererType(type);
        return ddlRecordAssetRenderer;
    }

    public String getClassName() {
        return DDLRecord.class.getName();
    }

    public ClassTypeReader getClassTypeReader() {
        return new BaseDDMStructureClassTypeReader(this.getClassName());
    }

    public String getType() {
        return TYPE;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        DDLRecord record = DDLRecordLocalServiceUtil.getRecord((long)classPK);
        return DDLRecordSetPermission.contains(permissionChecker, record.getRecordSet(), actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/history.png";
    }
}

