/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.dynamicdatalists.NoSuchRecordSetException;
import com.liferay.portlet.dynamicdatalists.RecordSetDDMStructureIdException;
import com.liferay.portlet.dynamicdatalists.RecordSetNameException;
import com.liferay.portlet.dynamicdatalists.action.ActionUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetServiceUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRecordSetAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateRecordSet(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRecordSet(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchRecordSetException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_lists.error");
            }
            if (e instanceof RecordSetDDMStructureIdException || e instanceof RecordSetNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getRecordSet((PortletRequest)renderRequest);
            }
        }
        catch (NoSuchRecordSetException nsrse) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.dynamic_data_lists.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_lists.edit_record_set"));
    }

    protected void deleteRecordSet(ActionRequest actionRequest) throws Exception {
        long recordSetId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"recordSetId");
        DDLRecordSetServiceUtil.deleteRecordSet((long)recordSetId);
    }

    protected DDLRecordSet updateRecordSet(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long recordSetId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"recordSetId");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long ddmStructureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ddmStructureId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        int scope = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"scope");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDLRecordSet.class.getName(), (PortletRequest)actionRequest);
        DDLRecordSet recordSet = null;
        recordSet = cmd.equals("add") ? DDLRecordSetServiceUtil.addRecordSet((long)groupId, (long)ddmStructureId, null, (Map)nameMap, (Map)descriptionMap, (int)10, (int)scope, (ServiceContext)serviceContext) : DDLRecordSetServiceUtil.updateRecordSet((long)recordSetId, (long)ddmStructureId, (Map)nameMap, (Map)descriptionMap, (int)10, (ServiceContext)serviceContext);
        String workflowDefinition = ParamUtil.getString((PortletRequest)actionRequest, (String)"workflowDefinition");
        WorkflowDefinitionLinkLocalServiceUtil.updateWorkflowDefinitionLink((long)serviceContext.getUserId(), (long)serviceContext.getCompanyId(), (long)groupId, (String)DDLRecordSet.class.getName(), (long)recordSet.getRecordSetId(), (long)0L, (String)workflowDefinition);
        PortletPreferences portletPreferences = this.getStrictPortletSetup((PortletRequest)actionRequest);
        if (portletPreferences != null) {
            portletPreferences.reset("displayDDMTemplateId");
            portletPreferences.reset("editable");
            portletPreferences.reset("formDDMTemplateId");
            portletPreferences.reset("spreadsheet");
            portletPreferences.setValue("recordSetId", String.valueOf(recordSet.getRecordSetId()));
            portletPreferences.store();
        }
        return recordSet;
    }
}

