/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.dynamicdatalists.NoSuchRecordException;
import com.liferay.portlet.dynamicdatalists.action.ActionUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.DDLUtil;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRecordAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateRecord(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRecord(actionRequest);
            } else if (cmd.equals("revert")) {
                this.revertRecord(actionRequest);
            } else if (cmd.equals("translate")) {
                this.updateRecord(actionRequest);
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_lists.update_translation_redirect");
            }
            if (Validator.isNotNull((String)cmd) && !cmd.equals("translate")) {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchRecordException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_lists.error");
            }
            if (e instanceof FileSizeException || e instanceof StorageFieldRequiredException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getRecord((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchRecordException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.dynamic_data_lists.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_lists.edit_record"));
    }

    protected void deleteRecord(ActionRequest actionRequest) throws Exception {
        long recordId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"recordId");
        DDLRecordServiceUtil.deleteRecord((long)recordId);
    }

    protected void revertRecord(ActionRequest actionRequest) throws Exception {
        long recordId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"recordId");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDLRecord.class.getName(), (PortletRequest)actionRequest);
        DDLRecordServiceUtil.revertRecord((long)recordId, (String)version, (ServiceContext)serviceContext);
    }

    protected DDLRecord updateRecord(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDLRecord.class.getName(), (UploadPortletRequest)uploadPortletRequest);
        long recordId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"recordId");
        long recordSetId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"recordSetId");
        return DDLUtil.updateRecord((long)recordId, (long)recordSetId, (boolean)true, (ServiceContext)serviceContext);
    }
}

