/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentselector.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.util.AudioProcessorUtil;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import com.liferay.portlet.documentlibrary.util.VideoProcessorUtil;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DocumentSelectorUtil {
    private static final String _TYPE_DOCUMENTS = "documents";
    private static final String _TYPE_PAGES = "pages";

    public static String getCKEditorFuncNum(HttpServletRequest request) {
        String ckEditorFuncNum = ParamUtil.getString((HttpServletRequest)request, (String)"ckEditorFuncNum");
        HttpServletRequest originalRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)request);
        return ParamUtil.getString((HttpServletRequest)originalRequest, (String)"CKEditorFuncNum", (String)ckEditorFuncNum);
    }

    public static String[] getMimeTypes(HttpServletRequest request) {
        Set<String> mimeTypes = DocumentSelectorUtil._getMimeTypes(DocumentSelectorUtil.getType(request));
        return ArrayUtil.toStringArray((Object[])mimeTypes.toArray());
    }

    public static String[] getTabs1Names(HttpServletRequest request) {
        String tabs1Names = ParamUtil.getString((HttpServletRequest)request, (String)"tabs1Names");
        if (Validator.isNotNull((String)tabs1Names)) {
            return StringUtil.split((String)tabs1Names);
        }
        if (Validator.isNotNull((String)DocumentSelectorUtil.getType(request))) {
            return new String[]{_TYPE_DOCUMENTS};
        }
        return new String[]{_TYPE_DOCUMENTS, _TYPE_PAGES};
    }

    public static String getType(HttpServletRequest request) {
        String type = ParamUtil.getString((HttpServletRequest)request, (String)"type");
        HttpServletRequest originalRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)request);
        return ParamUtil.getString((HttpServletRequest)originalRequest, (String)"Type", (String)type);
    }

    private static Set<String> _getMimeTypes(String type) {
        if (StringUtil.equalsIgnoreCase((String)type, (String)"audio")) {
            return AudioProcessorUtil.getAudioMimeTypes();
        }
        if (StringUtil.equalsIgnoreCase((String)type, (String)"image")) {
            return ImageProcessorUtil.getImageMimeTypes();
        }
        if (StringUtil.equalsIgnoreCase((String)type, (String)"video")) {
            return VideoProcessorUtil.getVideoMimeTypes();
        }
        return Collections.emptySet();
    }
}

