/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentselector.action;

import com.liferay.portal.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileMimeTypeException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.InvalidFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.SourceFileNameException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentselector.util.DocumentSelectorUtil;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import java.io.Closeable;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFileEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException();
                }
                if (uploadException.isExceededSizeLimit()) {
                    throw new FileSizeException(uploadException.getCause());
                }
                throw new PortalException(uploadException.getCause());
            }
            this.addFileEntry(actionRequest);
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (Exception e) {
            this.handleUploadException(actionRequest, actionResponse, e);
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFileEntry((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof NoSuchFileVersionException || e instanceof NoSuchRepositoryEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.document_selector.error");
            }
            throw e;
        }
        String forward = "portlet.document_selector.add_file_entry";
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    protected FileEntry addFileEntry(ActionRequest actionRequest) throws Exception {
        FileEntry fileEntry;
        Folder folder;
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        String title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"title");
        String description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"description");
        String changeLog = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"changeLog");
        if (folderId > 0L && (folder = DLAppServiceUtil.getFolder((long)folderId)).getGroupId() != themeDisplay.getScopeGroupId()) {
            throw new NoSuchFolderException("{folderId=" + folderId + "}");
        }
        InputStream inputStream = null;
        try {
            HttpServletRequest request;
            Object[] mimeTypes;
            String contentType = uploadPortletRequest.getContentType("file");
            long size = uploadPortletRequest.getSize("file");
            if (size == 0L) {
                contentType = MimeTypesUtil.getContentType((String)title);
            }
            if (size > 0L && ArrayUtil.isNotEmpty((Object[])(mimeTypes = DocumentSelectorUtil.getMimeTypes(request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest)))) && !ArrayUtil.contains((Object[])mimeTypes, (Object)contentType)) {
                throw new FileMimeTypeException(contentType);
            }
            inputStream = uploadPortletRequest.getFileAsStream("file");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (UploadPortletRequest)uploadPortletRequest);
            FileEntry fileEntry2 = DLAppServiceUtil.addFileEntry((long)themeDisplay.getScopeGroupId(), (long)folderId, (String)sourceFileName, (String)contentType, (String)title, (String)description, (String)changeLog, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
            AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, (String)DLFileEntry.class.getName(), (long)folderId);
            fileEntry = fileEntry2;
        }
        catch (Exception e) {
            try {
                UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                if (uploadException != null) {
                    if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                        throw new LiferayFileItemException();
                    }
                    if (uploadException.isExceededSizeLimit()) {
                        throw new FileSizeException(uploadException.getCause());
                    }
                }
                throw e;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        return fileEntry;
    }

    protected void handleUploadException(ActionRequest actionRequest, ActionResponse actionResponse, Exception e) throws Exception {
        if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        } else if (e instanceof AntivirusScannerException || e instanceof DuplicateFileException || e instanceof DuplicateFolderNameException || e instanceof FileExtensionException || e instanceof FileMimeTypeException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof LiferayFileItemException || e instanceof NoSuchFolderException || e instanceof SourceFileNameException || e instanceof StorageFieldRequiredException) {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                String uploadExceptionRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"uploadExceptionRedirect");
                actionResponse.sendRedirect(uploadExceptionRedirect);
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                return;
            }
            if (e instanceof AntivirusScannerException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
        } else if (e instanceof InvalidFileVersionException || e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
        } else {
            throw e;
        }
    }
}

