/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrarydisplay.context;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.KeyValuePairComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DLPortletInstanceSettings;
import com.liferay.portlet.documentlibrary.context.DLActionsDisplayContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DLDisplayConfigurationDisplayContext {
    private List<KeyValuePair> _availableFileEntryColumns;
    private List<KeyValuePair> _availableFolderColumns;
    private List<KeyValuePair> _currentFileEntryColumns;
    private List<KeyValuePair> _currentFolderColumns;
    private DLActionsDisplayContext _dlActionsDisplayContext;
    private DLPortletInstanceSettings _dlPortletInstanceSettings;
    private ThemeDisplay _themeDisplay;

    public DLDisplayConfigurationDisplayContext(HttpServletRequest request, DLPortletInstanceSettings dlPortletInstanceSettings) {
        this._dlPortletInstanceSettings = dlPortletInstanceSettings;
        this._dlActionsDisplayContext = new DLActionsDisplayContext(request, dlPortletInstanceSettings);
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<KeyValuePair> getAvailableFileEntryColumns() {
        if (this._availableFileEntryColumns == null) {
            this._populateFileEntryColumns();
        }
        return this._availableFileEntryColumns;
    }

    public List<KeyValuePair> getAvailableFolderColumns() {
        if (this._availableFolderColumns == null) {
            this._populateFolderColumns();
        }
        return this._availableFolderColumns;
    }

    public List<KeyValuePair> getCurrentFileEntryColumns() {
        if (this._currentFileEntryColumns == null) {
            this._populateFileEntryColumns();
        }
        return this._currentFileEntryColumns;
    }

    public List<KeyValuePair> getCurrentFolderColumns() {
        if (this._currentFolderColumns == null) {
            this._populateFolderColumns();
        }
        return this._currentFolderColumns;
    }

    public DLActionsDisplayContext getDLActionsDisplayContext() {
        return this._dlActionsDisplayContext;
    }

    private String[] _getAllFileEntryColumns() {
        String allFileEntryColumns = "name,size";
        if (PropsValues.DL_FILE_ENTRY_BUFFERED_INCREMENT_ENABLED) {
            allFileEntryColumns = allFileEntryColumns + ",downloads";
        }
        allFileEntryColumns = allFileEntryColumns + ",locked";
        if (this._dlActionsDisplayContext.isShowActions()) {
            allFileEntryColumns = allFileEntryColumns + ",action";
        }
        return StringUtil.split((String)allFileEntryColumns);
    }

    private String[] _getAllFolderColumns() {
        String allFolderColumns = "name,num-of-folders,num-of-documents";
        if (this._dlActionsDisplayContext.isShowActions()) {
            allFolderColumns = allFolderColumns + ",action";
        }
        return StringUtil.split((String)allFolderColumns);
    }

    private void _populateFileEntryColumns() {
        Object[] fileEntryColumns = this._dlPortletInstanceSettings.getFileEntryColumns();
        this._currentFileEntryColumns = new ArrayList<KeyValuePair>();
        for (String string : fileEntryColumns) {
            this._currentFileEntryColumns.add(new KeyValuePair(string, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)string)));
        }
        this._availableFileEntryColumns = new ArrayList<KeyValuePair>();
        Arrays.sort(fileEntryColumns);
        Set allFileEntryColumns = SetUtil.fromArray((Object[])this._getAllFileEntryColumns());
        for (String fileEntryColumn : allFileEntryColumns) {
            if (Arrays.binarySearch(fileEntryColumns, fileEntryColumn) >= 0) continue;
            this._availableFileEntryColumns.add(new KeyValuePair(fileEntryColumn, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)fileEntryColumn)));
        }
        this._availableFileEntryColumns = ListUtil.sort(this._availableFileEntryColumns, (Comparator)new KeyValuePairComparator(false, true));
    }

    private void _populateFolderColumns() {
        Object[] folderColumns = this._dlPortletInstanceSettings.getFolderColumns();
        this._currentFolderColumns = new ArrayList<KeyValuePair>();
        for (String string : folderColumns) {
            this._currentFolderColumns.add(new KeyValuePair(string, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)string)));
        }
        this._availableFolderColumns = new ArrayList<KeyValuePair>();
        Arrays.sort(folderColumns);
        Set allFolderColumns = SetUtil.fromArray((Object[])this._getAllFolderColumns());
        for (String folderColumn : allFolderColumns) {
            if (Arrays.binarySearch(folderColumns, folderColumn) >= 0) continue;
            this._availableFolderColumns.add(new KeyValuePair(folderColumn, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)folderColumn)));
        }
        this._availableFolderColumns = ListUtil.sort(this._availableFolderColumns, (Comparator)new KeyValuePairComparator(false, true));
    }
}

