/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.model.Lock;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import java.io.InputStream;

public class DLFileEntryResourceImpl
extends BaseResourceImpl {
    private FileEntry _fileEntry;

    public DLFileEntryResourceImpl(WebDAVRequest webDAVRequest, FileEntry fileEntry, String parentPath, String name) {
        super(parentPath, name, fileEntry.getTitle(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getSize());
        this.setModel(fileEntry);
        this.setClassName(DLFileEntry.class.getName());
        this.setPrimaryKey(fileEntry.getPrimaryKey());
        this._fileEntry = fileEntry;
    }

    public InputStream getContentAsStream() throws WebDAVException {
        try {
            FileVersion fileVersion = this._fileEntry.getLatestFileVersion();
            return fileVersion.getContentStream(true);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public String getContentType() {
        try {
            FileVersion fileVersion = this._fileEntry.getLatestFileVersion();
            return fileVersion.getMimeType();
        }
        catch (Exception e) {
            return this._fileEntry.getMimeType();
        }
    }

    public Lock getLock() {
        try {
            return this._fileEntry.getLock();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getSize() {
        try {
            FileVersion fileVersion = this._fileEntry.getLatestFileVersion();
            return fileVersion.getSize();
        }
        catch (Exception e) {
            return this._fileEntry.getSize();
        }
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isLocked() {
        try {
            return this._fileEntry.hasLock();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

