/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RepositoryModelUtil {
    public static List<FileEntry> toFileEntries(List<DLFileEntry> dlFileEntries) {
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>(dlFileEntries.size());
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            fileEntries.add(fileEntry);
        }
        if (ListUtil.isUnmodifiableList(dlFileEntries)) {
            return Collections.unmodifiableList(fileEntries);
        }
        return fileEntries;
    }

    public static List<Object> toFileEntriesAndFolders(List<Object> dlFileEntriesAndDLFolders) {
        ArrayList<Object> fileEntriesAndFolders = new ArrayList<Object>(dlFileEntriesAndDLFolders.size());
        for (Object object : dlFileEntriesAndDLFolders) {
            if (object instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
                fileEntriesAndFolders.add(fileEntry);
                continue;
            }
            if (object instanceof DLFolder) {
                DLFolder dlFolder = (DLFolder)object;
                LiferayFolder folder = new LiferayFolder(dlFolder);
                fileEntriesAndFolders.add(folder);
                continue;
            }
            fileEntriesAndFolders.add(object);
        }
        if (ListUtil.isUnmodifiableList(dlFileEntriesAndDLFolders)) {
            return Collections.unmodifiableList(fileEntriesAndFolders);
        }
        return fileEntriesAndFolders;
    }

    public static List<FileVersion> toFileVersions(List<DLFileVersion> dlFileVersions) {
        ArrayList<FileVersion> fileVersions = new ArrayList<FileVersion>(dlFileVersions.size());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileVersion);
            fileVersions.add(fileVersion);
        }
        if (ListUtil.isUnmodifiableList(dlFileVersions)) {
            return Collections.unmodifiableList(fileVersions);
        }
        return fileVersions;
    }

    public static List<Folder> toFolders(List<DLFolder> dlFolders) {
        ArrayList<Folder> folders = new ArrayList<Folder>(dlFolders.size());
        for (DLFolder dlFolder : dlFolders) {
            LiferayFolder folder = new LiferayFolder(dlFolder);
            folders.add(folder);
        }
        if (ListUtil.isUnmodifiableList(dlFolders)) {
            return Collections.unmodifiableList(folders);
        }
        return folders;
    }
}

