/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.image.GhostscriptUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessChannel;
import com.liferay.portal.kernel.process.ProcessConfig;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.portlet.documentlibrary.util.LiferayPDFBoxConverter;
import com.liferay.portlet.documentlibrary.util.PDFProcessor;
import com.liferay.util.log4j.Log4JUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import org.apache.commons.lang.time.StopWatch;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PDFProcessorImpl
extends DLPreviewableProcessor
implements PDFProcessor {
    private static Log _log = LogFactoryUtil.getLog(PDFProcessorImpl.class);
    private List<Long> _fileVersionIds = new Vector<Long>();
    private boolean _ghostscriptInitialized;

    public void afterPropertiesSet() throws Exception {
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    public void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateImages(sourceFileVersion, destinationFileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, index, "png");
    }

    public int getPreviewFileCount(FileVersion fileVersion) {
        try {
            return this.doGetPreviewFileCount(fileVersion);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0;
        }
    }

    public long getPreviewFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, index);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public boolean hasImages(FileVersion fileVersion) {
        boolean hasImages = false;
        try {
            hasImages = this._hasImages(fileVersion);
            if (!hasImages && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasImages;
    }

    public boolean isDocumentSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isDocumentSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        if (mimeType.equals("application/pdf") || mimeType.equals("application/x-pdf")) {
            return true;
        }
        if (DocumentConversionUtil.isEnabled()) {
            Set extensions = MimeTypesUtil.getExtensions((String)mimeType);
            for (String extension : extensions) {
                Object[] targetExtensions = DocumentConversionUtil.getConversions(extension = extension.substring(1));
                if (Arrays.binarySearch(targetExtensions, "pdf") < 0) continue;
                return true;
            }
        }
        return false;
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void copyPreviews(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (!PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) {
            return;
        }
        try {
            if (this.hasPreview(sourceFileVersion) && !this.hasPreview(destinationFileVersion)) {
                int count = this.getPreviewFileCount(sourceFileVersion);
                for (int i = 0; i < count; ++i) {
                    String previewFilePath = this.getPreviewFilePath(destinationFileVersion, i + 1);
                    InputStream is = this.doGetPreviewAsStream(sourceFileVersion, i + 1, "png");
                    this.addFileToStore(destinationFileVersion.getCompanyId(), "document_preview/", previewFilePath, is);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "pdf");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this._hasImages(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            int previewFileCount = this.getPreviewFileCount(fileVersion);
            fileEntryElement.addAttribute("bin-path-pdf-preview-count", String.valueOf(previewFileCount));
            for (int i = 0; i < previewFileCount; ++i) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "pdf", "png", i);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return "png";
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "png";
    }

    protected boolean hasPreview(FileVersion fileVersion) throws Exception {
        return this.hasPreview(fileVersion, null);
    }

    protected boolean hasPreview(FileVersion fileVersion, String type) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, 1);
        return DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath);
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        int previewFileCount = GetterUtil.getInteger((String)fileEntryElement.attributeValue("bin-path-pdf-preview-count"));
        for (int i = 0; i < previewFileCount; ++i) {
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf", "png", i);
        }
    }

    private void _generateImages(FileVersion fileVersion, File file) throws Exception {
        if (GhostscriptUtil.isEnabled()) {
            if (!this._ghostscriptInitialized) {
                GhostscriptUtil.reset();
                this._ghostscriptInitialized = true;
            }
            this._generateImagesGS(fileVersion, file);
        } else {
            this._generateImagesPB(fileVersion, file);
        }
    }

    /*
     * Exception decompiling
     */
    private void _generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _generateImages(FileVersion fileVersion, InputStream inputStream) throws Exception {
        if (GhostscriptUtil.isEnabled()) {
            this._generateImagesGS(fileVersion, inputStream);
        } else {
            this._generateImagesPB(fileVersion, inputStream);
        }
    }

    private void _generateImagesGS(FileVersion fileVersion, File file) throws Exception {
        StopWatch stopWatch;
        if (this._isGeneratePreview(fileVersion)) {
            stopWatch = new StopWatch();
            stopWatch.start();
            this._generateImagesGS(fileVersion, file, false);
            if (_log.isInfoEnabled()) {
                int previewFileCount = this.getPreviewFileCount(fileVersion);
                _log.info((Object)("Ghostscript generated " + previewFileCount + " preview pages for " + fileVersion.getTitle() + " in " + stopWatch.getTime() + " ms"));
            }
        }
        if (this._isGenerateThumbnail(fileVersion)) {
            stopWatch = new StopWatch();
            stopWatch.start();
            this._generateImagesGS(fileVersion, file, true);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Ghostscript generated a thumbnail for " + fileVersion.getTitle() + " in " + stopWatch.getTime() + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesGS(FileVersion fileVersion, File file, boolean thumbnail) throws Exception {
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-sDEVICE=png16m");
        if (thumbnail) {
            arguments.add("-sOutputFile=" + this.getThumbnailTempFilePath(tempFileId));
            arguments.add("-dFirstPage=1");
            arguments.add("-dLastPage=1");
        } else {
            arguments.add("-sOutputFile=" + this.getPreviewTempFilePath(tempFileId, -1));
        }
        arguments.add("-dPDFFitPage");
        arguments.add("-dTextAlphaBits=4");
        arguments.add("-dGraphicsAlphaBits=4");
        arguments.add("-r" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI);
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH != 0) {
            arguments.add("-dDEVICEWIDTH" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH);
        }
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0) {
            arguments.add("-dDEVICEHEIGHT" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT);
        }
        arguments.add(file.getPath());
        Future future = GhostscriptUtil.execute(arguments);
        String processIdentity = String.valueOf(fileVersion.getFileVersionId());
        this.futures.put(processIdentity, future);
        future.get();
        if (thumbnail) {
            File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
            try {
                this.storeThumbnailImages(fileVersion, thumbnailTempFile);
            }
            finally {
                FileUtil.delete((File)thumbnailTempFile);
            }
        } else {
            int total = this.getPreviewTempFileCount(fileVersion);
            for (int i = 0; i < total; ++i) {
                File previewTempFile = this.getPreviewTempFile(tempFileId, i + 2);
                try {
                    this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, i + 1), previewTempFile);
                    continue;
                }
                finally {
                    FileUtil.delete((File)previewTempFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesGS(FileVersion fileVersion, InputStream inputStream) throws Exception {
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            this._generateImagesGS(fileVersion, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesPB(FileVersion fileVersion, File file) throws Exception {
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        File thumbnailFile = this.getThumbnailTempFile(tempFileId);
        int previewFilesCount = 0;
        try (PDDocument pdDocument = PDDocument.load((File)file);){
            previewFilesCount = pdDocument.getNumberOfPages();
        }
        File[] previewFiles = new File[previewFilesCount];
        for (int i = 0; i < previewFilesCount; ++i) {
            previewFiles[i] = this.getPreviewTempFile(tempFileId, i);
        }
        boolean generatePreview = this._isGeneratePreview(fileVersion);
        boolean generateThumbnail = this._isGenerateThumbnail(fileVersion);
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
            LiferayPDFBoxProcessCallable processCallable = new LiferayPDFBoxProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), file, thumbnailFile, previewFiles, this.getThumbnailType(fileVersion), this.getPreviewType(fileVersion), PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH, generatePreview, generateThumbnail);
            ProcessChannel processChannel = ProcessExecutorUtil.execute((ProcessConfig)ClassPathUtil.getPortalProcessConfig(), (ProcessCallable)processCallable);
            NoticeableFuture future = processChannel.getProcessNoticeableFuture();
            String processIdentity = String.valueOf(fileVersion.getFileVersionId());
            this.futures.put(processIdentity, future);
            future.get();
        } else {
            LiferayPDFBoxConverter liferayConverter = new LiferayPDFBoxConverter(file, thumbnailFile, previewFiles, this.getPreviewType(fileVersion), this.getThumbnailType(fileVersion), PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH, generatePreview, generateThumbnail);
            liferayConverter.generateImagesPB();
        }
        if (generateThumbnail) {
            try {
                this.storeThumbnailImages(fileVersion, thumbnailFile);
            }
            finally {
                FileUtil.delete((File)thumbnailFile);
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("PDFBox generated a thumbnail for " + fileVersion.getFileVersionId()));
            }
        }
        if (generatePreview) {
            int index = 0;
            for (File previewFile : previewFiles) {
                try {
                    this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, index + 1), previewFile);
                }
                finally {
                    FileUtil.delete((File)previewFile);
                }
                ++index;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("PDFBox generated " + this.getPreviewFileCount(fileVersion) + " preview pages for " + fileVersion.getFileVersionId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesPB(FileVersion fileVersion, InputStream inputStream) throws Exception {
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            this._generateImagesPB(fileVersion, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    private boolean _hasImages(FileVersion fileVersion) throws Exception {
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !this.hasPreview(fileVersion)) {
            return false;
        }
        return this.hasThumbnails(fileVersion);
    }

    private boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
        return PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !this.hasPreview(fileVersion);
    }

    private boolean _isGenerateThumbnail(FileVersion fileVersion) throws Exception {
        return PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !this.hasThumbnail(fileVersion, 0);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId())) {
            return;
        }
        boolean generateImages = false;
        String extension = destinationFileVersion.getExtension();
        if (extension.equals("pdf")) {
            generateImages = true;
        } else if (DocumentConversionUtil.isEnabled()) {
            String[] conversions;
            for (String conversion : conversions = DocumentConversionUtil.getConversions(extension)) {
                if (!conversion.equals("pdf")) continue;
                generateImages = true;
                break;
            }
        }
        if (generateImages) {
            this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
            this.sendGenerationMessage("liferay/document_library_pdf_processor", sourceFileVersion, destinationFileVersion);
        }
    }

    private static class LiferayPDFBoxProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private Map<String, String> _customLogSettings;
        private int _dpi;
        private String _extension;
        private boolean _generatePreview;
        private boolean _generateThumbnail;
        private int _height;
        private File _inputFile;
        private String _liferayHome;
        private File[] _previewFiles;
        private String _serverId;
        private String _thumbnailExtension;
        private File _thumbnailFile;
        private int _width;

        public LiferayPDFBoxProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, File inputFile, File thumbnailFile, File[] previewFiles, String extension, String thumbnailExtension, int dpi, int height, int width, boolean generatePreview, boolean generateThumbnail) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputFile = inputFile;
            this._thumbnailFile = thumbnailFile;
            this._previewFiles = previewFiles;
            this._extension = extension;
            this._thumbnailExtension = thumbnailExtension;
            this._dpi = dpi;
            this._height = height;
            this._width = width;
            this._generatePreview = generatePreview;
            this._generateThumbnail = generateThumbnail;
        }

        public String call() throws ProcessException {
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties((Properties)systemProperties);
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayPDFBoxConverter liferayConverter = new LiferayPDFBoxConverter(this._inputFile, this._thumbnailFile, this._previewFiles, this._extension, this._thumbnailExtension, this._dpi, this._height, this._width, this._generatePreview, this._generateThumbnail);
                liferayConverter.generateImagesPB();
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            return "";
        }
    }
}

