/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.image.ImageToolImpl;
import com.liferay.portal.kernel.image.ImageTool;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;

public class LiferayPDFBoxConverter {
    private int _dpi;
    private String _extension;
    private boolean _generatePreview;
    private boolean _generateThumbnail;
    private int _height;
    private File _inputFile;
    private File[] _previewFiles;
    private String _thumbnailExtension;
    private File _thumbnailFile;
    private int _width;

    public LiferayPDFBoxConverter(File inputFile, File thumbnailFile, File[] previewFiles, String extension, String thumbnailExtension, int dpi, int height, int width, boolean generatePreview, boolean generateThumbnail) {
        this._inputFile = inputFile;
        this._thumbnailFile = thumbnailFile;
        this._previewFiles = previewFiles;
        this._extension = extension;
        this._thumbnailExtension = thumbnailExtension;
        this._dpi = dpi;
        this._height = height;
        this._width = width;
        this._generatePreview = generatePreview;
        this._generateThumbnail = generateThumbnail;
    }

    public void generateImagesPB() throws Exception {
        try (PDDocument pdDocument = PDDocument.load((File)this._inputFile);){
            PDDocumentCatalog pdDocumentCatalog = pdDocument.getDocumentCatalog();
            List pdPages = pdDocumentCatalog.getAllPages();
            for (int i = 0; i < pdPages.size(); ++i) {
                PDPage pdPage = (PDPage)pdPages.get(i);
                if (this._generateThumbnail && i == 0) {
                    this._generateImagesPB(pdPage, i, this._thumbnailFile, this._thumbnailExtension);
                }
                if (!this._generatePreview) {
                    break;
                }
                this._generateImagesPB(pdPage, i + 1, this._previewFiles[i], this._extension);
            }
        }
    }

    private void _generateImagesPB(PDPage pdPage, int index, File outputFile, String extension) throws Exception {
        RenderedImage renderedImage = pdPage.convertToImage(1, this._dpi);
        ImageTool imageTool = ImageToolImpl.getInstance();
        renderedImage = this._height != 0 ? imageTool.scale(renderedImage, this._width, this._height) : imageTool.scale(renderedImage, this._width);
        outputFile.createNewFile();
        ImageIO.write(renderedImage, extension, outputFile);
    }
}

