/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.InvalidFileVersionException;
import com.liferay.portlet.documentlibrary.SourceFileNameException;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DLValidator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class DLValidatorImpl
implements DLValidator {
    private static final String _UNICODE_PREFIX = "\\u";

    public boolean isValidName(String name) {
        if (Validator.isNull((String)name)) {
            return false;
        }
        for (String blacklistChar : PropsValues.DL_CHAR_BLACKLIST) {
            if (!name.contains(blacklistChar)) continue;
            return false;
        }
        for (String blacklistLastChar : PropsValues.DL_CHAR_LAST_BLACKLIST) {
            if (blacklistLastChar.startsWith(_UNICODE_PREFIX)) {
                blacklistLastChar = UnicodeFormatter.parseString((String)blacklistLastChar);
            }
            if (!name.endsWith(blacklistLastChar)) continue;
            return false;
        }
        String nameWithoutExtension = name;
        if (name.contains(".")) {
            int index = name.lastIndexOf(".");
            nameWithoutExtension = name.substring(0, index);
        }
        for (String blacklistName : PropsValues.DL_NAME_BLACKLIST) {
            if (!StringUtil.equalsIgnoreCase((String)nameWithoutExtension, (String)blacklistName)) continue;
            return false;
        }
        return true;
    }

    public void validateDirectoryName(String directoryName) throws FolderNameException {
        if (!this.isValidName(directoryName)) {
            throw new FolderNameException(directoryName);
        }
    }

    public void validateFileExtension(String fileName) throws FileExtensionException {
        String[] fileExtensions;
        boolean validFileExtension = false;
        for (String fileExtension : fileExtensions = PrefsPropsUtil.getStringArray("dl.file.extensions", ",")) {
            if (!"*".equals(fileExtension) && !StringUtil.endsWith((String)fileName, (String)fileExtension)) continue;
            validFileExtension = true;
            break;
        }
        if (!validFileExtension) {
            throw new FileExtensionException(fileName);
        }
    }

    public void validateFileName(String fileName) throws FileNameException {
        if (!this.isValidName(fileName)) {
            throw new FileNameException(fileName);
        }
    }

    public void validateFileSize(String fileName, byte[] bytes) throws FileSizeException {
        if (bytes == null || PrefsPropsUtil.getLong("dl.file.max.size") > 0L && (long)bytes.length > PrefsPropsUtil.getLong("dl.file.max.size")) {
            throw new FileSizeException(fileName);
        }
    }

    public void validateFileSize(String fileName, File file) throws FileSizeException {
        if (file == null || PrefsPropsUtil.getLong("dl.file.max.size") > 0L && file.length() > PrefsPropsUtil.getLong("dl.file.max.size")) {
            throw new FileSizeException(fileName);
        }
    }

    public void validateFileSize(String fileName, InputStream is) throws FileSizeException {
        try {
            if (is == null || PrefsPropsUtil.getLong("dl.file.max.size") > 0L && (long)is.available() > PrefsPropsUtil.getLong("dl.file.max.size")) {
                throw new FileSizeException(fileName);
            }
        }
        catch (IOException ioe) {
            throw new FileSizeException(ioe.getMessage());
        }
    }

    public void validateSourceFileExtension(String fileExtension, String sourceFileName) throws SourceFileNameException {
        String sourceFileExtension = FileUtil.getExtension((String)sourceFileName);
        if (Validator.isNotNull((String)sourceFileName) && PropsValues.DL_FILE_EXTENSIONS_STRICT_CHECK && !fileExtension.equals(sourceFileExtension)) {
            throw new SourceFileNameException(sourceFileExtension);
        }
    }

    public void validateVersionLabel(String versionLabel) throws InvalidFileVersionException {
        if (Validator.isNull((String)versionLabel)) {
            return;
        }
        if (!DLUtil.isValidVersion((String)versionLabel)) {
            throw new InvalidFileVersionException();
        }
    }
}

