/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.documentlibrary.DLPortletInstanceSettings;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DL;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import com.liferay.portlet.documentlibrary.util.PDFProcessorUtil;
import com.liferay.portlet.documentlibrary.util.VideoProcessorUtil;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelCreateDateComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelNameComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelReadCountComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelSizeComparator;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DLImpl
implements DL {
    private static final String _DEFAULT_FILE_ICON = "page";
    private static final String _DEFAULT_GENERIC_NAME = "default";
    private static final long _DIVISOR = 256L;
    private static final String[] _MICROSOFT_OFFICE_EXTENSIONS;
    private static final String _STRUCTURE_KEY_PREFIX = "AUTO_";
    private static Log _log;
    private static Set<String> _allMediaGalleryMimeTypes;
    private static Set<String> _fileIcons;
    private static Map<String, String> _genericNames;

    public void addPortletBreadcrumbEntries(DLFileShortcut dlFileShortcut, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder = dlFileShortcut.getFolder();
        if (folder.getFolderId() != 0L) {
            this.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        DLFileShortcut unescapedDLFileShortcut = dlFileShortcut.toUnescapedModel();
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(dlFileShortcut.getToFileEntryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedDLFileShortcut.getToTitle(), (String)portletURL.toString());
    }

    public void addPortletBreadcrumbEntries(FileEntry fileEntry, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder = fileEntry.getFolder();
        if (folder.getFolderId() != 0L) {
            this.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        PortletURL portletURL = renderResponse.createRenderURL();
        FileEntry unescapedFileEntry = (FileEntry)fileEntry.toUnescapedModel();
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntry.getFileEntryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFileEntry.getTitle(), (String)portletURL.toString());
    }

    public void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, LiferayPortletResponse liferayPortletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("direction-right", Boolean.TRUE.toString());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
        data.put("folder-id", dlPortletInstanceSettings.getDefaultFolderId());
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString(), data);
        this.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, PortletURL portletURL) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        long defaultFolderId = 0L;
        boolean ignoreRootFolder = ParamUtil.getBoolean((HttpServletRequest)request, (String)"ignoreRootFolder");
        if (!ignoreRootFolder) {
            DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
            defaultFolderId = dlPortletInstanceSettings.getDefaultFolderId();
        }
        List ancestorFolders = Collections.emptyList();
        if (folder != null && folder.getFolderId() != defaultFolderId) {
            ancestorFolders = folder.getAncestors();
            int indexOfRootFolder = -1;
            for (int i = 0; i < ancestorFolders.size(); ++i) {
                Folder ancestorFolder = (Folder)ancestorFolders.get(i);
                if (defaultFolderId != ancestorFolder.getFolderId()) continue;
                indexOfRootFolder = i;
            }
            if (indexOfRootFolder > -1) {
                ancestorFolders = ancestorFolders.subList(0, indexOfRootFolder);
            }
        }
        Collections.reverse(ancestorFolders);
        for (Folder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", ancestorFolder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString(), data);
        }
        long folderId = 0L;
        if (folder != null) {
            folderId = folder.getFolderId();
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        if (folderId != 0L && folderId != defaultFolderId) {
            Folder unescapedFolder = (Folder)folder.toUnescapedModel();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", folderId);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFolder.getName(), (String)portletURL.toString(), data);
        }
    }

    public void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean ignoreRootFolder = ParamUtil.getBoolean((HttpServletRequest)request, (String)"ignoreRootFolder");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/document_library/select_file_entry") || strutsAction.equals("/document_library/select_folder") || strutsAction.equals("/document_library_display/select_folder") || strutsAction.equals("/document_selector/view") || strutsAction.equals("/image_gallery_display/select_folder")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            portletURL.setParameter("struts_action", strutsAction);
            portletURL.setParameter("groupId", String.valueOf(groupId));
            portletURL.setParameter("ignoreRootFolder", String.valueOf(ignoreRootFolder));
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/document_library/view");
        }
        this.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder;
        if (folderId != 0L && (folder = DLAppLocalServiceUtil.getFolder((long)folderId)).getFolderId() != 0L) {
            this.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
    }

    public int compareVersions(String version1, String version2) {
        int[] splitVersion1 = StringUtil.split((String)version1, (String)".", (int)0);
        int[] splitVersion2 = StringUtil.split((String)version2, (String)".", (int)0);
        if (splitVersion1.length != 2 && splitVersion2.length != 2) {
            return 0;
        }
        if (splitVersion1.length != 2) {
            return -1;
        }
        if (splitVersion2.length != 2) {
            return 1;
        }
        if (splitVersion1[0] > splitVersion2[0]) {
            return 1;
        }
        if (splitVersion1[0] < splitVersion2[0]) {
            return -1;
        }
        if (splitVersion1[1] > splitVersion2[1]) {
            return 1;
        }
        if (splitVersion1[1] < splitVersion2[1]) {
            return -1;
        }
        return 0;
    }

    public String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
        List folders = folder.getAncestors();
        Collections.reverse(folders);
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (Folder curFolder : folders) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public Set<String> getAllMediaGalleryMimeTypes() {
        return _allMediaGalleryMimeTypes;
    }

    public String getDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDDMStructureKey(dlFileEntryType.getUuid());
    }

    public String getDDMStructureKey(String fileEntryTypeUuid) {
        return _STRUCTURE_KEY_PREFIX + StringUtil.toUpperCase((String)fileEntryTypeUuid);
    }

    public String getDeprecatedDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDeprecatedDDMStructureKey(dlFileEntryType.getFileEntryTypeId());
    }

    public String getDeprecatedDDMStructureKey(long fileEntryTypeId) {
        return _STRUCTURE_KEY_PREFIX + fileEntryTypeId;
    }

    public String getDividedPath(long id) {
        StringBundler sb = new StringBundler(16);
        long dividend = id;
        while (dividend / 256L != 0L) {
            sb.append("/");
            sb.append(dividend % 256L);
            dividend /= 256L;
        }
        sb.append("/");
        sb.append(id);
        return sb.toString();
    }

    public String getDLFileEntryControlPanelLink(PortletRequest portletRequest, long fileEntryId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"199", (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntryId));
        return portletURL.toString();
    }

    public String getDLFolderControlPanelLink(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"199", (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/view");
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    public String getDownloadURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getDownloadURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public String getDownloadURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String previewURL = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, appendVersion, absoluteURL);
        return HttpUtil.addParameter((String)previewURL, (String)"download", (boolean)true);
    }

    public Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-document"));
        definitionTerms.put("[$DOCUMENT_TITLE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-title"));
        definitionTerms.put("[$DOCUMENT_TYPE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-type"));
        definitionTerms.put("[$DOCUMENT_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-url"));
        definitionTerms.put("[$DOCUMENT_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-document"));
        definitionTerms.put("[$FOLDER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-folder-in-which-the-document-has-been-added"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)portletRequest));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-document"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public Map<String, String> getEmailFromDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-document"));
        definitionTerms.put("[$DOCUMENT_STATUS_BY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-updated-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-document"));
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)portletRequest));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-document"));
        return definitionTerms;
    }

    public List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Document document : hits.getDocs()) {
            String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                FileEntry obj = null;
                if (entryClassName.equals(DLFileEntry.class.getName())) {
                    obj = DLAppLocalServiceUtil.getFileEntry((long)entryClassPK);
                } else if (entryClassName.equals(MBMessage.class.getName())) {
                    long classPK = GetterUtil.getLong((String)document.get("classPK"));
                    DLAppLocalServiceUtil.getFileEntry((long)classPK);
                    obj = MBMessageLocalServiceUtil.getMessage((long)entryClassPK);
                }
                entries.add(obj);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Documents and Media search index is stale and contains entry {className=" + entryClassName + ", classPK=" + entryClassPK + "}"));
            }
        }
        return entries;
    }

    public List<FileEntry> getFileEntries(Hits hits) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        for (Document document : hits.getDocs()) {
            long fileEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
                entries.add(fileEntry);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Documents and Media search index is stale and contains file entry " + fileEntryId));
            }
        }
        return entries;
    }

    public String getFileEntryImage(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler(5);
        sb.append("<img src=\"");
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/file_system/small/");
        sb.append(fileEntry.getIcon());
        sb.append(".png\" style=\"border-width: 0; text-align: left;\">");
        return sb.toString();
    }

    public Set<Long> getFileEntryTypeSubscriptionClassPKs(long userId) {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)DLFileEntryType.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public String getFileIcon(String extension) {
        if (!_fileIcons.contains(extension)) {
            extension = _DEFAULT_FILE_ICON;
        }
        return extension;
    }

    public String getFileIconCssClass(String extension) {
        return "icon-file-alt";
    }

    public String getGenericName(String extension) {
        String genericName = _genericNames.get(extension);
        if (genericName == null) {
            genericName = _DEFAULT_GENERIC_NAME;
        }
        return genericName;
    }

    public String getImagePreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay) throws Exception {
        String previewQueryString = null;
        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            if (ImageProcessorUtil.hasImages((FileVersion)fileVersion)) {
                previewQueryString = "&imagePreview=1";
            } else if (PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
                previewQueryString = "&previewFileIndex=1";
            } else if (VideoProcessorUtil.hasVideo((FileVersion)fileVersion)) {
                previewQueryString = "&videoThumbnail=1";
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, previewQueryString);
    }

    public String getImagePreviewURL(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        return this.getImagePreviewURL(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    @Deprecated
    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendToken) {
        return this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String portletId;
        PortletDisplay portletDisplay;
        StringBundler sb = new StringBundler(17);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        String fileName = fileEntry.getFileName();
        if (fileEntry.isInTrash()) {
            fileName = TrashUtil.getOriginalTitle((String)fileEntry.getFileName());
        }
        sb.append(HttpUtil.encodeURL((String)HtmlUtil.unescape((String)fileName)));
        sb.append("/");
        sb.append(HttpUtil.encodeURL((String)fileEntry.getUuid()));
        if (appendVersion) {
            sb.append("?version=");
            sb.append(fileVersion.getVersion());
        }
        if (ImageProcessorUtil.isImageSupported((FileVersion)fileVersion)) {
            if (appendVersion) {
                sb.append("&t=");
            } else {
                sb.append("?t=");
            }
            Date modifiedDate = fileVersion.getModifiedDate();
            sb.append(modifiedDate.getTime());
        }
        sb.append(queryString);
        if (themeDisplay != null && (portletDisplay = themeDisplay.getPortletDisplay()) != null && (portletId = portletDisplay.getId()).equals("182")) {
            sb.append("&status=");
            sb.append(8);
        }
        String previewURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return PortalUtil.getURLWithSessionId((String)previewURL, (String)themeDisplay.getSessionId());
        }
        return previewURL;
    }

    public <T> OrderByComparator<T> getRepositoryModelOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = true;
        if (orderByType.equals("desc")) {
            orderByAsc = false;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("creationDate") ? new RepositoryModelCreateDateComparator(orderByAsc) : (orderByCol.equals("downloads") ? new RepositoryModelReadCountComparator(orderByAsc) : (orderByCol.equals("modifiedDate") ? new RepositoryModelModifiedDateComparator(orderByAsc) : (orderByCol.equals("size") ? new RepositoryModelSizeComparator(orderByAsc) : new RepositoryModelNameComparator(orderByAsc))));
        return orderByComparator;
    }

    public String getSanitizedFileName(String title, String extension) {
        String fileName = StringUtil.replace((String)title, (String)"/", (String)"_");
        if (Validator.isNotNull((String)extension) && !fileName.endsWith("." + extension)) {
            fileName = fileName + "." + extension;
        }
        if (fileName.length() > 255) {
            int x = fileName.length() - 1;
            if (Validator.isNotNull((String)extension)) {
                x = fileName.lastIndexOf("." + extension);
            }
            int y = x - (fileName.length() - 255);
            fileName = fileName.substring(0, y) + fileName.substring(x);
        }
        return fileName;
    }

    public String getTempFileId(long id, String version) {
        return this.getTempFileId(id, version, null);
    }

    public String getTempFileId(long id, String version, String languageId) {
        if (Validator.isNull((String)languageId)) {
            return String.valueOf(id).concat(".").concat(version);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(id);
        sb.append(".");
        sb.append(version);
        sb.append(".");
        sb.append(languageId);
        return sb.toString();
    }

    public String getThumbnailSrc(FileEntry fileEntry, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileEntry.getFileVersion(), dlFileShortcut, themeDisplay);
    }

    public String getThumbnailSrc(FileEntry fileEntry, FileVersion fileVersion, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        String thumbnailQueryString = null;
        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            if (ImageProcessorUtil.hasImages((FileVersion)fileVersion)) {
                thumbnailQueryString = "&imageThumbnail=1";
            } else if (PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
                thumbnailQueryString = "&documentThumbnail=1";
            } else if (VideoProcessorUtil.hasVideo((FileVersion)fileVersion)) {
                thumbnailQueryString = "&videoThumbnail=1";
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, thumbnailQueryString);
    }

    public String getThumbnailStyle() throws Exception {
        return this.getThumbnailStyle(true, 0);
    }

    public String getThumbnailStyle(boolean max, int margin) throws Exception {
        StringBundler sb = new StringBundler(5);
        if (max) {
            sb.append("max-height: ");
        } else {
            sb.append("height: ");
        }
        sb.append(PrefsPropsUtil.getLong((String)"dl.file.entry.thumbnail.max.height") + (long)(2 * margin));
        if (max) {
            sb.append("px; max-width: ");
        } else {
            sb.append("px; width: ");
        }
        sb.append(PrefsPropsUtil.getLong((String)"dl.file.entry.thumbnail.max.width") + (long)(2 * margin));
        sb.append("px;");
        return sb.toString();
    }

    public String getTitleWithExtension(FileEntry fileEntry) {
        String title = fileEntry.getTitle();
        String extension = fileEntry.getExtension();
        return this.getTitleWithExtension(title, extension);
    }

    public String getTitleWithExtension(String title, String extension) {
        String periodAndExtension;
        if (Validator.isNotNull((String)extension) && !title.endsWith(periodAndExtension = ".".concat(extension))) {
            title = title + periodAndExtension;
        }
        return title;
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry) throws PortalException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, false);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired) throws PortalException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, manualCheckInRequired, false);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired, boolean openDocumentUrl) throws PortalException {
        StringBundler webDavURL = new StringBundler(8);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL((String)themeDisplay.getServerName(), (int)themeDisplay.getServerPort(), (boolean)secure);
        webDavURL.append(portalURL);
        webDavURL.append(themeDisplay.getPathContext());
        webDavURL.append("/webdav");
        if (manualCheckInRequired) {
            webDavURL.append("/manualCheckInRequired");
        }
        String fileEntryFileName = null;
        Group group = null;
        if (fileEntry != null) {
            fileEntryFileName = HtmlUtil.unescape((String)fileEntry.getFileName());
            group = GroupLocalServiceUtil.getGroup((long)fileEntry.getGroupId());
        } else {
            group = themeDisplay.getScopeGroup();
        }
        webDavURL.append(group.getFriendlyURL());
        webDavURL.append("/document_library");
        StringBuilder sb = new StringBuilder();
        if (folder != null && folder.getFolderId() != 0L) {
            Folder curFolder = folder;
            while (true) {
                sb.insert(0, HttpUtil.encodeURL((String)curFolder.getName(), (boolean)true));
                sb.insert(0, "/");
                if (curFolder.getParentFolderId() == 0L) break;
                curFolder = DLAppLocalServiceUtil.getFolder((long)curFolder.getParentFolderId());
            }
        }
        if (fileEntry != null) {
            sb.append("/");
            sb.append(HttpUtil.encodeURL((String)fileEntryFileName, (boolean)true));
        }
        webDavURL.append(sb.toString());
        return webDavURL.toString();
    }

    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, long folderId, long fileEntryTypeId) throws Exception {
        while (folderId != 0L) {
            DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolder((long)folderId);
            if (dlFolder == null) {
                return false;
            }
            if (dlFolder.isOverrideFileEntryTypes()) break;
            folderId = dlFolder.getParentFolderId();
        }
        return WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)DLFolderConstants.getClassName(), (long)folderId, (long)fileEntryTypeId) || WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)DLFolderConstants.getClassName(), (long)folderId, (long)-1L);
    }

    public boolean isAutoGeneratedDLFileEntryTypeDDMStructureKey(String ddmStructureKey) {
        return ddmStructureKey.startsWith(_STRUCTURE_KEY_PREFIX);
    }

    public boolean isOfficeExtension(String extension) {
        return ArrayUtil.contains((Object[])_MICROSOFT_OFFICE_EXTENSIONS, (Object)extension);
    }

    public boolean isSubscribedToFileEntryType(long companyId, long groupId, long userId, long fileEntryTypeId) {
        if (fileEntryTypeId == 0L) {
            fileEntryTypeId = groupId;
        }
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)DLFileEntryType.class.getName(), (long)fileEntryTypeId);
    }

    public boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId) throws PortalException {
        return this.isSubscribedToFolder(companyId, groupId, userId, folderId, true);
    }

    public boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId, boolean recursive) throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        if (folderId != 0L) {
            Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
            ancestorFolderIds.add(folderId);
            if (recursive) {
                ancestorFolderIds.addAll(folder.getAncestorFolderIds());
                ancestorFolderIds.add(groupId);
            }
        } else {
            ancestorFolderIds.add(groupId);
        }
        long[] folderIdsArray = ArrayUtil.toLongArray(ancestorFolderIds);
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)Folder.class.getName(), (long[])folderIdsArray);
    }

    public boolean isValidVersion(String version) {
        if (version.equals("PWC")) {
            return true;
        }
        String[] versionParts = StringUtil.split((String)version, (String)".");
        if (versionParts.length != 2) {
            return false;
        }
        return Validator.isNumber((String)versionParts[0]) && Validator.isNumber((String)versionParts[1]);
    }

    public void startWorkflowInstance(long userId, DLFileVersion dlFileVersion, String syncEventType, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("url", this.getEntryURL(dlFileVersion, serviceContext));
        workflowContext.put("event", syncEventType);
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)dlFileVersion.getCompanyId(), (long)dlFileVersion.getGroupId(), (long)userId, (String)DLFileEntryConstants.getClassName(), (long)dlFileVersion.getFileVersionId(), (Object)dlFileVersion, (ServiceContext)serviceContext, workflowContext);
    }

    protected String getEntryURL(DLFileVersion dlFileVersion, ServiceContext serviceContext) throws PortalException {
        long controlPanelPlid;
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null || serviceContext.getThemeDisplay() == null) {
            return "";
        }
        long plid = serviceContext.getPlid();
        if (plid == (controlPanelPlid = PortalUtil.getControlPanelPlid((long)serviceContext.getCompanyId()))) {
            plid = PortalUtil.getPlidFromPortletId((long)dlFileVersion.getGroupId(), (String)"20");
        }
        if (plid == 0L) {
            plid = controlPanelPlid;
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"20", (long)plid, (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(dlFileVersion.getFileEntryId()));
        return portletURL.toString();
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/file_system/large/");
        sb.append(this.getGenericName(fileEntry.getExtension()));
        sb.append(".png");
        String thumbnailSrc = sb.toString();
        if (Validator.isNotNull((String)queryString)) {
            thumbnailSrc = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
        }
        return thumbnailSrc;
    }

    private static void _populateGenericNamesMap(String genericName) {
        String[] extensions;
        for (String extension : extensions = PropsUtil.getArray((String)"dl.file.generic.extensions", (Filter)new Filter(genericName))) {
            _genericNames.put(extension, genericName);
        }
    }

    static {
        String[] genericNames;
        _MICROSOFT_OFFICE_EXTENSIONS = new String[]{"accda", "accdb", "accdc", "accde", "accdp", "accdr", "accdt", "accdu", "acl", "ade", "adp", "asd", "cnv", "crtx", "doc", "docm", "docx", "dot", "dotm", "dotx", "grv", "iaf", "laccdb", "maf", "mam", "maq", "mar", "mat", "mda", "mdb", "mde", "mdt", "mdw", "mpd", "mpp", "mpt", "oab", "obi", "oft", "olm", "one", "onepkg", "ops", "ost", "pa", "pip", "pot", "potm", "potx", "ppa", "ppam", "pps", "ppsm", "ppsx", "ppt", "pptm", "pptx", "prf", "pst", "pub", "puz", "rpmsg", "sldm", "sldx", "slk", "snp", "svd", "thmx", "vdx", "vrge08message", "vsd", "vss", "vst", "vsx", "vtx", "wbk", "wll", "xar", "xl", "xla", "xlam", "xlb", "xlc", "xll", "xlm", "xls", "xlsb", "xlsm", "xlsx", "xlt", "xltm", "xltx", "xlw", "xsf", "xsn"};
        _log = LogFactoryUtil.getLog(DLImpl.class);
        _allMediaGalleryMimeTypes = new TreeSet<String>();
        _fileIcons = new HashSet<String>();
        _genericNames = new HashMap<String, String>();
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.audio.mime.types")));
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.video.mime.types")));
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.image.mime.types")));
        String[] fileIcons = null;
        try {
            fileIcons = PropsUtil.getArray((String)"dl.file.icons");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            fileIcons = new String[]{""};
        }
        for (int i = 0; i < fileIcons.length; ++i) {
            if ("*".equals(fileIcons[i])) continue;
            String extension = fileIcons[i];
            if (extension.length() > 0) {
                extension = extension.substring(1);
            }
            _fileIcons.add(extension);
        }
        for (String genericName : genericNames = PropsUtil.getArray((String)"dl.file.generic.names")) {
            DLImpl._populateGenericNamesMap(genericName);
        }
    }
}

