/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.dynamicdatamapping.StructureFieldException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexerUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;

public class DLFileEntryIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntry.class.getName()};
    public static final String PORTLET_ID = "20";
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryIndexer.class);

    public DLFileEntryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "content", "entryClassName", "entryClassPK", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        MBMessage message = (MBMessage)obj;
        FileEntry fileEntry = null;
        try {
            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)message.getClassPK());
        }
        catch (Exception e) {
            return;
        }
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)classPK);
        FileVersion fileVersion = fileEntry.getFileVersion();
        return this.isVisible(fileVersion.getStatus(), status);
    }

    public boolean isVisibleRelatedEntry(long classPK, int status) throws Exception {
        DLFileEntry dlFileEntry;
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)classPK);
        if (fileEntry instanceof LiferayFileEntry && (dlFileEntry = (DLFileEntry)fileEntry.getModel()).isInHiddenFolder()) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)dlFileEntry.getClassName());
            return indexer.isVisible(dlFileEntry.getClassPK(), status);
        }
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        Object[] mimeTypes;
        this.addStatus(contextQuery, searchContext);
        if (searchContext.isIncludeAttachments()) {
            this.addRelatedClassNames(contextQuery, searchContext);
        }
        contextQuery.addRequiredTerm("hidden", searchContext.isIncludeAttachments());
        this.addSearchClassTypeIds(contextQuery, searchContext);
        String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
            DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)GetterUtil.getLong((String)ddmStructureFieldNameParts[1]));
            String fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[2], (String)"_".concat(LocaleUtil.toLanguageId((Locale)searchContext.getLocale())), (String)"");
            try {
                ddmStructureFieldValue = DDMUtil.getIndexedFieldValue((Serializable)ddmStructureFieldValue, (String)structure.getFieldType(fieldName));
            }
            catch (StructureFieldException sfe) {
                // empty catch block
            }
            contextQuery.addRequiredTerm(ddmStructureFieldName, "\"" + ddmStructureFieldValue + "\"");
        }
        if (ArrayUtil.isNotEmpty((Object[])(mimeTypes = (String[])searchContext.getAttribute("mimeTypes")))) {
            BooleanQuery mimeTypesQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            for (Object mimeType : mimeTypes) {
                mimeTypesQuery.addTerm("mimeType", StringUtil.replace((String)mimeType, (char)'/', (char)'_'));
            }
            contextQuery.add((Query)mimeTypesQuery, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            this.addSearchTerm(searchQuery, searchContext, "description", false);
            this.addSearchTerm(searchQuery, searchContext, "title", false);
            this.addSearchTerm(searchQuery, searchContext, "userName", false);
        }
        this.addSearchTerm(searchQuery, searchContext, "ddmContent", false);
        this.addSearchTerm(searchQuery, searchContext, "extension", false);
        this.addSearchTerm(searchQuery, searchContext, "fileEntryTypeId", false);
        this.addSearchTerm(searchQuery, searchContext, "path", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    public void updateFullQuery(SearchContext searchContext) {
        if (searchContext.isIncludeAttachments()) {
            searchContext.addFullQueryEntryClassName(DLFileEntry.class.getName());
        }
    }

    protected void addFileEntryTypeAttributes(Document document, DLFileVersion dlFileVersion) throws PortalException {
        List dlFileEntryMetadatas = DLFileEntryMetadataLocalServiceUtil.getFileVersionFileEntryMetadatas((long)dlFileVersion.getFileVersionId());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            Fields fields = null;
            try {
                fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fields == null) continue;
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)dlFileEntryMetadata.getDDMStructureId());
            DDMIndexerUtil.addAttributes((Document)document, (DDMStructure)ddmStructure, (Fields)fields);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        DLFileEntry dlFileEntry = (DLFileEntry)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, dlFileEntry.getFileEntryId());
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)dlFileEntry.getCompanyId(), (String)document.get("uid"), (boolean)this.isCommitImmediately());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document doGetDocument(Object obj) throws Exception {
        DLFileEntry dlFileEntry = (DLFileEntry)obj;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing document " + dlFileEntry));
        }
        boolean indexContent = true;
        InputStream is = null;
        try {
            Object[] ignoreExtensions = PrefsPropsUtil.getStringArray("dl.file.indexing.ignore.extensions", ",");
            if (ArrayUtil.contains((Object[])ignoreExtensions, (Object)("." + dlFileEntry.getExtension()))) {
                indexContent = false;
            }
            if (indexContent) {
                is = dlFileEntry.getFileVersion().getContentStream(false);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        try {
            Indexer indexer;
            Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)dlFileEntry, (BaseModel)dlFileVersion);
            if (indexContent) {
                if (is != null) {
                    try {
                        document.addFile("content", is, dlFileEntry.getTitle(), PropsValues.DL_FILE_INDEXING_MAX_SIZE);
                    }
                    catch (IOException ioe) {
                        throw new SearchException("Cannot extract text from file" + dlFileEntry);
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Document " + dlFileEntry + " does not have any content"));
                }
            }
            document.addKeyword("classTypeId", dlFileEntry.getFileEntryTypeId());
            document.addText("description", dlFileEntry.getDescription());
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addText("properties", dlFileEntry.getLuceneProperties());
            document.addText("title", dlFileEntry.getTitle());
            String treePath = dlFileEntry.getTreePath();
            if (treePath.equals("/")) {
                document.addKeyword("treePath", "0");
            } else {
                document.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
            }
            document.addKeyword("dataRepositoryId", dlFileEntry.getDataRepositoryId());
            document.addText("ddmContent", this.extractDDMContent(dlFileVersion, LocaleUtil.getSiteDefault()));
            document.addKeyword("extension", dlFileEntry.getExtension());
            document.addKeyword("fileEntryTypeId", dlFileEntry.getFileEntryTypeId());
            document.addKeyword("mimeType", StringUtil.replace((String)dlFileEntry.getMimeType(), (char)'/', (char)'_'));
            document.addKeyword("path", dlFileEntry.getTitle());
            document.addKeyword("readCount", dlFileEntry.getReadCount());
            document.addKeyword("size", dlFileEntry.getSize());
            ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)dlFileEntry.getCompanyId(), (String)DLFileEntry.class.getName(), (long)dlFileVersion.getFileVersionId());
            ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
            this.addFileEntryTypeAttributes(document, dlFileVersion);
            if (dlFileEntry.isInHiddenFolder() && (indexer = IndexerRegistryUtil.getIndexer((String)dlFileEntry.getClassName())) != null) {
                indexer.addRelatedEntryFields(document, obj);
                DocumentHelper documentHelper = new DocumentHelper(document);
                documentHelper.setAttachmentOwnerKey(PortalUtil.getClassNameId((String)dlFileEntry.getClassName()), dlFileEntry.getClassPK());
                document.addKeyword("relatedEntry", true);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + dlFileEntry + " indexed successfully"));
            }
            Document document2 = document;
            return document2;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        liferayPortletURL.setLifecycle("ACTION_PHASE");
        try {
            liferayPortletURL.setWindowState(LiferayWindowState.EXCLUSIVE);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        String fileEntryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/document_library/get_file");
        portletURL.setParameter("fileEntryId", fileEntryId);
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        DLFileEntry dlFileEntry = (DLFileEntry)obj;
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        if (!dlFileVersion.isApproved() && !dlFileEntry.isInTrash()) {
            return;
        }
        Document document = this.getDocument(dlFileEntry);
        if (document != null) {
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)dlFileEntry.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)classPK);
        this.doReindex(dlFileEntry);
    }

    protected void doReindex(String[] ids) throws Exception {
        if (ids.length == 1) {
            long companyId = GetterUtil.getLong((String)ids[0]);
            this.reindexFolders(companyId);
            this.reindexRoot(companyId);
        } else {
            long companyId = GetterUtil.getLong((String)ids[0]);
            long groupId = GetterUtil.getLong((String)ids[2]);
            long dataRepositoryId = GetterUtil.getLong((String)ids[3]);
            this.reindexFileEntries(companyId, groupId, dataRepositoryId);
        }
    }

    protected void doReindexDDMStructures(List<Long> ddmStructureIds) throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getDDMStructureFileEntries((long[])ArrayUtil.toLongArray(ddmStructureIds));
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            this.doReindex(dlFileEntry);
        }
    }

    protected String extractDDMContent(DLFileVersion dlFileVersion, Locale locale) throws Exception {
        List dlFileEntryMetadatas = DLFileEntryMetadataLocalServiceUtil.getFileVersionFileEntryMetadatas((long)dlFileVersion.getFileVersionId());
        StringBundler sb = new StringBundler(dlFileEntryMetadatas.size());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            Fields fields = null;
            try {
                fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fields == null) continue;
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)dlFileEntryMetadata.getDDMStructureId());
            sb.append(DDMIndexerUtil.extractAttributes((DDMStructure)ddmStructure, (Fields)fields, (Locale)locale));
        }
        return sb.toString();
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexFileEntries(long companyId, final long groupId, final long dataRepositoryId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = DLFileEntryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"folderId");
                long folderId = DLFolderConstants.getFolderId((long)groupId, (long)dataRepositoryId);
                dynamicQuery.add(property.eq((Object)folderId));
            }
        });
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                Document document = DLFileEntryIndexer.this.getDocument(dlFileEntry);
                if (document != null) {
                    actionableDynamicQuery.addDocument(document);
                }
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }

    protected void reindexFolders(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = DLFolderLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                DLFolder dlFolder = (DLFolder)object;
                String portletId = DLFileEntryIndexer.PORTLET_ID;
                long groupId = dlFolder.getGroupId();
                long folderId = dlFolder.getFolderId();
                String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
                DLFileEntryIndexer.this.reindex(newIds);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                long groupId;
                Group group = (Group)object;
                String portletId = DLFileEntryIndexer.PORTLET_ID;
                long folderId = groupId = group.getGroupId();
                String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
                DLFileEntryIndexer.this.reindex(newIds);
            }
        });
        actionableDynamicQuery.performActions();
    }
}

