/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.aop.MethodInterceptorInvocationHandler;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.AdvancedFileSystemStore;
import com.liferay.portlet.documentlibrary.store.CMISStore;
import com.liferay.portlet.documentlibrary.store.DBStore;
import com.liferay.portlet.documentlibrary.store.FileSystemStore;
import com.liferay.portlet.documentlibrary.store.JCRStore;
import com.liferay.portlet.documentlibrary.store.S3Store;
import com.liferay.portlet.documentlibrary.store.Store;
import com.liferay.portlet.documentlibrary.store.TempFileMethodInterceptor;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;

public class StoreFactory {
    private static final String[][] _DL_HOOK_STORES = new String[][]{{"com.liferay.documentlibrary.util.AdvancedFileSystemHook", AdvancedFileSystemStore.class.getName()}, {"com.liferay.documentlibrary.util.CMISHook", CMISStore.class.getName()}, {"com.liferay.documentlibrary.util.FileSystemHook", FileSystemStore.class.getName()}, {"com.liferay.documentlibrary.util.JCRHook", JCRStore.class.getName()}, {"com.liferay.documentlibrary.util.S3Hook", S3Store.class.getName()}};
    private static Log _log = LogFactoryUtil.getLog(StoreFactory.class);
    private static Store _store;
    private static boolean _warned;

    public static void checkProperties() {
        if (_warned) {
            return;
        }
        String dlHookImpl = PropsUtil.get("dl.hook.impl");
        if (Validator.isNull((String)dlHookImpl)) {
            _warned = true;
            return;
        }
        boolean found = false;
        for (String[] dlHookStoreParts : _DL_HOOK_STORES) {
            if (!dlHookImpl.equals(dlHookStoreParts[0])) continue;
            PropsValues.DL_STORE_IMPL = dlHookStoreParts[1];
            found = true;
            break;
        }
        if (!found) {
            PropsValues.DL_STORE_IMPL = dlHookImpl;
        }
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(13);
            sb.append("Liferay is configured with the legacy ");
            sb.append("property \"dl.hook.impl=");
            sb.append(dlHookImpl);
            sb.append("\" ");
            sb.append("in portal-ext.properties. Please reconfigure ");
            sb.append("to use the new property \"");
            sb.append("dl.store.impl");
            sb.append("\". Liferay will ");
            sb.append("attempt to temporarily set \"");
            sb.append("dl.store.impl");
            sb.append("=");
            sb.append(PropsValues.DL_STORE_IMPL);
            sb.append("\".");
            _log.warn((Object)sb.toString());
        }
        _warned = true;
    }

    public static Store getInstance() {
        if (_store == null) {
            StoreFactory.checkProperties();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Instantiate " + PropsValues.DL_STORE_IMPL));
            }
            try {
                _store = StoreFactory._getInstance();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (_store != null && _log.isDebugEnabled()) {
            Class<?> clazz = _store.getClass();
            _log.debug((Object)("Return " + clazz.getName()));
        }
        return _store;
    }

    public static void setInstance(Store store) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set " + ClassUtil.getClassName((Object)store)));
        }
        _store = store;
    }

    private static Store _getInstance() throws Exception {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        Store store = (Store)InstanceFactory.newInstance((ClassLoader)classLoader, (String)PropsValues.DL_STORE_IMPL);
        if (!(store instanceof DBStore)) {
            return store;
        }
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (dbType.equals("postgresql")) {
            MethodInterceptor transactionAdviceMethodInterceptor = (MethodInterceptor)PortalBeanLocatorUtil.locate((String)"transactionAdvice");
            TempFileMethodInterceptor tempFileMethodInterceptor = new TempFileMethodInterceptor();
            List<MethodInterceptor> methodInterceptors = Arrays.asList(transactionAdviceMethodInterceptor, tempFileMethodInterceptor);
            store = (Store)ProxyUtil.newProxyInstance((ClassLoader)classLoader, (Class[])new Class[]{Store.class}, (InvocationHandler)new MethodInterceptorInvocationHandler(store, methodInterceptors));
        }
        return store;
    }
}

