/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.store.BaseStore;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileSystemStore
extends BaseStore {
    private Map<RepositoryDirKey, File> _repositoryDirs = new ConcurrentHashMap<RepositoryDirKey, File>();
    private File _rootDir = new File(this.getRootDirName());

    public FileSystemStore() {
        if (!this._rootDir.exists()) {
            this._rootDir.mkdirs();
        }
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (dirNameDir.exists()) {
            throw new DuplicateDirectoryException(dirNameDir.getPath());
        }
        dirNameDir.mkdirs();
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws PortalException {
        try {
            File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, "1.0");
            if (fileNameVersionFile.exists()) {
                throw new DuplicateFileException(fileNameVersionFile.getPath());
            }
            FileUtil.write((File)fileNameVersionFile, (InputStream)is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void checkRoot(long companyId) {
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        File fromFileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, fromVersionLabel);
        File toFileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, toVersionLabel);
        if (toFileNameVersionFile.exists()) {
            throw new DuplicateFileException(toFileNameVersionFile.getPath());
        }
        try {
            toFileNameVersionFile.createNewFile();
            FileUtil.copyFile((File)fromFileNameVersionFile, (File)toFileNameVersionFile);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (!dirNameDir.exists()) {
            throw new NoSuchDirectoryException(dirNameDir.getPath());
        }
        File parentFile = dirNameDir.getParentFile();
        FileUtil.deltree((File)dirNameDir);
        RepositoryDirKey repositoryDirKey = new RepositoryDirKey(companyId, repositoryId);
        this._repositoryDirs.remove(repositoryDirKey);
        this.deleteEmptyAncestors(parentFile);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            throw new NoSuchFileException(fileNameDir.getPath());
        }
        File parentFile = fileNameDir.getParentFile();
        FileUtil.deltree((File)fileNameDir);
        this.deleteEmptyAncestors(companyId, repositoryId, parentFile);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
        if (!fileNameVersionFile.exists()) {
            throw new NoSuchFileException(fileNameVersionFile.getPath());
        }
        File parentFile = fileNameVersionFile.getParentFile();
        fileNameVersionFile.delete();
        this.deleteEmptyAncestors(companyId, repositoryId, parentFile);
    }

    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        File fileNameVersionFile;
        if (Validator.isNull((String)versionLabel)) {
            versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        }
        if (!(fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel)).exists()) {
            throw new NoSuchFileException(fileNameVersionFile.getPath());
        }
        return fileNameVersionFile;
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        if (Validator.isNull((String)versionLabel)) {
            versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        }
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
        try {
            return new FileInputStream(fileNameVersionFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException(fileNameVersionFile.getPath(), (Throwable)fnfe);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        return FileUtil.listDirs((File)repositoryDir);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (!dirNameDir.exists()) {
            throw new NoSuchDirectoryException(dirNameDir.getPath());
        }
        Object[] fileNames = FileUtil.listDirs((File)dirNameDir);
        Arrays.sort(fileNames);
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = "/" + dirName + "/" + (String)fileNames[i];
        }
        return fileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        String versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
        if (!fileNameVersionFile.exists()) {
            throw new NoSuchFileException(fileNameVersionFile.getPath());
        }
        return fileNameVersionFile.length();
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        return dirNameDir.exists();
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
        return fileNameVersionFile.exists();
    }

    public void move(String srcDir, String destDir) {
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        File newFileNameDir = this.getFileNameDir(companyId, newRepositoryId, fileName);
        if (newFileNameDir.exists()) {
            throw new DuplicateFileException(fileName);
        }
        File parentFile = fileNameDir.getParentFile();
        boolean renamed = FileUtil.move((File)fileNameDir, (File)newFileNameDir);
        if (!renamed) {
            throw new SystemException("File name directory was not renamed from " + fileNameDir.getPath() + " to " + newFileNameDir.getPath());
        }
        this.deleteEmptyAncestors(companyId, repositoryId, parentFile);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws PortalException {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        File newFileNameDir = this.getFileNameDir(companyId, repositoryId, newFileName);
        if (newFileNameDir.exists()) {
            throw new DuplicateFileException(newFileName);
        }
        File parentFile = fileNameDir.getParentFile();
        boolean renamed = FileUtil.move((File)fileNameDir, (File)newFileNameDir);
        if (!renamed) {
            throw new SystemException("File name directory was not renamed from " + fileNameDir.getPath() + " to " + newFileNameDir.getPath());
        }
        this.deleteEmptyAncestors(companyId, repositoryId, parentFile);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws PortalException {
        try {
            File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
            if (fileNameVersionFile.exists()) {
                throw new DuplicateFileException(fileNameVersionFile.getPath());
            }
            FileUtil.write((File)fileNameVersionFile, (InputStream)is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        File fromFileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, fromVersionLabel);
        File toFileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, toVersionLabel);
        if (toFileNameVersionFile.exists()) {
            throw new DuplicateFileException(toFileNameVersionFile.getPath());
        }
        boolean renamed = FileUtil.move((File)fromFileNameVersionFile, (File)toFileNameVersionFile);
        if (!renamed) {
            throw new SystemException("File name version file was not renamed from " + fromFileNameVersionFile.getPath() + " to " + toFileNameVersionFile.getPath());
        }
    }

    protected void deleteEmptyAncestors(File file) {
        this.deleteEmptyAncestors(-1L, -1L, file);
    }

    protected void deleteEmptyAncestors(long companyId, long repositoryId, File file) {
        String[] fileNames = file.list();
        if (fileNames == null || fileNames.length > 0) {
            return;
        }
        String fileName = file.getName();
        if (repositoryId > 0L && fileName.equals(String.valueOf(repositoryId))) {
            RepositoryDirKey repositoryDirKey = new RepositoryDirKey(companyId, repositoryId);
            this._repositoryDirs.remove(repositoryDirKey);
        }
        File parentFile = file.getParentFile();
        if (file.delete() && parentFile != null) {
            this.deleteEmptyAncestors(companyId, repositoryId, parentFile);
        }
    }

    protected File getCompanyDir(long companyId) {
        File companyDir = new File(this._rootDir + "/" + companyId);
        if (!companyDir.exists()) {
            companyDir.mkdirs();
        }
        return companyDir;
    }

    protected File getDirNameDir(long companyId, long repositoryId, String dirName) {
        return this.getFileNameDir(companyId, repositoryId, dirName);
    }

    protected File getFileNameDir(long companyId, long repositoryId, String fileName) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        File fileNameDir = new File(repositoryDir + "/" + fileName);
        return fileNameDir;
    }

    protected File getFileNameVersionFile(long companyId, long repositoryId, String fileName, String version) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        File fileNameVersionFile = new File(fileNameDir + "/" + version);
        return fileNameVersionFile;
    }

    protected String getHeadVersionLabel(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return "1.0";
        }
        String[] versionLabels = FileUtil.listFiles((File)fileNameDir);
        String headVersionLabel = "1.0";
        for (String versionLabel : versionLabels) {
            if (DLUtil.compareVersions((String)versionLabel, (String)headVersionLabel) <= 0) continue;
            headVersionLabel = versionLabel;
        }
        return headVersionLabel;
    }

    protected File getRepositoryDir(long companyId, long repositoryId) {
        RepositoryDirKey repositoryDirKey = new RepositoryDirKey(companyId, repositoryId);
        File repositoryDir = this._repositoryDirs.get(repositoryDirKey);
        if (repositoryDir == null) {
            File companyDir = this.getCompanyDir(companyId);
            repositoryDir = new File(companyDir + "/" + repositoryId);
            if (!repositoryDir.exists()) {
                repositoryDir.mkdirs();
            }
            this._repositoryDirs.put(repositoryDirKey, repositoryDir);
        }
        return repositoryDir;
    }

    protected String getRootDirName() {
        return PropsValues.DL_STORE_FILE_SYSTEM_ROOT_DIR;
    }

    private class RepositoryDirKey {
        private long _companyId;
        private long _repositoryId;

        public RepositoryDirKey(long companyId, long repositoryId) {
            this._companyId = companyId;
            this._repositoryId = repositoryId;
        }

        public boolean equals(Object obj) {
            RepositoryDirKey repositoryDirKey = (RepositoryDirKey)obj;
            return this._companyId == repositoryDirKey._companyId && this._repositoryId == repositoryDirKey._repositoryId;
        }

        public int hashCode() {
            return (int)(this._companyId * 11L + this._repositoryId);
        }
    }
}

