/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalService;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DirectoryNameException;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.store.DLStore;
import com.liferay.portlet.documentlibrary.store.Store;
import com.liferay.portlet.documentlibrary.util.DLValidatorUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DLStoreImpl
implements DLStore {
    @BeanReference(type=GroupLocalService.class)
    protected GroupLocalService groupLocalService;
    @BeanReference(type=Store.class)
    protected Store store;
    private static final String[] _KEYWORDS_FIELDS = new String[]{"assetTagNames", "content", "properties"};

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName) || dirName.equals("/")) {
            throw new DirectoryNameException(dirName);
        }
        this.store.addDirectory(companyId, repositoryId, dirName);
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException {
        this.validate(fileName, validateFileExtension, bytes);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((byte[])bytes);
        }
        this.store.addFile(companyId, repositoryId, fileName, bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, validateFileExtension, file);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((File)file);
        }
        this.store.addFile(companyId, repositoryId, fileName, file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, InputStream is) throws PortalException {
        if (is instanceof ByteArrayFileInputStream) {
            ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)is;
            File file = byteArrayFileInputStream.getFile();
            this.addFile(companyId, repositoryId, fileName, validateFileExtension, file);
            return;
        }
        this.validate(fileName, validateFileExtension, is);
        if (!PropsValues.DL_STORE_ANTIVIRUS_ENABLED || !AntivirusScannerUtil.isActive()) {
            this.store.addFile(companyId, repositoryId, fileName, is);
        } else {
            File tempFile = null;
            try {
                if (is.markSupported()) {
                    is.mark(is.available() + 1);
                    AntivirusScannerUtil.scan((InputStream)is);
                    is.reset();
                    this.store.addFile(companyId, repositoryId, fileName, is);
                } else {
                    tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (InputStream)is);
                    AntivirusScannerUtil.scan((File)tempFile);
                    this.store.addFile(companyId, repositoryId, fileName, tempFile);
                }
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to scan file " + fileName, (Throwable)ioe);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, is);
    }

    public void checkRoot(long companyId) {
        this.store.checkRoot(companyId);
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        this.store.copyFileVersion(companyId, repositoryId, fileName, fromVersionLabel, toVersionLabel);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        this.store.deleteDirectory(companyId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        this.store.deleteFile(companyId, repositoryId, fileName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        this.store.deleteFile(companyId, repositoryId, fileName, versionLabel);
    }

    public File getFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        return this.store.getFile(companyId, repositoryId, fileName);
    }

    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        return this.store.getFile(companyId, repositoryId, fileName, versionLabel);
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        return this.store.getFileAsBytes(companyId, repositoryId, fileName);
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        return this.store.getFileAsBytes(companyId, repositoryId, fileName, versionLabel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        return this.store.getFileAsStream(companyId, repositoryId, fileName);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        return this.store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName)) {
            throw new DirectoryNameException(dirName);
        }
        return this.store.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        return this.store.getFileSize(companyId, repositoryId, fileName);
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName)) {
            throw new DirectoryNameException(dirName);
        }
        return this.store.hasDirectory(companyId, repositoryId, dirName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        return this.store.hasFile(companyId, repositoryId, fileName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        return this.store.hasFile(companyId, repositoryId, fileName, versionLabel);
    }

    @Deprecated
    public boolean isValidName(String name) {
        return DLValidatorUtil.isValidName((String)name);
    }

    public void move(String srcDir, String destDir) {
        this.store.move(srcDir, destDir);
    }

    public Hits search(long companyId, long userId, String portletId, long groupId, long[] repositoryIds, String keywords, int start, int end) {
        try {
            SearchContext searchContext = new SearchContext();
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setEntryClassNames(new String[]{DLFileEntryConstants.getClassName()});
            searchContext.setGroupIds(new long[]{groupId});
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)DLFileEntryConstants.getClassName());
            searchContext.setSearchEngineId(indexer.getSearchEngineId());
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            contextQuery.addRequiredTerm("portletId", portletId);
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (ArrayUtil.isNotEmpty((long[])repositoryIds)) {
                BooleanQuery repositoryIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
                for (long repositoryId : repositoryIds) {
                    try {
                        if (userId > 0L) {
                            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                            DLFolderPermission.check(permissionChecker, groupId, repositoryId, "VIEW");
                        }
                        if (repositoryId == 0L) {
                            repositoryId = groupId;
                        }
                        TermQuery termQuery = TermQueryFactoryUtil.create((SearchContext)searchContext, (String)"repositoryId", (long)repositoryId);
                        repositoryIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                contextQuery.add((Query)repositoryIdsQuery, BooleanClauseOccur.MUST);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            searchQuery.addTerms(_KEYWORDS_FIELDS, keywords);
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            List clauses = searchQuery.clauses();
            if (!clauses.isEmpty()) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((SearchContext)searchContext, (Query)fullQuery);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        this.store.updateFile(companyId, repositoryId, newRepositoryId, fileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws PortalException {
        this.store.updateFile(companyId, repositoryId, fileName, newFileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionLabel, String sourceFileName, File file) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, file, versionLabel);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((File)file);
        }
        this.store.updateFile(companyId, repositoryId, fileName, versionLabel, file);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionLabel, String sourceFileName, InputStream is) throws PortalException {
        if (is instanceof ByteArrayFileInputStream) {
            ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)is;
            File file = byteArrayFileInputStream.getFile();
            this.updateFile(companyId, repositoryId, fileName, fileExtension, validateFileExtension, versionLabel, sourceFileName, file);
            return;
        }
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, is, versionLabel);
        if (!PropsValues.DL_STORE_ANTIVIRUS_ENABLED || !AntivirusScannerUtil.isActive()) {
            this.store.updateFile(companyId, repositoryId, fileName, versionLabel, is);
        } else {
            File tempFile = null;
            try {
                if (is.markSupported()) {
                    is.mark(is.available() + 1);
                    AntivirusScannerUtil.scan((InputStream)is);
                    is.reset();
                    this.store.updateFile(companyId, repositoryId, fileName, versionLabel, is);
                } else {
                    tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (InputStream)is);
                    AntivirusScannerUtil.scan((File)tempFile);
                    this.store.updateFile(companyId, repositoryId, fileName, versionLabel, tempFile);
                }
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to scan file " + fileName, (Throwable)ioe);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        this.store.updateFileVersion(companyId, repositoryId, fileName, fromVersionLabel, toVersionLabel);
    }

    public void validate(String fileName, boolean validateFileExtension) throws PortalException {
        DLValidatorUtil.validateFileName((String)fileName);
        if (validateFileExtension) {
            DLValidatorUtil.validateFileExtension((String)fileName);
        }
    }

    public void validate(String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (byte[])bytes);
    }

    public void validate(String fileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (File)file);
    }

    public void validate(String fileName, boolean validateFileExtension, InputStream is) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (InputStream)is);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateSourceFileExtension((String)fileExtension, (String)sourceFileName);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (File)file);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream is) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (InputStream)is);
    }

    @Deprecated
    public void validateDirectoryName(String directoryName) throws PortalException {
        DLValidatorUtil.validateDirectoryName((String)directoryName);
    }

    protected void validate(String fileName, boolean validateFileExtension, String versionLabel) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }

    protected void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, File file, String versionLabel) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, file);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }

    protected void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream is, String versionLabel) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, is);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }
}

