/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.cmis.CMISRepositoryUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.store.BaseStore;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public class CMISStore
extends BaseStore {
    private static Folder _systemRootDir;

    public CMISStore() {
        _systemRootDir = this.getFolder(SessionHolder.session.getRootFolder(), PropsValues.DL_STORE_CMIS_SYSTEM_ROOT_DIR);
        if (_systemRootDir == null) {
            _systemRootDir = this.createFolder((ObjectId)SessionHolder.session.getRootFolder(), PropsValues.DL_STORE_CMIS_SYSTEM_ROOT_DIR);
        }
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) {
        String[] dirNames;
        Folder folder = this.getRepositoryFolder(companyId, repositoryId);
        for (String curDirName : dirNames = StringUtil.split((String)dirName, (char)'/')) {
            Folder subFolder = this.getFolder(folder, curDirName);
            if (subFolder == null) {
                subFolder = this.createFolder((ObjectId)folder, curDirName);
            }
            folder = subFolder;
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws PortalException {
        this.updateFile(companyId, repositoryId, fileName, "1.0", is);
    }

    public void checkRoot(long companyId) {
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        Folder versioningFolder = this.getVersioningFolder(companyId, repositoryId, fileName, false);
        ObjectIdImpl versioningFolderObjectId = new ObjectIdImpl(versioningFolder.getId());
        HashMap<String, String> documentProperties = new HashMap<String, String>();
        String title = String.valueOf(toVersionLabel);
        documentProperties.put("cmis:name", title);
        documentProperties.put("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value());
        Document document = this.getVersionedDocument(companyId, repositoryId, fileName, fromVersionLabel);
        document.copy((ObjectId)versioningFolderObjectId, documentProperties, null, document.getPolicies(), null, null, null);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        Folder repositoryFolder = this.getRepositoryFolder(companyId, repositoryId);
        Folder directory = this.getFolder(repositoryFolder, dirName);
        if (directory != null) {
            directory.deleteTree(true, UnfileObject.DELETE, false);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        Folder versioningFolder = this.getVersioningFolder(companyId, repositoryId, fileName, false);
        if (versioningFolder == null) {
            throw new NoSuchFileException();
        }
        versioningFolder.deleteTree(true, UnfileObject.DELETE, false);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        Document document = this.getVersionedDocument(companyId, repositoryId, fileName, versionLabel);
        document.delete(true);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        if (Validator.isNull((String)versionLabel)) {
            versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        }
        Document document = this.getVersionedDocument(companyId, repositoryId, fileName, versionLabel);
        return document.getContentStream().getStream();
    }

    public String[] getFileNames(long companyId, long repositoryId) {
        Folder folder = this.getRepositoryFolder(companyId, repositoryId);
        List<Folder> folders = this.getFolders(folder);
        String[] fileNames = new String[folders.size()];
        for (int i = 0; i < folders.size(); ++i) {
            Folder curFolder = folders.get(i);
            fileNames[i] = curFolder.getName();
        }
        return fileNames;
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        String[] dirNames;
        Folder folder = this.getRepositoryFolder(companyId, repositoryId);
        for (String curDirName : dirNames = StringUtil.split((String)dirName, (char)'/')) {
            Folder subFolder = this.getFolder(folder, curDirName);
            if (subFolder == null) {
                subFolder = this.createFolder((ObjectId)folder, curDirName);
            }
            folder = subFolder;
        }
        List<Folder> folders = this.getFolders(folder);
        String[] fileNames = new String[folders.size()];
        for (int i = 0; i < folders.size(); ++i) {
            Folder curFolder = folders.get(i);
            String fileName = curFolder.getName();
            fileNames[i] = dirName.concat("/").concat(fileName);
        }
        return fileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        String versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        Document document = this.getVersionedDocument(companyId, repositoryId, fileName, versionLabel);
        return document.getContentStreamLength();
    }

    public String getHeadVersionLabel(long companyId, long repositoryId, String dirName) throws NoSuchFileException {
        Folder versioningFolder = this.getVersioningFolder(companyId, repositoryId, dirName, false);
        if (versioningFolder == null) {
            throw new NoSuchFileException();
        }
        List<Folder> folders = this.getFolders(versioningFolder);
        String headVersionLabel = "1.0";
        for (Folder folder : folders) {
            String versionLabel = folder.getName();
            if (DLUtil.compareVersions((String)versionLabel, (String)headVersionLabel) <= 0) continue;
            headVersionLabel = versionLabel;
        }
        return headVersionLabel;
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) {
        String[] dirNames;
        Folder folder = this.getRepositoryFolder(companyId, repositoryId);
        for (String subdirName : dirNames = StringUtil.split((String)dirName, (char)'/')) {
            Folder subfolder = this.getFolder(folder, subdirName);
            if (subfolder != null) continue;
            return false;
        }
        return true;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        Folder versioningFolder = this.getVersioningFolder(companyId, repositoryId, fileName, true);
        Document document = this.getDocument(versioningFolder, versionLabel);
        return document != null;
    }

    public void move(String srcDir, String destDir) {
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) {
        Folder oldVersioningFolderEntry = this.getVersioningFolder(companyId, repositoryId, fileName, true);
        Folder newVersioningFolderEntry = this.getVersioningFolder(companyId, newRepositoryId, fileName, true);
        List<Folder> folders = this.getFolders(oldVersioningFolderEntry);
        for (Folder folder : folders) {
            String curFileName = folder.getName();
            Document document = this.getDocument(oldVersioningFolderEntry, curFileName);
            InputStream is = document.getContentStream().getStream();
            this.createDocument(newVersioningFolderEntry, curFileName, is);
        }
        oldVersioningFolderEntry.deleteTree(true, UnfileObject.DELETE, false);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) {
        Folder oldVersioningFolderEntry = this.getVersioningFolder(companyId, repositoryId, fileName, true);
        Folder newVersioningFolderEntry = this.getVersioningFolder(companyId, repositoryId, newFileName, true);
        List<Folder> folders = this.getFolders(oldVersioningFolderEntry);
        for (Folder folder : folders) {
            String curFileName = folder.getName();
            Document document = this.getDocument(oldVersioningFolderEntry, curFileName);
            InputStream is = document.getContentStream().getStream();
            this.createDocument(newVersioningFolderEntry, curFileName, is);
        }
        oldVersioningFolderEntry.deleteTree(true, UnfileObject.DELETE, false);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws PortalException {
        String title;
        Folder versioningFolder = this.getVersioningFolder(companyId, repositoryId, fileName, true);
        Document document = this.getDocument(versioningFolder, title = String.valueOf(versionLabel));
        if (document != null) {
            throw new DuplicateFileException();
        }
        this.createDocument(versioningFolder, title, is);
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        String title;
        Folder versioningFolder = this.getVersioningFolder(companyId, repositoryId, fileName, false);
        Document document = this.getDocument(versioningFolder, title = String.valueOf(toVersionLabel));
        if (document != null) {
            throw new DuplicateFileException();
        }
        document = this.getVersionedDocument(companyId, repositoryId, fileName, fromVersionLabel);
        HashMap<String, String> documentProperties = new HashMap<String, String>();
        documentProperties.put("cmis:name", title);
        document.updateProperties(documentProperties);
    }

    protected Document createDocument(Folder versioningFolder, String title, InputStream is) {
        HashMap<String, String> documentProperties = new HashMap<String, String>();
        documentProperties.put("cmis:name", title);
        documentProperties.put("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value());
        ContentStreamImpl contentStream = new ContentStreamImpl(null, null, "application/octet-stream", is);
        return versioningFolder.createDocument(documentProperties, (ContentStream)contentStream, null);
    }

    protected Folder createFolder(ObjectId parentFolderId, String name) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", BaseTypeId.CMIS_FOLDER.value());
        ObjectId objectId = SessionHolder.session.createFolder(properties, parentFolderId);
        return (Folder)SessionHolder.session.getObject(objectId);
    }

    protected Folder getCompanyFolder(long companyId) {
        String name = String.valueOf(companyId);
        Folder companyFolder = this.getFolder(_systemRootDir, name);
        if (companyFolder == null) {
            companyFolder = this.createFolder((ObjectId)_systemRootDir, name);
        }
        return companyFolder;
    }

    protected Document getDocument(Folder parentFolder, String name) {
        ItemIterable cmisObjects = parentFolder.getChildren();
        for (CmisObject cmisObject : cmisObjects) {
            if (!name.equals(cmisObject.getName()) || !(cmisObject instanceof Document)) continue;
            return (Document)cmisObject;
        }
        return null;
    }

    protected Folder getFolder(Folder parentFolder, String name) {
        ItemIterable cmisObjects = parentFolder.getChildren();
        for (CmisObject cmisObject : cmisObjects) {
            if (!name.equals(cmisObject.getName()) || !(cmisObject instanceof Folder)) continue;
            return (Folder)cmisObject;
        }
        return null;
    }

    protected List<Folder> getFolders(Folder folder) {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        ItemIterable cmisObjects = folder.getChildren();
        for (CmisObject cmisObject : cmisObjects) {
            if (!(cmisObject instanceof Folder)) continue;
            folders.add((Folder)cmisObject);
        }
        return folders;
    }

    protected Folder getRepositoryFolder(long companyId, long repositoryId) {
        String name;
        Folder companyFolder = this.getCompanyFolder(companyId);
        Folder repositoryFolder = this.getFolder(companyFolder, name = String.valueOf(repositoryId));
        if (repositoryFolder == null) {
            repositoryFolder = this.createFolder((ObjectId)companyFolder, name);
        }
        return repositoryFolder;
    }

    protected Document getVersionedDocument(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        Folder versioningFolder = this.getVersioningFolder(companyId, repositoryId, fileName, false);
        if (versioningFolder == null) {
            throw new NoSuchFileException();
        }
        Document document = this.getDocument(versioningFolder, versionLabel);
        if (document == null) {
            throw new NoSuchFileException();
        }
        return document;
    }

    protected Folder getVersioningFolder(long companyId, long repositoryId, String fileName, boolean create) {
        String[] dirNames;
        Folder repositoryFolder;
        Folder versioningFolder = repositoryFolder = this.getRepositoryFolder(companyId, repositoryId);
        for (String dirName : dirNames = StringUtil.split((String)fileName, (char)'/')) {
            Folder subFolder = this.getFolder(versioningFolder, dirName);
            if (create && subFolder == null) {
                subFolder = this.createFolder((ObjectId)versioningFolder, dirName);
            }
            versioningFolder = subFolder;
        }
        return versioningFolder;
    }

    private static class SessionHolder {
        private static final Session session;

        private SessionHolder() {
        }

        static {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", PropsValues.DL_STORE_CMIS_REPOSITORY_URL);
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            parameters.put("org.apache.chemistry.opencmis.binding.compression", Boolean.TRUE.toString());
            Locale locale = LocaleUtil.getDefault();
            parameters.put("org.apache.chemistry.opencmis.locale.iso3166", locale.getCountry());
            parameters.put("org.apache.chemistry.opencmis.locale.iso639", locale.getLanguage());
            parameters.put("org.apache.chemistry.opencmis.password", PropsValues.DL_STORE_CMIS_CREDENTIALS_PASSWORD);
            parameters.put("org.apache.chemistry.opencmis.user", PropsValues.DL_STORE_CMIS_CREDENTIALS_USERNAME);
            SessionFactory sessionFactory = CMISRepositoryUtil.getSessionFactory();
            List repositories = sessionFactory.getRepositories(parameters);
            Repository repository = (Repository)repositories.get(0);
            session = repository.createSession();
            session.setDefaultContext(CMISRepositoryUtil.getOperationContext());
        }
    }
}

