/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portlet.documentlibrary.model.DLFolder"})
public class DLFolderPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, DLFolder dlFolder, String actionId) throws PortalException {
        if (!DLFolderPermission.contains(permissionChecker, dlFolder, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, Folder folder, String actionId) throws PortalException {
        if (!folder.containsPermission(permissionChecker, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException {
        if (!DLFolderPermission.contains(permissionChecker, groupId, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFolder dlFolder, String actionId) throws PortalException {
        Boolean hasPermission;
        if (actionId.equals("ADD_FOLDER")) {
            actionId = "ADD_SUBFOLDER";
        }
        if ((hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dlFolder.getGroupId(), (String)DLFolder.class.getName(), (long)dlFolder.getFolderId(), (String)"20", (String)actionId)) != null) {
            return hasPermission;
        }
        if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            block7: {
                try {
                    long dlFolderId = dlFolder.getFolderId();
                    while (dlFolderId != 0L) {
                        dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFolderId);
                        if (!DLFolderPermission._hasPermission(permissionChecker, dlFolder, actionId)) {
                            return false;
                        }
                        dlFolderId = dlFolder.getParentFolderId();
                    }
                }
                catch (NoSuchFolderException nsfe) {
                    if (dlFolder.isInTrash()) break block7;
                    throw nsfe;
                }
            }
            return DLPermission.contains(permissionChecker, dlFolder.getGroupId(), actionId);
        }
        return DLFolderPermission._hasPermission(permissionChecker, dlFolder, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, Folder folder, String actionId) throws PortalException {
        return folder.containsPermission(permissionChecker, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException {
        if (folderId == 0L) {
            if (actionId.equals("ACCESS") || actionId.equals("ADD_SUBFOLDER") || actionId.equals("DELETE")) {
                return false;
            }
            return DLPermission.contains(permissionChecker, groupId, actionId);
        }
        Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
        return folder.containsPermission(permissionChecker, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        DLFolderPermission.check(permissionChecker, groupId, primaryKey, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, DLFolder dlFolder, String actionId) {
        return permissionChecker.hasOwnerPermission(dlFolder.getCompanyId(), DLFolder.class.getName(), dlFolder.getFolderId(), dlFolder.getUserId(), actionId) || permissionChecker.hasPermission(dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), actionId);
    }
}

