/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.DLSettings;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFolderServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DLFolderServiceImpl
extends DLFolderServiceBaseImpl {
    public DLFolder addFolder(long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, parentFolderId, "ADD_FOLDER");
        return this.dlFolderLocalService.addFolder(this.getUserId(), groupId, repositoryId, mountPoint, parentFolderId, name, description, false, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException {
        this.deleteFolder(folderId, true);
    }

    public void deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "DELETE");
        this.dlFolderLocalService.deleteFolder(this.getUserId(), folderId, includeTrashedEntries);
    }

    public void deleteFolder(long groupId, long parentFolderId, String name) throws PortalException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.deleteFolder(dlFolder.getFolderId());
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.dlFolderFinder.filterFindFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountFE_FS_ByG_F_M(groupId, folderId, mimeTypes, queryDefinition);
    }

    public DLFolder getFolder(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "VIEW");
        return dlFolder;
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(groupId, parentFolderId, name);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "VIEW");
        return dlFolder;
    }

    public List<Long> getFolderIds(long groupId, long folderId) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return Collections.emptyList();
        }
        List<Long> folderIds = this.getSubfolderIds(groupId, folderId, true);
        folderIds.add(0, folderId);
        return folderIds;
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int status, boolean includeMountfolders, int start, int end, OrderByComparator<DLFolder> obc) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, parentFolderId, "VIEW")) {
            return Collections.emptyList();
        }
        if (includeMountfolders) {
            return this.dlFolderPersistence.filterFindByG_P_H_S(groupId, parentFolderId, false, status, start, end, obc);
        }
        return this.dlFolderPersistence.filterFindByG_M_P_H_S(groupId, false, parentFolderId, false, status, start, end, obc);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> obc) throws PortalException {
        return this.getFolders(groupId, parentFolderId, 0, true, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_M_M(groupId, folderId, null, includeMountFolders, queryDefinition);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, boolean includeMountFolders) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_M_M(groupId, folderId, null, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws PortalException {
        return this.getFoldersCount(groupId, parentFolderId, 0, true);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, parentFolderId, "VIEW")) {
            return 0;
        }
        if (includeMountfolders) {
            return this.dlFolderPersistence.filterCountByG_P_H_S(groupId, parentFolderId, false, status);
        }
        return this.dlFolderPersistence.filterCountByG_M_P_H_S(groupId, false, parentFolderId, false, status);
    }

    public List<DLFolder> getMountFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> obc) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, parentFolderId, "VIEW")) {
            return Collections.emptyList();
        }
        DLSettings dlSettings = DLSettings.getInstance(groupId);
        if (dlSettings.isShowHiddenMountFolders()) {
            return this.dlFolderPersistence.filterFindByG_M_P(groupId, true, parentFolderId, start, end, obc);
        }
        return this.dlFolderPersistence.filterFindByG_M_P_H(groupId, true, parentFolderId, false, start, end, obc);
    }

    public int getMountFoldersCount(long groupId, long parentFolderId) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, parentFolderId, "VIEW")) {
            return 0;
        }
        return this.dlFolderPersistence.filterCountByG_M_P_H(groupId, true, parentFolderId, false);
    }

    @Deprecated
    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws PortalException {
        this.getSubfolderIds(folderIds, groupId, folderId, true);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId, boolean recurse) throws PortalException {
        if (!DLFolderPermission.contains(this.getPermissionChecker(), groupId, folderId, "VIEW")) {
            return;
        }
        List dlFolders = this.dlFolderPersistence.filterFindByG_P_H_S(groupId, folderId, false, 0);
        for (DLFolder dlFolder : dlFolders) {
            if (dlFolder.isInHiddenFolder() || dlFolder.isInTrash()) continue;
            folderIds.add(dlFolder.getFolderId());
            if (!recurse) continue;
            this.getSubfolderIds(folderIds, dlFolder.getGroupId(), dlFolder.getFolderId(), recurse);
        }
    }

    public List<Long> getSubfolderIds(long groupId, long folderId, boolean recurse) throws PortalException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        this.getSubfolderIds(folderIds, groupId, folderId, recurse);
        return folderIds;
    }

    public boolean hasFolderLock(long folderId) throws PortalException {
        return this.lockLocalService.hasLock(this.getUserId(), DLFolder.class.getName(), folderId);
    }

    public boolean hasInheritableLock(long folderId) throws PortalException {
        boolean inheritable = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
            inheritable = lock.isInheritable();
        }
        catch (ExpiredLockException ele) {
        }
        catch (NoSuchLockException nsle) {
            // empty catch block
        }
        return inheritable;
    }

    public boolean isFolderLocked(long folderId) {
        return this.lockLocalService.isLocked(DLFolder.class.getName(), folderId);
    }

    public Lock lockFolder(long folderId) throws PortalException {
        return this.lockFolder(folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "UPDATE");
        return this.dlFolderLocalService.lockFolder(this.getUserId(), folderId, owner, inheritable, expirationTime);
    }

    public DLFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(permissionChecker, dlFolder, "UPDATE");
        DLFolderPermission.check(permissionChecker, serviceContext.getScopeGroupId(), parentFolderId, "ADD_FOLDER");
        return this.dlFolderLocalService.moveFolder(this.getUserId(), folderId, parentFolderId, serviceContext);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this.lockLocalService.refresh(lockUuid, companyId, expirationTime);
    }

    public void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws PortalException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.unlockFolder(dlFolder.getFolderId(), lockUuid);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        try {
            DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
            DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "UPDATE");
        }
        catch (NoSuchFolderException nsfe) {
            // empty catch block
        }
        this.dlFolderLocalService.unlockFolder(folderId, lockUuid);
    }

    public DLFolder updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException {
        DLFolderPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), folderId, "UPDATE");
        serviceContext.setUserId(this.getUserId());
        return this.dlFolderLocalService.updateFolder(folderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        boolean verified = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
            if (!lock.isInheritable()) {
                throw new NoSuchLockException("{folderId=" + folderId + "}");
            }
            if (lock.getUuid().equals(lockUuid)) {
                verified = true;
            }
        }
        catch (ExpiredLockException ele) {
            throw new NoSuchLockException((Throwable)ele);
        }
        return verified;
    }
}

