/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.DateOverrideIncrement;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TreeModelTasks;
import com.liferay.portal.kernel.util.TreeModelTasksAdapter;
import com.liferay.portal.kernel.util.TreePathUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.TreeModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowDefinitionLink;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.InvalidFolderException;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.RequiredFileEntryTypeException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFolderLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLValidatorUtil;
import com.liferay.portlet.documentlibrary.util.comparator.FolderIdComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DLFolderLocalServiceImpl
extends DLFolderLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFolderLocalServiceImpl.class);

    public DLFolder addFolder(long userId, long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, boolean hidden, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentFolderId = this.getParentFolderId(groupId, repositoryId, parentFolderId);
        Date now = new Date();
        this.validateFolder(groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        DLFolder dlFolder = this.dlFolderPersistence.create(folderId);
        dlFolder.setUuid(serviceContext.getUuid());
        dlFolder.setGroupId(groupId);
        dlFolder.setCompanyId(user.getCompanyId());
        dlFolder.setUserId(user.getUserId());
        dlFolder.setUserName(user.getFullName());
        dlFolder.setCreateDate(serviceContext.getCreateDate(now));
        dlFolder.setModifiedDate(serviceContext.getModifiedDate(now));
        dlFolder.setRepositoryId(repositoryId);
        dlFolder.setMountPoint(mountPoint);
        dlFolder.setParentFolderId(parentFolderId);
        dlFolder.setTreePath(dlFolder.buildTreePath());
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        dlFolder.setLastPostDate(now);
        dlFolder.setHidden(hidden);
        dlFolder.setOverrideFileEntryTypes(false);
        dlFolder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFolderResources(dlFolder, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(repositoryId, DLFolderConstants.getClassName());
            }
            this.addFolderResources(dlFolder, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        if (parentFolderId != 0L) {
            this.dlFolderLocalService.updateLastPostDate(parentFolderId, now);
        }
        return dlFolder;
    }

    @Deprecated
    public DLFolder addFolder(long userId, long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this.addFolder(userId, groupId, repositoryId, mountPoint, parentFolderId, name, description, false, serviceContext);
    }

    public void deleteAll(long groupId) throws PortalException {
        block3: {
            Group group = this.groupLocalService.getGroup(groupId);
            List dlFolders = this.dlFolderPersistence.findByGroupId(groupId);
            for (DLFolder dlFolder : dlFolders) {
                this.dlFolderLocalService.deleteFolder(dlFolder);
            }
            this.dlFileEntryLocalService.deleteFileEntries(groupId, 0L);
            this.dlFileEntryTypeLocalService.deleteFileEntryTypes(groupId);
            this.dlFileShortcutLocalService.deleteFileShortcuts(groupId, 0L);
            try {
                DLStoreUtil.deleteDirectory((long)group.getCompanyId(), (long)groupId, (String)"");
            }
            catch (NoSuchDirectoryException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DLFolder deleteFolder(DLFolder dlFolder) throws PortalException {
        return this.deleteFolder(dlFolder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DLFolder deleteFolder(DLFolder dlFolder, boolean includeTrashedEntries) throws PortalException {
        ArrayList<Long> fileEntryTypeIds;
        block9: {
            List dlFolders = this.dlFolderPersistence.findByG_P(dlFolder.getGroupId(), dlFolder.getFolderId());
            for (DLFolder curDLFolder : dlFolders) {
                if (!includeTrashedEntries && curDLFolder.isInTrashExplicitly()) continue;
                this.dlFolderLocalService.deleteFolder(curDLFolder, includeTrashedEntries);
            }
            this.resourceLocalService.deleteResource(dlFolder.getCompanyId(), DLFolder.class.getName(), 4, dlFolder.getFolderId());
            this.webDAVPropsLocalService.deleteWebDAVProps(DLFolder.class.getName(), dlFolder.getFolderId());
            this.dlFileEntryLocalService.deleteFileEntries(dlFolder.getGroupId(), dlFolder.getFolderId(), includeTrashedEntries);
            fileEntryTypeIds = new ArrayList<Long>();
            for (DLFileEntryType dlFileEntryType : this.dlFileEntryTypeLocalService.getDLFolderDLFileEntryTypes(dlFolder.getFolderId())) {
                fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
            }
            if (fileEntryTypeIds.isEmpty()) {
                fileEntryTypeIds.add(-1L);
            }
            this.dlFileEntryTypeLocalService.unsetFolderFileEntryTypes(dlFolder.getFolderId());
            this.dlFileShortcutLocalService.deleteFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), includeTrashedEntries);
            this.expandoRowLocalService.deleteRows(dlFolder.getFolderId());
            this.dlFolderPersistence.remove((BaseModel)dlFolder);
            try {
                if (includeTrashedEntries) {
                    DLStoreUtil.deleteDirectory((long)dlFolder.getCompanyId(), (long)dlFolder.getFolderId(), (String)"");
                }
            }
            catch (NoSuchDirectoryException nsde) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)nsde.getMessage());
            }
        }
        Iterator i$ = fileEntryTypeIds.iterator();
        while (i$.hasNext()) {
            long fileEntryTypeId = (Long)i$.next();
            WorkflowDefinitionLink workflowDefinitionLink = null;
            try {
                workflowDefinitionLink = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLink(dlFolder.getCompanyId(), dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), fileEntryTypeId);
            }
            catch (NoSuchWorkflowDefinitionLinkException nswdle) {
                continue;
            }
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
        return dlFolder;
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long folderId) throws PortalException {
        return this.dlFolderLocalService.deleteFolder(folderId, true);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        return this.dlFolderLocalService.deleteFolder(dlFolder, includeTrashedEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long userId, long folderId, boolean includeTrashedEntries) throws PortalException {
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            DLFolder dLFolder = this.deleteFolder(folderId, includeTrashedEntries);
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public DLFolder fetchFolder(long folderId) {
        return this.dlFolderPersistence.fetchByPrimaryKey(folderId);
    }

    public DLFolder fetchFolder(long groupId, long parentFolderId, String name) {
        return this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
    }

    public List<DLFolder> getCompanyFolders(long companyId, int start, int end) {
        return this.dlFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) {
        return this.dlFolderPersistence.countByCompanyId(companyId);
    }

    @Deprecated
    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getFileEntriesAndFileShortcuts(groupId, folderId, queryDefinition);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, QueryDefinition<?> queryDefinition) {
        return this.dlFolderFinder.findFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    @Deprecated
    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getFileEntriesAndFileShortcutsCount(groupId, folderId, queryDefinition);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, QueryDefinition<?> queryDefinition) {
        return this.dlFolderFinder.countFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public DLFolder getFolder(long folderId) throws PortalException {
        return this.dlFolderPersistence.findByPrimaryKey(folderId);
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException {
        return this.dlFolderPersistence.findByG_P_N(groupId, parentFolderId, name);
    }

    public long getFolderId(long companyId, long folderId) {
        DLFolder dlFolder;
        if (folderId != 0L && ((dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != dlFolder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    public List<Long> getFolderIds(long groupId, long parentFolderId) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(parentFolderId);
        this.getSubfolderIds(folderIds, groupId, parentFolderId);
        return folderIds;
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId) {
        return this.getFolders(groupId, parentFolderId, true);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders) {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.findByG_M_P_H(groupId, false, parentFolderId, false);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator<DLFolder> obc) {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P(groupId, parentFolderId, start, end, obc);
        }
        return this.dlFolderPersistence.findByG_M_P_H(groupId, false, parentFolderId, false, start, end, obc);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> obc) {
        return this.getFolders(groupId, parentFolderId, true, start, end, obc);
    }

    @Deprecated
    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getFoldersAndFileEntriesAndFileShortcuts(groupId, folderId, null, includeMountFolders, queryDefinition);
    }

    @Deprecated
    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getFoldersAndFileEntriesAndFileShortcuts(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition<?> queryDefinition) {
        return this.dlFolderFinder.findF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    @Deprecated
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, boolean includeMountFolders) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderId, null, includeMountFolders, queryDefinition);
    }

    @Deprecated
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition<?> queryDefinition) {
        return this.dlFolderFinder.countF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) {
        return this.getFoldersCount(groupId, parentFolderId, true);
    }

    public int getFoldersCount(long groupId, long parentFolderId, boolean includeMountfolders) {
        if (includeMountfolders) {
            return this.dlFolderPersistence.countByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.countByG_M_P_H(groupId, false, parentFolderId, false);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status, boolean includeMountfolders) {
        if (includeMountfolders) {
            return this.dlFolderPersistence.countByG_P_H_S(groupId, parentFolderId, false, status);
        }
        return this.dlFolderPersistence.countByG_M_P_H_S(groupId, false, parentFolderId, false, status);
    }

    public DLFolder getMountFolder(long repositoryId) throws PortalException {
        return this.dlFolderPersistence.findByR_M(repositoryId, true);
    }

    public List<DLFolder> getMountFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> obc) {
        return this.dlFolderPersistence.findByG_M_P_H(groupId, true, parentFolderId, false, start, end, obc);
    }

    public int getMountFoldersCount(long groupId, long parentFolderId) {
        return this.dlFolderPersistence.countByG_M_P_H(groupId, true, parentFolderId, false);
    }

    public List<DLFolder> getNoAssetFolders() {
        return this.dlFolderFinder.findF_ByNoAssets();
    }

    public List<DLFolder> getRepositoryFolders(long repositoryId, int start, int end) {
        return this.dlFolderPersistence.findByRepositoryId(repositoryId, start, end);
    }

    public int getRepositoryFoldersCount(long repositoryId) {
        return this.dlFolderPersistence.countByRepositoryId(repositoryId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        List dlFolders = this.dlFolderPersistence.findByG_P(groupId, folderId);
        for (DLFolder dlFolder : dlFolders) {
            folderIds.add(dlFolder.getFolderId());
            this.getSubfolderIds(folderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        }
    }

    public boolean hasFolderLock(long userId, long folderId) {
        return this.lockLocalService.hasLock(userId, DLFolder.class.getName(), folderId);
    }

    public Lock lockFolder(long userId, long folderId) throws PortalException {
        return this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFolder(long userId, long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        if (expirationTime <= 0L || expirationTime > DLFolderImpl.LOCK_EXPIRATION_TIME) {
            expirationTime = DLFolderImpl.LOCK_EXPIRATION_TIME;
        }
        return this.lockLocalService.lock(userId, DLFolder.class.getName(), folderId, owner, inheritable, expirationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.REINDEX)
    public DLFolder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId);
        }
        try {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            parentFolderId = this.getParentFolderId(dlFolder, parentFolderId);
            this.validateFolder(dlFolder.getFolderId(), dlFolder.getGroupId(), parentFolderId, dlFolder.getName());
            dlFolder.setModifiedDate(serviceContext.getModifiedDate(null));
            dlFolder.setParentFolderId(parentFolderId);
            dlFolder.setTreePath(dlFolder.buildTreePath());
            dlFolder.setExpandoBridgeAttributes(serviceContext);
            this.dlFolderPersistence.update((BaseModel)dlFolder);
            this.rebuildTree(dlFolder.getCompanyId(), folderId, dlFolder.getTreePath(), true);
            DLFolder dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public void rebuildTree(long companyId) throws PortalException {
        this.rebuildTree(companyId, 0L, "/", false);
    }

    public void rebuildTree(long companyId, long parentFolderId, String parentTreePath, final boolean reindex) throws PortalException {
        TreePathUtil.rebuildTree((long)companyId, (long)parentFolderId, (String)parentTreePath, (TreeModelTasks)new TreeModelTasksAdapter<DLFolder>(){

            public List<DLFolder> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                return DLFolderLocalServiceImpl.this.dlFolderPersistence.findByF_C_P_NotS(previousId, companyId, parentPrimaryKey, 8, -1, size, (OrderByComparator)new FolderIdComparator(true));
            }

            public void rebuildDependentModelsTreePaths(long parentPrimaryKey, String treePath) throws PortalException {
                DLFolderLocalServiceImpl.this.dlFileEntryLocalService.setTreePaths(parentPrimaryKey, treePath, false);
                DLFolderLocalServiceImpl.this.dlFileShortcutLocalService.setTreePaths(parentPrimaryKey, treePath);
                DLFolderLocalServiceImpl.this.dlFileVersionLocalService.setTreePaths(parentPrimaryKey, treePath);
            }

            public void reindexTreeModels(List<TreeModel> treeModels) throws PortalException {
                if (!reindex) {
                    return;
                }
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
                for (TreeModel treeModel : treeModels) {
                    indexer.reindex((Object)treeModel);
                }
            }
        });
    }

    public void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws PortalException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.unlockFolder(dlFolder.getFolderId(), lockUuid);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        block4: {
            if (Validator.isNotNull((String)lockUuid)) {
                try {
                    Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
                    if (!lockUuid.equals(lock.getUuid())) {
                        throw new InvalidLockException("UUIDs do not match");
                    }
                }
                catch (PortalException pe) {
                    if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) break block4;
                    throw pe;
                }
            }
        }
        this.lockLocalService.unlock(DLFolder.class.getName(), folderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.REINDEX)
    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this.hasFolderLock(serviceContext.getUserId(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(serviceContext.getUserId(), folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            DLFolder dlFolder = null;
            if (folderId > 0L) {
                dlFolder = this.dlFolderLocalService.updateFolderAndFileEntryTypes(serviceContext.getUserId(), folderId, parentFolderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
                this.dlFileEntryTypeLocalService.cascadeFileEntryTypes(serviceContext.getUserId(), dlFolder);
            }
            ArrayList<ObjectValuePair> workflowDefinitionOVPs = new ArrayList<ObjectValuePair>();
            if (fileEntryTypeIds.isEmpty()) {
                fileEntryTypeIds.add(-1L);
            } else {
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)-1L, (Object)""));
            }
            for (long fileEntryTypeId : fileEntryTypeIds) {
                String workflowDefinition = "";
                if (overrideFileEntryTypes || folderId == 0L) {
                    workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)("workflowDefinition" + fileEntryTypeId));
                }
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)fileEntryTypeId, (Object)workflowDefinition));
            }
            this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLinks(serviceContext.getUserId(), serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), DLFolder.class.getName(), folderId, workflowDefinitionOVPs);
            DLFolder dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLFolder updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException {
        long parentFolderId = 0L;
        if (folderId != 0L) {
            DLFolder dlFolder = this.getDLFolder(folderId);
            parentFolderId = dlFolder.getParentFolderId();
        }
        return this.updateFolder(folderId, parentFolderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLFolder updateFolderAndFileEntryTypes(long userId, long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException {
        if (overrideFileEntryTypes && fileEntryTypeIds.isEmpty()) {
            throw new RequiredFileEntryTypeException();
        }
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            if (!overrideFileEntryTypes) {
                fileEntryTypeIds = Collections.emptyList();
            }
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            parentFolderId = this.getParentFolderId(dlFolder, parentFolderId);
            this.validateFolder(folderId, dlFolder.getGroupId(), parentFolderId, name);
            dlFolder.setModifiedDate(serviceContext.getModifiedDate(null));
            dlFolder.setParentFolderId(parentFolderId);
            dlFolder.setTreePath(dlFolder.buildTreePath());
            dlFolder.setName(name);
            dlFolder.setDescription(description);
            dlFolder.setExpandoBridgeAttributes(serviceContext);
            dlFolder.setOverrideFileEntryTypes(overrideFileEntryTypes);
            dlFolder.setDefaultFileEntryTypeId(defaultFileEntryTypeId);
            this.dlFolderPersistence.update((BaseModel)dlFolder);
            if (fileEntryTypeIds != null) {
                this.dlFileEntryTypeLocalService.updateFolderFileEntryTypes(dlFolder, fileEntryTypeIds, defaultFileEntryTypeId, serviceContext);
            }
            DLFolder dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    @BufferedIncrement(configuration="DLFolderEntry", incrementClass=DateOverrideIncrement.class)
    public void updateLastPostDate(long folderId, Date lastPostDate) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess() || folderId == 0L || lastPostDate == null) {
            return;
        }
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        if (lastPostDate.before(dlFolder.getLastPostDate())) {
            return;
        }
        dlFolder.setLastPostDate(lastPostDate);
        this.dlFolderPersistence.update((BaseModel)dlFolder);
    }

    public DLFolder updateStatus(long userId, long folderId, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        int oldStatus = dlFolder.getStatus();
        dlFolder.setStatus(status);
        dlFolder.setStatusByUserId(user.getUserId());
        dlFolder.setStatusByUserName(user.getFullName());
        dlFolder.setStatusDate(new Date());
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(DLFolder.class.getName(), dlFolder.getFolderId(), true);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(DLFolder.class.getName(), dlFolder.getFolderId(), false);
        }
        if (!(status != 0 && status != 8 && oldStatus != 8 || serviceContext != null && !serviceContext.isIndexingEnabled())) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)DLFolderConstants.getClassName());
            indexer.reindex((Object)dlFolder);
        }
        return dlFolder;
    }

    protected void addFolderResources(DLFolder dlFolder, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(dlFolder.getCompanyId(), dlFolder.getGroupId(), dlFolder.getUserId(), DLFolder.class.getName(), dlFolder.getFolderId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addFolderResources(DLFolder dlFolder, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(dlFolder.getCompanyId(), dlFolder.getGroupId(), dlFolder.getUserId(), DLFolder.class.getName(), dlFolder.getFolderId(), groupPermissions, guestPermissions);
    }

    protected void addFolderResources(long folderId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(dlFolder, addGroupPermissions, addGuestPermissions);
    }

    protected void addFolderResources(long folderId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(dlFolder, groupPermissions, guestPermissions);
    }

    protected long getParentFolderId(DLFolder dlFolder, long parentFolderId) throws PortalException {
        parentFolderId = this.getParentFolderId(dlFolder.getGroupId(), dlFolder.getRepositoryId(), parentFolderId);
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (dlFolder.getFolderId() == parentFolderId) {
            throw new InvalidFolderException(String.format("Cannot move folder %s into itself", parentFolderId));
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            throw new InvalidFolderException(String.format("Cannot move folder %s into one of its children", parentFolderId));
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long repositoryId, long parentFolderId) throws PortalException {
        Repository repository;
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        DLFolder parentDLFolder = this.dlFolderPersistence.findByPrimaryKey(parentFolderId);
        if (parentDLFolder.getGroupId() != groupId) {
            throw new NoSuchFolderException(String.format("No folder exists with the primary key %s in group %s", parentFolderId, groupId));
        }
        if (parentDLFolder.getRepositoryId() != repositoryId && parentDLFolder.getRepositoryId() != groupId && (repository = this.repositoryLocalService.getRepository(repositoryId)).getGroupId() != parentDLFolder.getGroupId()) {
            throw new NoSuchFolderException(String.format("No folder exists with the primary key %s in repository %s", parentFolderId, repositoryId));
        }
        return parentDLFolder.getFolderId();
    }

    protected void validateFolder(long folderId, long groupId, long parentFolderId, String name) throws PortalException {
        this.validateFolderName(name);
        DLValidatorUtil.validateDirectoryName((String)name);
        try {
            this.dlFileEntryLocalService.getFileEntry(groupId, parentFolderId, name);
            throw new DuplicateFileException(name);
        }
        catch (NoSuchFileEntryException nsfee) {
            DLFolder dlFolder = this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
            if (dlFolder != null && dlFolder.getFolderId() != folderId) {
                throw new DuplicateFolderNameException(name);
            }
            return;
        }
    }

    protected void validateFolder(long groupId, long parentFolderId, String name) throws PortalException {
        long folderId = 0L;
        this.validateFolder(folderId, groupId, parentFolderId, name);
    }

    protected void validateFolderName(String folderName) throws PortalException {
        if (folderName.contains("/")) {
            throw new FolderNameException(folderName);
        }
    }
}

