/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.base.DLFileVersionLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import java.util.Collections;
import java.util.List;

public class DLFileVersionLocalServiceImpl
extends DLFileVersionLocalServiceBaseImpl {
    public DLFileVersion getFileVersion(long fileVersionId) throws PortalException {
        return this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
    }

    public DLFileVersion getFileVersion(long fileEntryId, String version) throws PortalException {
        return this.dlFileVersionPersistence.findByF_V(fileEntryId, version);
    }

    public DLFileVersion getFileVersionByUuidAndGroupId(String uuid, long groupId) {
        return this.dlFileVersionPersistence.fetchByUUID_G(uuid, groupId);
    }

    public List<DLFileVersion> getFileVersions(long fileEntryId, int status) {
        List dlFileVersions = null;
        dlFileVersions = status == -1 ? this.dlFileVersionPersistence.findByFileEntryId(fileEntryId) : this.dlFileVersionPersistence.findByF_S(fileEntryId, status);
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, new FileVersionVersionComparator());
        return dlFileVersions;
    }

    public int getFileVersionsCount(long fileEntryId, int status) {
        return this.dlFileVersionPersistence.countByF_S(fileEntryId, status);
    }

    public DLFileVersion getLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy) throws PortalException {
        List dlFileVersions = this.dlFileVersionPersistence.findByFileEntryId(fileEntryId);
        if (dlFileVersions.isEmpty()) {
            throw new NoSuchFileVersionException("No file versions found for fileEntryId " + fileEntryId);
        }
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, new FileVersionVersionComparator());
        DLFileVersion dlFileVersion = (DLFileVersion)dlFileVersions.get(0);
        String version = dlFileVersion.getVersion();
        if (excludeWorkingCopy && version.equals("PWC")) {
            return (DLFileVersion)dlFileVersions.get(1);
        }
        return dlFileVersion;
    }

    public DLFileVersion getLatestFileVersion(long userId, long fileEntryId) throws PortalException {
        boolean excludeWorkingCopy = true;
        if (this.dlFileEntryLocalService.isFileEntryCheckedOut(fileEntryId)) {
            excludeWorkingCopy = !this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntryId);
        }
        return this.getLatestFileVersion(fileEntryId, excludeWorkingCopy);
    }

    public void rebuildTree(long companyId) throws PortalException {
        this.dlFolderLocalService.rebuildTree(companyId);
    }

    public void setTreePaths(final long folderId, final String treePath) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
                dynamicQuery.add(folderIdProperty.eq((Object)folderId));
                Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
                dynamicQuery.add(treePathProperty.ne((Object)treePath));
            }
        });
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) {
                DLFileVersion dlFileVersion = (DLFileVersion)object;
                dlFileVersion.setTreePath(treePath);
                DLFileVersionLocalServiceImpl.this.updateDLFileVersion(dlFileVersion);
            }
        });
        actionableDynamicQuery.performActions();
    }
}

