/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryMetadataLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.StorageException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import java.util.List;
import java.util.Map;

public class DLFileEntryMetadataLocalServiceImpl
extends DLFileEntryMetadataLocalServiceBaseImpl {
    public void deleteFileEntryMetadata(long fileEntryId) throws PortalException {
        List fileEntryMetadatas = this.dlFileEntryMetadataPersistence.findByFileEntryId(fileEntryId);
        for (DLFileEntryMetadata fileEntryMetadata : fileEntryMetadatas) {
            this.deleteFileEntryMetadata(fileEntryMetadata);
        }
    }

    public void deleteFileVersionFileEntryMetadata(long fileVersionId) throws PortalException {
        List fileEntryMetadatas = this.dlFileEntryMetadataPersistence.findByFileVersionId(fileVersionId);
        for (DLFileEntryMetadata fileEntryMetadata : fileEntryMetadatas) {
            this.deleteFileEntryMetadata(fileEntryMetadata);
        }
    }

    public DLFileEntryMetadata fetchFileEntryMetadata(long fileEntryMetadataId) {
        return this.dlFileEntryMetadataPersistence.fetchByPrimaryKey(fileEntryMetadataId);
    }

    public DLFileEntryMetadata fetchFileEntryMetadata(long ddmStructureId, long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.fetchByD_F(ddmStructureId, fileVersionId);
    }

    public DLFileEntryMetadata getFileEntryMetadata(long fileEntryMetadataId) throws PortalException {
        return this.dlFileEntryMetadataPersistence.findByPrimaryKey(fileEntryMetadataId);
    }

    public DLFileEntryMetadata getFileEntryMetadata(long ddmStructureId, long fileVersionId) throws PortalException {
        return this.dlFileEntryMetadataPersistence.findByD_F(ddmStructureId, fileVersionId);
    }

    @Deprecated
    public long getFileEntryMetadataCount(long fileEntryId, long fileVersionId) {
        return this.getFileVersionFileEntryMetadatasCount(fileVersionId);
    }

    public List<DLFileEntryMetadata> getFileVersionFileEntryMetadatas(long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.findByFileVersionId(fileVersionId);
    }

    public long getFileVersionFileEntryMetadatasCount(long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.countByFileVersionId(fileVersionId);
    }

    public void updateFileEntryMetadata(long companyId, List<DDMStructure> ddmStructures, long fileEntryTypeId, long fileEntryId, long fileVersionId, Map<String, Fields> fieldsMap, ServiceContext serviceContext) throws PortalException {
        for (DDMStructure ddmStructure : ddmStructures) {
            Fields fields = fieldsMap.get(ddmStructure.getStructureKey());
            if (fields == null) continue;
            this.updateFileEntryMetadata(companyId, ddmStructure, fileEntryTypeId, fileEntryId, fileVersionId, fields, serviceContext);
        }
    }

    public void updateFileEntryMetadata(long fileEntryTypeId, long fileEntryId, long fileVersionId, Map<String, Fields> fieldsMap, ServiceContext serviceContext) throws PortalException {
        DLFileEntryType fileEntryType = this.dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
        List ddmStructures = fileEntryType.getDDMStructures();
        this.updateFileEntryMetadata(fileEntryType.getCompanyId(), ddmStructures, fileEntryTypeId, fileEntryId, fileVersionId, fieldsMap, serviceContext);
    }

    protected void deleteFileEntryMetadata(DLFileEntryMetadata fileEntryMetadata) throws PortalException {
        this.dlFileEntryMetadataPersistence.remove((BaseModel)fileEntryMetadata);
        StorageEngineUtil.deleteByClass((long)fileEntryMetadata.getDDMStorageId());
        this.ddmStructureLinkLocalService.deleteClassStructureLink(fileEntryMetadata.getFileEntryMetadataId());
    }

    protected void updateFileEntryMetadata(long companyId, DDMStructure ddmStructure, long fileEntryTypeId, long fileEntryId, long fileVersionId, Fields fields, ServiceContext serviceContext) throws StorageException {
        DLFileEntryMetadata fileEntryMetadata = this.dlFileEntryMetadataPersistence.fetchByD_F(ddmStructure.getStructureId(), fileVersionId);
        if (fileEntryMetadata != null) {
            StorageEngineUtil.update((long)fileEntryMetadata.getDDMStorageId(), (Fields)fields, (boolean)true, (ServiceContext)serviceContext);
        } else {
            long fileEntryMetadataId = this.counterLocalService.increment();
            fileEntryMetadata = this.dlFileEntryMetadataPersistence.create(fileEntryMetadataId);
            long ddmStorageId = StorageEngineUtil.create((long)companyId, (long)ddmStructure.getStructureId(), (Fields)fields, (ServiceContext)serviceContext);
            fileEntryMetadata.setDDMStorageId(ddmStorageId);
            fileEntryMetadata.setDDMStructureId(ddmStructure.getStructureId());
            fileEntryMetadata.setFileEntryTypeId(fileEntryTypeId);
            fileEntryMetadata.setFileEntryId(fileEntryId);
            fileEntryMetadata.setFileVersionId(fileVersionId);
            this.dlFileEntryMetadataPersistence.update((BaseModel)fileEntryMetadata);
            long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class);
            this.ddmStructureLinkLocalService.addStructureLink(classNameId, fileEntryMetadata.getFileEntryMetadataId(), ddmStructure.getStructureId(), serviceContext);
        }
    }
}

