/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLAppLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DLAppLocalServiceImpl
extends DLAppLocalServiceBaseImpl {
    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, byte[] bytes, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, null, 0L, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        this.dlAppHelperLocalService.addFileEntry(userId, fileEntry, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
            size = 0L;
        }
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            String extension = DLAppUtil.getExtension(title, sourceFileName);
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)is);
                    FileEntry fileEntry = this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioe) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioe);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        this.dlAppHelperLocalService.addFileEntry(userId, fileEntry, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public DLFileRank addFileRank(long repositoryId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) {
        return this.dlFileRankLocalService.addFileRank(repositoryId, companyId, userId, fileEntryId, serviceContext);
    }

    public DLFileShortcut addFileShortcut(long userId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this.dlFileShortcutLocalService.addFileShortcut(userId, repositoryId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(long userId, long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        Folder folder = localRepository.addFolder(userId, parentFolderId, name, description, serviceContext);
        this.dlAppHelperLocalService.addFolder(userId, folder, serviceContext);
        return folder;
    }

    public void deleteAll(long repositoryId) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        this.deleteRepository(localRepository);
    }

    public void deleteAllRepositories(long groupId) throws PortalException {
        LocalRepository groupLocalRepository = this.repositoryLocalService.getLocalRepositoryImpl(groupId);
        this.deleteRepository(groupLocalRepository);
        List localRepositories = this.repositoryLocalService.getGroupLocalRepositoryImpl(groupId);
        for (LocalRepository localRepository : localRepositories) {
            if (localRepository.getRepositoryId() == groupLocalRepository.getRepositoryId()) continue;
            this.deleteRepository(localRepository);
        }
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = this.getFileEntryLocalRepository(fileEntryId);
        FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
        this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        localRepository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileRanksByFileEntryId(long fileEntryId) {
        this.dlFileRankLocalService.deleteFileRanksByFileEntryId(fileEntryId);
    }

    public void deleteFileRanksByUserId(long userId) {
        this.dlFileRankLocalService.deleteFileRanksByUserId(userId);
    }

    public void deleteFileShortcut(DLFileShortcut dlFileShortcut) throws PortalException {
        this.dlFileShortcutLocalService.deleteFileShortcut(dlFileShortcut);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this.dlFileShortcutLocalService.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        LocalRepository localRepository = this.getFolderLocalRepository(folderId);
        List fileEntries = localRepository.getRepositoryFileEntries(folderId, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        Folder folder = this.getFolder(folderId);
        localRepository.deleteFolder(folderId);
        this.dlAppHelperLocalService.deleteFolder(folder);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = this.getFileEntryLocalRepository(fileEntryId);
        return localRepository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException {
        try {
            LocalRepository localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntry(folderId, title);
        }
        catch (NoSuchFileEntryException nsfee) {
            LocalRepository localRepository = this.getFolderLocalRepository(folderId);
            return localRepository.getFileEntry(folderId, title);
        }
    }

    public FileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        try {
            LocalRepository localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntryByUuid(uuid);
        }
        catch (NoSuchFileEntryException nsfee) {
            List repositories = this.repositoryPersistence.findByGroupId(groupId);
            for (Repository repository : repositories) {
                try {
                    LocalRepository localRepository = this.getLocalRepository(repository.getRepositoryId());
                    return localRepository.getFileEntryByUuid(uuid);
                }
                catch (NoSuchFileEntryException nsfee2) {
                }
            }
            StringBundler msg = new StringBundler(6);
            msg.append("No DLFileEntry exists with the key {");
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchFileEntryException(msg.toString());
        }
    }

    public List<DLFileRank> getFileRanks(long repositoryId, long userId) {
        return this.dlFileRankLocalService.getFileRanks(repositoryId, userId);
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return this.dlFileShortcutLocalService.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        LocalRepository localRepository = this.getFileVersionLocalRepository(fileVersionId);
        return localRepository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        LocalRepository localRepository = this.getFolderLocalRepository(folderId);
        return localRepository.getFolder(folderId);
    }

    public Folder getFolder(long repositoryId, long parentFolderId, String name) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFolder(parentFolderId, name);
    }

    public Folder getMountFolder(long repositoryId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getMountFolder(repositoryId);
        return new LiferayFolder(dlFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(FileEntry.class);
        try {
            LocalRepository fromLocalRepository = this.getFileEntryLocalRepository(fileEntryId);
            LocalRepository toLocalRepository = this.getFolderLocalRepository(newFolderId, serviceContext.getScopeGroupId());
            if (fromLocalRepository.getRepositoryId() == toLocalRepository.getRepositoryId()) {
                FileEntry fileEntry;
                FileEntry fileEntry2 = fileEntry = fromLocalRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
                return fileEntry2;
            }
            FileEntry fileEntry = this.moveFileEntries(userId, fileEntryId, newFolderId, fromLocalRepository, toLocalRepository, serviceContext);
            return fileEntry;
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(FileEntry.class);
        }
    }

    public FileEntry moveFileEntryFromTrash(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.getFileEntryLocalRepository(fileEntryId);
        if (!localRepository.isCapabilityProvided(TrashCapability.class)) {
            throw new InvalidRepositoryException("Repository " + localRepository.getRepositoryId() + " does not support trash operations");
        }
        TrashCapability trashCapability = (TrashCapability)localRepository.getCapability(TrashCapability.class);
        FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
        Folder destinationFolder = localRepository.getFolder(newFolderId);
        return trashCapability.moveFileEntryFromTrash(userId, fileEntry, destinationFolder, serviceContext);
    }

    public FileEntry moveFileEntryToTrash(long userId, long fileEntryId) throws PortalException {
        LocalRepository localRepository = this.getFileEntryLocalRepository(fileEntryId);
        TrashCapability trashCapability = (TrashCapability)localRepository.getCapability(TrashCapability.class);
        FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
        return trashCapability.moveFileEntryToTrash(userId, fileEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(Folder.class);
        try {
            Folder toFolder;
            LocalRepository sourceLocalRepository = this.getFolderLocalRepository(folderId);
            LocalRepository destinationLocalRepository = this.getFolderLocalRepository(parentFolderId, serviceContext.getScopeGroupId());
            if (parentFolderId != 0L && (toFolder = destinationLocalRepository.getFolder(parentFolderId)).isMountPoint()) {
                destinationLocalRepository = this.getLocalRepository(toFolder.getRepositoryId());
            }
            Folder folder = null;
            folder = sourceLocalRepository.getRepositoryId() == destinationLocalRepository.getRepositoryId() ? sourceLocalRepository.moveFolder(userId, folderId, parentFolderId, serviceContext) : this.moveFolders(userId, folderId, parentFolderId, sourceLocalRepository, destinationLocalRepository, serviceContext);
            Folder folder2 = folder;
            return folder2;
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(Folder.class);
        }
    }

    public void restoreFileEntryFromTrash(long userId, long fileEntryId) throws PortalException {
        LocalRepository localRepository = this.getFileEntryLocalRepository(fileEntryId);
        TrashCapability trashCapability = (TrashCapability)localRepository.getCapability(TrashCapability.class);
        FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
        trashCapability.restoreFileEntryFromTrash(userId, fileEntry);
    }

    public void subscribeFileEntryType(long userId, long groupId, long fileEntryTypeId) throws PortalException {
        if (fileEntryTypeId == 0L) {
            fileEntryTypeId = groupId;
        }
        this.subscriptionLocalService.addSubscription(userId, groupId, DLFileEntryType.class.getName(), fileEntryTypeId);
    }

    public void subscribeFolder(long userId, long groupId, long folderId) throws PortalException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this.subscriptionLocalService.addSubscription(userId, groupId, Folder.class.getName(), folderId);
    }

    public void unsubscribeFileEntryType(long userId, long groupId, long fileEntryTypeId) throws PortalException {
        if (fileEntryTypeId == 0L) {
            fileEntryTypeId = groupId;
        }
        this.subscriptionLocalService.deleteSubscription(userId, DLFileEntryType.class.getName(), fileEntryTypeId);
    }

    public void unsubscribeFolder(long userId, long groupId, long folderId) throws PortalException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this.subscriptionLocalService.deleteSubscription(userId, Folder.class.getName(), folderId);
    }

    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        LocalRepository localRepository = this.getFileEntryLocalRepository(fileEntry.getFileEntryId());
        localRepository.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, byte[] bytes, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, null, 0L, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        LocalRepository localRepository = this.getFileEntryLocalRepository(fileEntryId);
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion(true));
        this.dlAppHelperLocalService.updateFileEntry(userId, fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            String extension = DLAppUtil.getExtension(title, sourceFileName);
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)is);
                    FileEntry fileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioe) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioe);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        LocalRepository localRepository = this.getFileEntryLocalRepository(fileEntryId);
        FileEntry oldFileEntry = localRepository.getFileEntry(fileEntryId);
        FileVersion oldFileVersion = oldFileEntry.getFileVersion();
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        if (is != null) {
            DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion(true));
            oldFileVersion = null;
        }
        this.dlAppHelperLocalService.updateFileEntry(userId, fileEntry, oldFileVersion, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public DLFileRank updateFileRank(long repositoryId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) {
        return this.dlFileRankLocalService.updateFileRank(repositoryId, companyId, userId, fileEntryId, serviceContext);
    }

    public DLFileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this.dlFileShortcutLocalService.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long toRepositoryId, long oldToFileEntryId, long newToFileEntryId) {
        this.dlFileShortcutLocalService.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.getFolderLocalRepository(folderId);
        Folder folder = localRepository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
        if (folderId != 0L) {
            this.dlAppHelperLocalService.updateFolder(serviceContext.getUserId(), folder, serviceContext);
        }
        return folder;
    }

    protected FileEntry copyFileEntry(long userId, LocalRepository toLocalRepository, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        List fileVersions = fileEntry.getFileVersions(-1);
        FileVersion latestFileVersion = (FileVersion)fileVersions.get(fileVersions.size() - 1);
        FileEntry destinationFileEntry = toLocalRepository.addFileEntry(userId, newFolderId, fileEntry.getTitle(), latestFileVersion.getMimeType(), latestFileVersion.getTitle(), latestFileVersion.getDescription(), "", latestFileVersion.getContentStream(false), latestFileVersion.getSize(), serviceContext);
        for (int i = fileVersions.size() - 2; i >= 0; --i) {
            FileVersion fileVersion = (FileVersion)fileVersions.get(i);
            FileVersion previousFileVersion = (FileVersion)fileVersions.get(i + 1);
            try {
                destinationFileEntry = toLocalRepository.updateFileEntry(userId, destinationFileEntry.getFileEntryId(), fileEntry.getTitle(), destinationFileEntry.getMimeType(), destinationFileEntry.getTitle(), destinationFileEntry.getDescription(), "", DLAppUtil.isMajorVersion(fileVersion, previousFileVersion), fileVersion.getContentStream(false), fileVersion.getSize(), serviceContext);
                continue;
            }
            catch (PortalException pe) {
                toLocalRepository.deleteFileEntry(destinationFileEntry.getFileEntryId());
                throw pe;
            }
        }
        this.dlAppHelperLocalService.addFileEntry(userId, destinationFileEntry, destinationFileEntry.getFileVersion(), serviceContext);
        return destinationFileEntry;
    }

    protected void deleteFileEntry(long oldFileEntryId, long newFileEntryId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository) throws PortalException {
        try {
            FileEntry fileEntry = fromLocalRepository.getFileEntry(oldFileEntryId);
            fromLocalRepository.deleteFileEntry(oldFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        catch (PortalException pe) {
            FileEntry fileEntry = toLocalRepository.getFileEntry(newFileEntryId);
            toLocalRepository.deleteFileEntry(newFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
            throw pe;
        }
    }

    protected void deleteRepository(LocalRepository localRepository) throws PortalException {
        long repositoryId = localRepository.getRepositoryId();
        this.dlAppHelperLocalService.deleteRepositoryFileEntries(repositoryId);
        localRepository.deleteAll();
        this.repositoryLocalService.deleteRepository(repositoryId);
    }

    protected LocalRepository getFileEntryLocalRepository(long fileEntryId) throws PortalException {
        try {
            return this.repositoryLocalService.getLocalRepositoryImpl(0L, fileEntryId, 0L);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileEntry exists with the key {fileEntryId=");
            sb.append(fileEntryId);
            sb.append("}");
            throw new NoSuchFileEntryException(sb.toString(), (Throwable)irie);
        }
    }

    protected LocalRepository getFileVersionLocalRepository(long fileVersionId) throws PortalException {
        try {
            return this.repositoryLocalService.getLocalRepositoryImpl(0L, 0L, fileVersionId);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileVersion exists with the key {fileVersionId=");
            sb.append(fileVersionId);
            sb.append("}");
            throw new NoSuchFileVersionException(sb.toString(), (Throwable)irie);
        }
    }

    protected LocalRepository getFolderLocalRepository(long folderId) throws PortalException {
        try {
            return this.repositoryLocalService.getLocalRepositoryImpl(folderId, 0L, 0L);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No Folder exists with the key {folderId=");
            sb.append(folderId);
            sb.append("}");
            throw new NoSuchFolderException(sb.toString(), (Throwable)irie);
        }
    }

    protected LocalRepository getFolderLocalRepository(long folderId, long groupId) throws PortalException {
        LocalRepository localRepository = null;
        localRepository = folderId == 0L ? this.getLocalRepository(groupId) : this.getFolderLocalRepository(folderId);
        return localRepository;
    }

    protected LocalRepository getLocalRepository(long repositoryId) throws PortalException {
        try {
            return this.repositoryLocalService.getLocalRepositoryImpl(repositoryId);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No Group exists with the key {repositoryId=");
            sb.append(repositoryId);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString(), (Throwable)irie);
        }
    }

    protected FileEntry moveFileEntries(long userId, long fileEntryId, long newFolderId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        FileEntry sourceFileEntry = fromLocalRepository.getFileEntry(fileEntryId);
        FileEntry destinationFileEntry = this.copyFileEntry(userId, toLocalRepository, sourceFileEntry, newFolderId, serviceContext);
        this.deleteFileEntry(fileEntryId, destinationFileEntry.getFileEntryId(), fromLocalRepository, toLocalRepository);
        return destinationFileEntry;
    }

    protected Folder moveFolders(long userId, long folderId, long parentFolderId, LocalRepository sourceLocalRepository, LocalRepository destinationLocalRepository, ServiceContext serviceContext) throws PortalException {
        Folder sourceFolder = sourceLocalRepository.getFolder(folderId);
        Folder destinationFolder = destinationLocalRepository.addFolder(userId, parentFolderId, sourceFolder.getName(), sourceFolder.getDescription(), serviceContext);
        this.dlAppHelperLocalService.addFolder(userId, destinationFolder, serviceContext);
        List foldersAndFileEntriesAndFileShortcuts = this.dlAppService.getFoldersAndFileEntriesAndFileShortcuts(sourceLocalRepository.getRepositoryId(), folderId, -1, true, -1, -1);
        try {
            for (Object folderAndFileEntryAndFileShortcut : foldersAndFileEntriesAndFileShortcuts) {
                if (folderAndFileEntryAndFileShortcut instanceof FileEntry) {
                    FileEntry fileEntry = (FileEntry)folderAndFileEntryAndFileShortcut;
                    this.copyFileEntry(userId, destinationLocalRepository, fileEntry, destinationFolder.getFolderId(), serviceContext);
                    continue;
                }
                if (folderAndFileEntryAndFileShortcut instanceof Folder) {
                    Folder folder = (Folder)folderAndFileEntryAndFileShortcut;
                    this.moveFolders(userId, folder.getFolderId(), destinationFolder.getFolderId(), sourceLocalRepository, destinationLocalRepository, serviceContext);
                    continue;
                }
                if (!(folderAndFileEntryAndFileShortcut instanceof DLFileShortcut) || !destinationFolder.isSupportsShortcuts()) continue;
                DLFileShortcut dlFileShorcut = (DLFileShortcut)folderAndFileEntryAndFileShortcut;
                this.dlFileShortcutLocalService.addFileShortcut(userId, dlFileShorcut.getGroupId(), destinationFolder.getFolderId(), dlFileShorcut.getToFileEntryId(), serviceContext);
            }
        }
        catch (PortalException pe) {
            destinationLocalRepository.deleteFolder(destinationFolder.getFolderId());
            throw pe;
        }
        try {
            sourceLocalRepository.deleteFolder(folderId);
        }
        catch (PortalException pe) {
            destinationLocalRepository.deleteFolder(destinationFolder.getFolderId());
            throw pe;
        }
        return destinationFolder;
    }
}

