/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.event.TrashRepositoryEventType;
import com.liferay.portal.kernel.repository.event.WorkflowRepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Lock;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.documentlibrary.DLSettings;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.base.DLAppHelperLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppHelperThreadLocal;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;

public class DLAppHelperLocalServiceImpl
extends DLAppHelperLocalServiceBaseImpl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileEntry(long userId, FileEntry fileEntry, FileVersion fileVersion, ServiceContext serviceContext) throws PortalException {
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.updateAsset(userId, fileEntry, fileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
            if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
                this.mbMessageLocalService.addDiscussionMessage(fileEntry.getUserId(), fileEntry.getUserName(), fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 1);
            }
        }
        boolean previousEnabled = WorkflowThreadLocal.isEnabled();
        if (!DLAppHelperThreadLocal.isEnabled()) {
            WorkflowThreadLocal.setEnabled((boolean)false);
        }
        try {
            if (fileVersion instanceof LiferayFileVersion) {
                DLUtil.startWorkflowInstance((long)userId, (DLFileVersion)((DLFileVersion)fileVersion.getModel()), (String)"add", (ServiceContext)serviceContext);
            }
        }
        finally {
            if (!DLAppHelperThreadLocal.isEnabled()) {
                WorkflowThreadLocal.setEnabled((boolean)previousEnabled);
            }
        }
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.registerDLProcessorCallback(fileEntry, null);
        }
    }

    public void addFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
    }

    public void cancelCheckOut(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, FileVersion draftFileVersion, ServiceContext serviceContext) throws PortalException {
        this.updateFileEntry(userId, fileEntry, sourceFileVersion, destinationFileVersion, serviceContext);
        if (draftFileVersion == null) {
            return;
        }
        AssetEntry draftAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), draftFileVersion.getPrimaryKey());
        if (draftAssetEntry != null) {
            this.assetEntryLocalService.deleteEntry(draftAssetEntry);
        }
    }

    public void checkAssetEntry(long userId, FileEntry fileEntry, FileVersion fileVersion) throws PortalException {
        AssetEntry fileVersionAssetEntry;
        AssetEntry fileEntryAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        long[] assetCategoryIds = new long[]{};
        String[] assetTagNames = new String[]{};
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (fileEntryAssetEntry == null) {
            fileEntryAssetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
        }
        if ((fileVersionAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId())) == null && !fileVersion.isApproved() && !fileVersion.getVersion().equals("1.0")) {
            assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            fileVersionAssetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            List assetLinks = this.assetLinkLocalService.getDirectLinks(fileEntryAssetEntry.getEntryId());
            long[] assetLinkIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
            this.assetLinkLocalService.updateLinks(userId, fileVersionAssetEntry.getEntryId(), assetLinkIds, 0);
        }
    }

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException {
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.subscriptionLocalService.deleteSubscriptions(fileEntry.getCompanyId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            DLProcessorRegistryUtil.cleanUp((FileEntry)fileEntry);
            this.dlFileRankLocalService.deleteFileRanksByFileEntryId(fileEntry.getFileEntryId());
            this.dlFileShortcutLocalService.deleteFileShortcuts(fileEntry.getFileEntryId());
            this.assetEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            this.mbMessageLocalService.deleteDiscussionMessages(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            this.ratingsStatsLocalService.deleteStats(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        }
    }

    public void deleteFolder(Folder folder) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.assetEntryLocalService.deleteEntry(DLFolderConstants.getClassName(), folder.getFolderId());
    }

    public void deleteRepositoryFileEntries(long repositoryId) throws PortalException {
        LocalRepository localRepository = this.repositoryLocalService.getLocalRepositoryImpl(repositoryId);
        List fileEntries = localRepository.getRepositoryFileEntries(0L, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this.deleteFileEntry(fileEntry);
        }
    }

    public void getFileAsStream(long userId, FileEntry fileEntry, boolean incrementCounter) {
        if (!incrementCounter) {
            return;
        }
        if (userId > 0L) {
            this.dlFileRankLocalService.updateFileRank(fileEntry.getGroupId(), fileEntry.getCompanyId(), userId, fileEntry.getFileEntryId(), new ServiceContext());
        }
        this.assetEntryLocalService.incrementViewCounter(userId, DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 1);
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.assetEntryLocalService.incrementViewCounter(userId, DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), 1);
        }
    }

    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, boolean active, int status) {
        return this.dlFileShortcutPersistence.findByG_F_A_S(groupId, folderId, active, status);
    }

    @Deprecated
    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, int status) {
        return this.getFileShortcuts(groupId, folderId, true, status);
    }

    public int getFileShortcutsCount(long groupId, long folderId, boolean active, int status) {
        return this.dlFileShortcutPersistence.countByG_F_A_S(groupId, folderId, active, status);
    }

    @Deprecated
    public int getFileShortcutsCount(long groupId, long folderId, int status) {
        return this.getFileShortcutsCount(groupId, folderId, true, status);
    }

    public List<FileEntry> getNoAssetFileEntries() {
        return null;
    }

    public void moveDependentsToTrash(List<Object> dlFileEntriesAndDLFolders, long trashEntryId) throws PortalException {
        for (Object object : dlFileEntriesAndDLFolders) {
            DLFolder dlFolder;
            if (object instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                if (dlFileEntry.isInTrashExplicitly()) continue;
                this.dlFileShortcutLocalService.disableFileShortcuts(dlFileEntry.getFileEntryId());
                List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), -1);
                for (DLFileVersion dlFileVersion : dlFileVersions) {
                    int oldStatus = dlFileVersion.getStatus();
                    dlFileVersion.setStatus(8);
                    this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
                    int status = oldStatus;
                    if (oldStatus == 1) {
                        status = 2;
                    }
                    if (oldStatus != 0) {
                        this.trashVersionLocalService.addTrashVersion(trashEntryId, DLFileVersion.class.getName(), dlFileVersion.getFileVersionId(), status, null);
                    }
                    if (oldStatus != 1) continue;
                    this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), dlFileVersion.getGroupId(), DLFileEntryConstants.getClassName(), dlFileVersion.getFileVersionId());
                }
                this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId(), false);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
                indexer.reindex((Object)dlFileEntry);
                continue;
            }
            if (object instanceof DLFileShortcut) {
                DLFileShortcut dlFileShortcut = (DLFileShortcut)object;
                if (dlFileShortcut.isInTrash()) continue;
                int oldStatus = dlFileShortcut.getStatus();
                dlFileShortcut.setStatus(8);
                this.dlFileShortcutPersistence.update((BaseModel)dlFileShortcut);
                if (oldStatus == 0) continue;
                this.trashVersionLocalService.addTrashVersion(trashEntryId, DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), oldStatus, null);
                continue;
            }
            if (!(object instanceof DLFolder) || (dlFolder = (DLFolder)object).isInTrashExplicitly()) continue;
            int oldStatus = dlFolder.getStatus();
            dlFolder.setStatus(8);
            this.dlFolderPersistence.update((BaseModel)dlFolder);
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntryId, DLFolder.class.getName(), dlFolder.getFolderId(), oldStatus, null);
            }
            QueryDefinition queryDefinition = new QueryDefinition(-1);
            List foldersAndFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), null, false, queryDefinition);
            this.moveDependentsToTrash(foldersAndFileEntriesAndFileShortcuts, trashEntryId);
            this.assetEntryLocalService.updateVisible(DLFolderConstants.getClassName(), dlFolder.getFolderId(), false);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
            indexer.reindex((Object)dlFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntry.getFileEntryId());
        if (!hasLock) {
            this.dlFileEntryLocalService.lockFileEntry(userId, fileEntry.getFileEntryId());
        }
        try {
            FileEntry fileEntry2 = this.doMoveFileEntryFromTrash(userId, fileEntry, newFolderId, serviceContext);
            return fileEntry2;
        }
        finally {
            if (!hasLock) {
                this.dlFileEntryLocalService.unlockFileEntry(fileEntry.getFileEntryId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        boolean hasLock = this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntry.getFileEntryId());
        if (!hasLock) {
            this.dlFileEntryLocalService.lockFileEntry(userId, fileEntry.getFileEntryId());
        }
        try {
            FileEntry fileEntry2 = this.doMoveFileEntryToTrash(userId, fileEntry);
            return fileEntry2;
        }
        finally {
            if (!hasLock) {
                this.dlFileEntryLocalService.unlockFileEntry(fileEntry.getFileEntryId());
            }
        }
    }

    public DLFileShortcut moveFileShortcutFromTrash(long userId, DLFileShortcut dlFileShortcut, long newFolderId, ServiceContext serviceContext) throws PortalException {
        if (dlFileShortcut.isInTrashExplicitly()) {
            this.restoreFileShortcutFromTrash(userId, dlFileShortcut);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.dlFileShortcutLocalService.updateStatus(userId, dlFileShortcut.getFileShortcutId(), status, new ServiceContext());
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("title", dlFileShortcut.getToTitle());
            this.socialActivityLocalService.addActivity(userId, dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), 10008, extraDataJSONObject.toString(), 0L);
        }
        return this.dlAppService.updateFileShortcut(dlFileShortcut.getFileShortcutId(), newFolderId, dlFileShortcut.getToFileEntryId(), serviceContext);
    }

    public DLFileShortcut moveFileShortcutToTrash(long userId, DLFileShortcut dlFileShortcut) throws PortalException {
        int oldStatus = dlFileShortcut.getStatus();
        this.dlFileShortcutLocalService.updateStatus(userId, dlFileShortcut.getFileShortcutId(), 8, new ServiceContext());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", TrashUtil.getOriginalTitle((String)dlFileShortcut.getToTitle()));
        this.socialActivityLocalService.addActivity(userId, dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), 10007, extraDataJSONObject.toString(), 0L);
        this.trashEntryLocalService.addTrashEntry(userId, dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUuid(), null, oldStatus, null, null);
        return dlFileShortcut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this.dlFolderLocalService.hasFolderLock(userId, folder.getFolderId());
        Lock lock = null;
        if (!hasLock) {
            lock = this.dlFolderLocalService.lockFolder(userId, folder.getFolderId());
        }
        try {
            Folder folder2 = this.doMoveFolderFromTrash(userId, folder, parentFolderId, serviceContext);
            return folder2;
        }
        finally {
            if (!hasLock) {
                this.dlFolderLocalService.unlockFolder(folder.getFolderId(), lock.getUuid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolderToTrash(long userId, Folder folder) throws PortalException {
        boolean hasLock = this.dlFolderLocalService.hasFolderLock(userId, folder.getFolderId());
        Lock lock = null;
        if (!hasLock) {
            lock = this.dlFolderLocalService.lockFolder(userId, folder.getFolderId());
        }
        try {
            Folder folder2 = this.doMoveFolderToTrash(userId, folder);
            return folder2;
        }
        finally {
            if (!hasLock) {
                this.dlFolderLocalService.unlockFolder(folder.getFolderId(), lock.getUuid());
            }
        }
    }

    public void restoreDependentsFromTrash(List<Object> dlFileEntriesAndDLFolders) throws PortalException {
        for (Object object : dlFileEntriesAndDLFolders) {
            DLFolder dlFolder;
            TrashVersion trashVersion;
            if (object instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                if (!dlFileEntry.isInTrashImplicitly()) continue;
                this.dlFileShortcutLocalService.enableFileShortcuts(dlFileEntry.getFileEntryId());
                List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), 8);
                for (DLFileVersion dlFileVersion : dlFileVersions) {
                    TrashVersion trashVersion2 = this.trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), dlFileVersion.getFileVersionId());
                    int oldStatus = 0;
                    if (trashVersion2 != null) {
                        oldStatus = trashVersion2.getStatus();
                    }
                    dlFileVersion.setStatus(oldStatus);
                    this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
                    if (trashVersion2 == null) continue;
                    this.trashVersionLocalService.deleteTrashVersion(trashVersion2);
                }
                DLFileVersion latestDlFileVersion = dlFileEntry.getLatestFileVersion(false);
                if (latestDlFileVersion.isApproved()) {
                    this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId(), true);
                }
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
                indexer.reindex((Object)dlFileEntry);
                continue;
            }
            if (object instanceof DLFileShortcut) {
                DLFileShortcut dlFileShortcut = (DLFileShortcut)object;
                if (!dlFileShortcut.isInTrashImplicitly()) continue;
                trashVersion = this.trashVersionLocalService.fetchVersion(DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId());
                int oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                dlFileShortcut.setStatus(oldStatus);
                this.dlFileShortcutPersistence.update((BaseModel)dlFileShortcut);
                if (trashVersion == null) continue;
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
                continue;
            }
            if (!(object instanceof DLFolder) || !(dlFolder = (DLFolder)object).isInTrashImplicitly()) continue;
            trashVersion = this.trashVersionLocalService.fetchVersion(DLFolder.class.getName(), dlFolder.getFolderId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            dlFolder.setStatus(oldStatus);
            this.dlFolderPersistence.update((BaseModel)dlFolder);
            QueryDefinition queryDefinition = new QueryDefinition(8);
            List foldersAndFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), null, false, queryDefinition);
            this.restoreDependentsFromTrash(foldersAndFileEntriesAndFileShortcuts);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.assetEntryLocalService.updateVisible(DLFolderConstants.getClassName(), dlFolder.getFolderId(), true);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
            indexer.reindex((Object)dlFolder);
        }
    }

    @Deprecated
    public void restoreDependentsFromTrash(List<Object> dlFileEntriesAndDLFolders, long trashEntryId) throws PortalException {
        this.restoreDependentsFromTrash(dlFileEntriesAndDLFolders);
    }

    public void restoreFileEntryFromTrash(long userId, FileEntry fileEntry) throws PortalException {
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        dlFileEntry.setFileName(TrashUtil.getOriginalTitle((String)dlFileEntry.getTitle(), (String)"fileName"));
        dlFileEntry.setTitle(TrashUtil.getOriginalTitle((String)dlFileEntry.getTitle()));
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        FileVersion fileVersion = fileEntry.getFileVersion();
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        this.dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), trashEntry.getStatus(), new ServiceContext(), new HashMap());
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.dlFileRankLocalService.enableFileRanks(fileEntry.getFileEntryId());
            this.dlFileShortcutLocalService.enableFileShortcuts(fileEntry.getFileEntryId());
            this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, FileEntry.class, fileEntry);
        }
        List trashVersions = this.trashVersionLocalService.getVersions(trashEntry.getEntryId());
        for (TrashVersion trashVersion : trashVersions) {
            DLFileVersion trashDLFileVersion = this.dlFileVersionPersistence.findByPrimaryKey(trashVersion.getClassPK());
            trashDLFileVersion.setStatus(trashVersion.getStatus());
            this.dlFileVersionPersistence.update((BaseModel)trashDLFileVersion);
        }
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", fileEntry.getTitle());
        this.socialActivityLocalService.addActivity(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 10008, extraDataJSONObject.toString(), 0L);
    }

    public void restoreFileShortcutFromTrash(long userId, DLFileShortcut dlFileShortcut) throws PortalException {
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId());
        this.dlFileShortcutLocalService.updateStatus(userId, dlFileShortcut.getFileShortcutId(), trashEntry.getStatus(), new ServiceContext());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", dlFileShortcut.getToTitle());
        this.socialActivityLocalService.addActivity(userId, dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), 10008, extraDataJSONObject.toString(), 0L);
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
    }

    public void restoreFolderFromTrash(long userId, Folder folder) throws PortalException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        dlFolder.setName(TrashUtil.getOriginalTitle((String)dlFolder.getName()));
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFolder.class.getName(), dlFolder.getFolderId());
        this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), trashEntry.getStatus(), new HashMap(), new ServiceContext());
        this.dlFileRankLocalService.enableFileRanksByFolderId(folder.getFolderId());
        QueryDefinition queryDefinition = new QueryDefinition(8);
        List foldersAndFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), null, false, queryDefinition);
        this.dlAppHelperLocalService.restoreDependentsFromTrash(foldersAndFileEntriesAndFileShortcuts);
        this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, Folder.class, folder);
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", folder.getName());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), DLFolderConstants.getClassName(), folder.getFolderId(), 10008, extraDataJSONObject.toString(), 0L);
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long assetClassPk) throws PortalException {
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), assetClassPk);
        String[] assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), assetClassPk);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), assetClassPk);
        List assetLinks = this.assetLinkLocalService.getDirectLinks(assetEntry.getEntryId());
        long[] assetLinkIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        return this.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkIds);
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        AssetEntry assetEntry = null;
        boolean visible = false;
        boolean addDraftAssetEntry = false;
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
            if (dlFileVersion.isApproved()) {
                visible = true;
            } else {
                String version = dlFileVersion.getVersion();
                if (!version.equals("1.0")) {
                    addDraftAssetEntry = true;
                }
            }
        } else {
            visible = true;
        }
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (addDraftAssetEntry) {
            if (assetCategoryIds == null) {
                assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            }
            if (assetTagNames == null) {
                assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            }
            if (assetLinkEntryIds == null) {
                AssetEntry previousAssetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
                List assetLinks = this.assetLinkLocalService.getDirectLinks(previousAssetEntry.getEntryId(), 0);
                assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
            }
            assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
        } else {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, visible, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            List dlFileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
            for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
                this.assetEntryLocalService.updateEntry(userId, dlFileShortcut.getGroupId(), dlFileShortcut.getCreateDate(), dlFileShortcut.getModifiedDate(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            }
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
        return assetEntry;
    }

    public AssetEntry updateAsset(long userId, Folder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        AssetEntry assetEntry = null;
        boolean visible = false;
        if (folder instanceof LiferayFolder) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            if (dlFolder.isApproved() && !dlFolder.isHidden() && !dlFolder.isInHiddenFolder()) {
                visible = true;
            }
        } else {
            visible = true;
        }
        assetEntry = this.assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), DLFolderConstants.getClassName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, visible, null, null, null, null, folder.getName(), folder.getDescription(), null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
        return assetEntry;
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, long assetClassPk) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        boolean updateAsset = true;
        if (fileEntry instanceof LiferayFileEntry && fileEntry.getVersion().equals(destinationFileVersion.getVersion())) {
            updateAsset = false;
        }
        if (updateAsset) {
            this.updateAsset(userId, fileEntry, destinationFileVersion, assetClassPk);
        }
        this.registerDLProcessorCallback(fileEntry, sourceFileVersion);
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, ServiceContext serviceContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.updateAsset(userId, fileEntry, destinationFileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.registerDLProcessorCallback(fileEntry, sourceFileVersion);
    }

    public void updateFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException {
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
    }

    public void updateStatus(long userId, FileEntry fileEntry, FileVersion latestFileVersion, int oldStatus, int newStatus, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        if (newStatus == 0) {
            String event;
            String latestFileVersionVersion = latestFileVersion.getVersion();
            if (latestFileVersionVersion.equals(fileEntry.getVersion())) {
                AssetEntry assetEntry;
                AssetEntry draftAssetEntry;
                if (!latestFileVersionVersion.equals("1.0") && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), latestFileVersion.getPrimaryKey())) != null) {
                    long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0);
                    long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                    AssetEntry assetEntry2 = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, null, null, null, draftAssetEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
                    this.assetLinkLocalService.updateLinks(userId, assetEntry2.getEntryId(), assetLinkEntryIds, 0);
                    this.assetEntryLocalService.deleteEntry(draftAssetEntry);
                }
                if ((assetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId())) != null) {
                    this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), true);
                }
            }
            if (Validator.isNotNull((String)(event = GetterUtil.getString((Object)workflowContext.get("event"))))) {
                this.triggerRepositoryEvent(fileEntry.getRepositoryId(), this.getWorkflowRepositoryEventTypeClass(event), FileEntry.class, fileEntry);
            }
            if (oldStatus != 8 && !fileEntry.isInTrash()) {
                Date activityCreateDate = latestFileVersion.getModifiedDate();
                int activityType = 2;
                if (event.equals("add")) {
                    activityCreateDate = latestFileVersion.getCreateDate();
                    activityType = 1;
                }
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("title", fileEntry.getTitle());
                this.socialActivityLocalService.addUniqueActivity(latestFileVersion.getStatusByUserId(), fileEntry.getGroupId(), activityCreateDate, DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), activityType, extraDataJSONObject.toString(), 0L);
                this.notifySubscribers(latestFileVersion, (String)((Object)workflowContext.get("url")), serviceContext);
            }
        } else {
            List approvedFileVersions;
            boolean visible = false;
            if (newStatus != 8 && !(approvedFileVersions = this.dlFileVersionPersistence.findByF_S(fileEntry.getFileEntryId(), 0)).isEmpty()) {
                visible = true;
            }
            this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), visible);
        }
    }

    protected FileEntry doMoveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        if (dlFileEntry.isInTrashExplicitly()) {
            this.restoreFileEntryFromTrash(userId, fileEntry);
            fileEntry = this.dlAppLocalService.moveFileEntry(userId, fileEntry.getFileEntryId(), newFolderId, serviceContext);
            if (DLAppHelperThreadLocal.isEnabled()) {
                this.dlFileRankLocalService.enableFileRanks(fileEntry.getFileEntryId());
            }
            return fileEntry;
        }
        List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), 8);
        dlFileVersions = ListUtil.sort((List)dlFileVersions, (Comparator)new FileVersionVersionComparator());
        LiferayFileVersion fileVersion = new LiferayFileVersion((DLFileVersion)dlFileVersions.get(0));
        TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), fileVersion.getFileVersionId());
        int oldStatus = 0;
        if (trashVersion != null) {
            oldStatus = trashVersion.getStatus();
        }
        this.dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), oldStatus, serviceContext, new HashMap());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            trashVersion = this.trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), dlFileVersion.getFileVersionId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            dlFileVersion.setStatus(oldStatus);
            this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
            if (trashVersion == null) continue;
            this.trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.dlFileRankLocalService.enableFileRanks(fileEntry.getFileEntryId());
            this.dlFileShortcutLocalService.enableFileShortcuts(fileEntry.getFileEntryId());
        }
        fileEntry = this.dlAppService.moveFileEntry(fileEntry.getFileEntryId(), newFolderId, serviceContext);
        this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, FileEntry.class, fileEntry);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", fileEntry.getTitle());
        this.socialActivityLocalService.addActivity(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 10008, extraDataJSONObject.toString(), 0L);
        return fileEntry;
    }

    protected FileEntry doMoveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), -1);
        dlFileVersions = ListUtil.sort((List)dlFileVersions, (Comparator)new FileVersionVersionComparator());
        List<Object> dlFileVersionStatusOVPs = new ArrayList();
        if (dlFileVersions != null && !dlFileVersions.isEmpty()) {
            dlFileVersionStatusOVPs = this.getDlFileVersionStatuses(dlFileVersions);
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        int oldStatus = fileVersion.getStatus();
        this.dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), 8, new ServiceContext(), new HashMap());
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.dlFileShortcutLocalService.disableFileShortcuts(fileEntry.getFileEntryId());
            this.dlFileRankLocalService.disableFileRanks(fileEntry.getFileEntryId());
            this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryTrashed.class, FileEntry.class, fileEntry);
        }
        DLFileVersion oldDLFileVersion = (DLFileVersion)fileVersion.getModel();
        int oldDLFileVersionStatus = oldDLFileVersion.getStatus();
        for (DLFileVersion curDLFileVersion : dlFileVersions) {
            curDLFileVersion.setStatus(8);
            this.dlFileVersionPersistence.update((BaseModel)curDLFileVersion);
        }
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("fileName", dlFileEntry.getFileName());
        typeSettingsProperties.put("title", dlFileEntry.getTitle());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, dlFileEntry.getGroupId(), DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId(), dlFileEntry.getUuid(), dlFileEntry.getClassName(), oldDLFileVersionStatus, dlFileVersionStatusOVPs, typeSettingsProperties);
        String trashTitle = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        dlFileEntry.setFileName(trashTitle);
        dlFileEntry.setTitle(trashTitle);
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return fileEntry;
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", TrashUtil.getOriginalTitle((String)fileEntry.getTitle()));
        this.socialActivityLocalService.addActivity(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 10007, extraDataJSONObject.toString(), 0L);
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(fileVersion.getCompanyId(), fileVersion.getGroupId(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId());
        }
        return fileEntry;
    }

    protected Folder doMoveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (dlFolder.isInTrashExplicitly()) {
            this.restoreFolderFromTrash(userId, folder);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(DLFolder.class.getName(), dlFolder.getFolderId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), status, new HashMap(), new ServiceContext());
            this.dlFileRankLocalService.enableFileRanksByFolderId(folder.getFolderId());
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            QueryDefinition queryDefinition = new QueryDefinition(8);
            List foldersAndFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), null, false, queryDefinition);
            this.dlAppHelperLocalService.restoreDependentsFromTrash(foldersAndFileEntriesAndFileShortcuts);
            this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, Folder.class, folder);
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("title", folder.getName());
            this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), DLFolderConstants.class.getName(), folder.getFolderId(), 10008, extraDataJSONObject.toString(), 0L);
        }
        return this.dlAppLocalService.moveFolder(userId, folder.getFolderId(), parentFolderId, serviceContext);
    }

    protected Folder doMoveFolderToTrash(long userId, Folder folder) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), 8, new HashMap(), new ServiceContext());
        this.dlFileRankLocalService.disableFileRanksByFolderId(folder.getFolderId());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", dlFolder.getName());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, dlFolder.getGroupId(), DLFolderConstants.getClassName(), dlFolder.getFolderId(), dlFolder.getUuid(), null, 0, null, typeSettingsProperties);
        dlFolder.setName(TrashUtil.getTrashTitle((long)trashEntry.getEntryId()));
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        List foldersAndFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), null, false, queryDefinition);
        this.dlAppHelperLocalService.moveDependentsToTrash(foldersAndFileEntriesAndFileShortcuts, trashEntry.getEntryId());
        this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryTrashed.class, Folder.class, folder);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", folder.getName());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), DLFolderConstants.getClassName(), folder.getFolderId(), 10007, extraDataJSONObject.toString(), 0L);
        return new LiferayFolder(dlFolder);
    }

    protected List<ObjectValuePair<Long, Integer>> getDlFileVersionStatuses(List<DLFileVersion> dlFileVersions) {
        ArrayList<ObjectValuePair<Long, Integer>> dlFileVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(dlFileVersions.size());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            int status = dlFileVersion.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair dlFileVersionStatusOVP = new ObjectValuePair((Object)dlFileVersion.getFileVersionId(), (Object)status);
            dlFileVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)dlFileVersionStatusOVP);
        }
        return dlFileVersionStatusOVPs;
    }

    protected long getFileEntryTypeId(FileEntry fileEntry) {
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            return dlFileEntry.getFileEntryTypeId();
        }
        return 0L;
    }

    protected Class<? extends WorkflowRepositoryEventType> getWorkflowRepositoryEventTypeClass(String syncEvent) {
        if (syncEvent.equals("add")) {
            return WorkflowRepositoryEventType.Add.class;
        }
        if (syncEvent.equals("update")) {
            return WorkflowRepositoryEventType.Update.class;
        }
        throw new IllegalArgumentException(String.format("Unsupported sync event %s", syncEvent));
    }

    protected void notifySubscribers(FileVersion fileVersion, String entryURL, ServiceContext serviceContext) throws PortalException {
        if (!fileVersion.isApproved() || Validator.isNull((String)entryURL)) {
            return;
        }
        DLSettings dlSettings = DLSettings.getInstance(fileVersion.getGroupId());
        if (!(serviceContext.isCommandAdd() && dlSettings.isEmailFileEntryAddedEnabled() || serviceContext.isCommandUpdate() && dlSettings.isEmailFileEntryUpdatedEnabled())) {
            return;
        }
        String entryTitle = fileVersion.getTitle();
        String fromName = dlSettings.getEmailFromName();
        String fromAddress = dlSettings.getEmailFromAddress();
        LocalizedValuesMap localizedSubjectMap = null;
        LocalizedValuesMap localizedBodyMap = null;
        if (serviceContext.isCommandUpdate()) {
            localizedSubjectMap = dlSettings.getEmailFileEntryUpdatedSubject();
            localizedBodyMap = dlSettings.getEmailFileEntryUpdatedBody();
        } else {
            localizedSubjectMap = dlSettings.getEmailFileEntryAddedSubject();
            localizedBodyMap = dlSettings.getEmailFileEntryAddedBody();
        }
        FileEntry fileEntry = fileVersion.getFileEntry();
        Folder folder = null;
        long folderId = fileEntry.getFolderId();
        if (folderId != 0L) {
            folder = this.dlAppLocalService.getFolder(folderId);
        }
        String folderName = LanguageUtil.get((Locale)serviceContext.getLocale(), (String)"home");
        if (folder != null) {
            folderName = folder.getName();
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypeLocalService.getDLFileEntryType(dlFileEntry.getFileEntryTypeId());
        subscriptionSender.setClassPK(fileVersion.getFileEntryId());
        subscriptionSender.setClassName(DLFileEntryConstants.getClassName());
        subscriptionSender.setCompanyId(fileVersion.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$DOCUMENT_STATUS_BY_USER_NAME$]", fileVersion.getStatusByUserName(), "[$DOCUMENT_TITLE$]", entryTitle, "[$DOCUMENT_TYPE$]", dlFileEntryType.getName(serviceContext.getLocale()), "[$DOCUMENT_URL$]", entryURL, "[$FOLDER_NAME$]", folderName});
        subscriptionSender.setContextUserPrefix("DOCUMENT");
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(entryURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap((Map)localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap((Map)localizedSubjectMap);
        subscriptionSender.setMailId("file_entry", new Object[]{fileVersion.getFileEntryId()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId("20");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(fileVersion.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(fileVersion.getUserId());
        subscriptionSender.addPersistedSubscribers(Folder.class.getName(), fileVersion.getGroupId());
        if (folder != null) {
            subscriptionSender.addPersistedSubscribers(Folder.class.getName(), folder.getFolderId());
            for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                subscriptionSender.addPersistedSubscribers(Folder.class.getName(), ancestorFolderId.longValue());
            }
        }
        if (dlFileEntryType.getFileEntryTypeId() == 0L) {
            subscriptionSender.addPersistedSubscribers(DLFileEntryType.class.getName(), fileVersion.getGroupId());
        } else {
            subscriptionSender.addPersistedSubscribers(DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId());
        }
        subscriptionSender.addPersistedSubscribers(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void registerDLProcessorCallback(final FileEntry fileEntry, final FileVersion fileVersion) {
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DLProcessorRegistryUtil.trigger((FileEntry)fileEntry, (FileVersion)fileVersion, (boolean)true);
                return null;
            }
        });
    }

    protected <T extends RepositoryModel<T>> void triggerRepositoryEvent(long repositoryId, Class<? extends RepositoryEventType> repositoryEventType, Class<T> modelClass, T target) throws PortalException {
        Repository repository = this.repositoryLocalService.getRepositoryImpl(repositoryId);
        if (repository.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
            RepositoryEventTriggerCapability repositoryEventTriggerCapability = (RepositoryEventTriggerCapability)repository.getCapability(RepositoryEventTriggerCapability.class);
            repositoryEventTriggerCapability.trigger(repositoryEventType, modelClass, target);
        }
    }
}

