/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Repository;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderBaseImpl;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class DLFolderImpl
extends DLFolderBaseImpl {
    public List<Long> getAncestorFolderIds() throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        DLFolderImpl folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestorFolderIds.add(folder.getFolderId());
            }
            catch (NoSuchFolderException nsfe) {
                if (folder.isInTrash()) break;
                throw nsfe;
            }
        }
        return ancestorFolderIds;
    }

    public List<DLFolder> getAncestors() throws PortalException {
        ArrayList<DLFolder> ancestors = new ArrayList<DLFolder>();
        DLFolderImpl folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestors.add(folder);
            }
            catch (NoSuchFolderException nsfe) {
                if (folder.isInTrash()) break;
                throw nsfe;
            }
        }
        return ancestors;
    }

    public DLFolder getParentFolder() throws PortalException {
        if (this.getParentFolderId() == 0L) {
            return null;
        }
        return DLFolderLocalServiceUtil.getFolder((long)this.getParentFolderId());
    }

    public String getPath() throws PortalException {
        StringBuilder sb = new StringBuilder();
        for (DLFolderImpl folder = this; folder != null; folder = folder.getParentFolder()) {
            sb.insert(0, folder.getName());
            sb.insert(0, "/");
        }
        return sb.toString();
    }

    public String[] getPathArray() throws PortalException {
        String path = this.getPath();
        path = path.substring(1);
        return StringUtil.split((String)path, (char)'/');
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFolderConstants.getClassName());
    }

    public boolean hasInheritableLock() {
        try {
            return DLFolderServiceUtil.hasInheritableLock((long)this.getFolderId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasLock() {
        try {
            return DLFolderServiceUtil.hasFolderLock((long)this.getFolderId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isInHiddenFolder() {
        try {
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)this.getRepositoryId());
            long dlFolderId = repository.getDlFolderId();
            DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFolderId);
            return dlFolder.isHidden();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isLocked() {
        try {
            return DLFolderServiceUtil.isFolderLocked((long)this.getFolderId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isRoot() {
        return this.getParentFolderId() == 0L;
    }
}

