/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryTypeBaseImpl;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.List;
import java.util.Locale;

public class DLFileEntryTypeImpl
extends DLFileEntryTypeBaseImpl {
    public List<DDMStructure> getDDMStructures() {
        return DDMStructureLocalServiceUtil.getDLFileEntryTypeStructures((long)this.getFileEntryTypeId());
    }

    @Override
    public String getName(Locale locale) {
        String name = super.getName(locale);
        if (this.getFileEntryTypeId() == 0L) {
            name = LanguageUtil.get((Locale)locale, (String)name);
        }
        return name;
    }

    public String getUnambiguousName(List<DLFileEntryType> dlFileEntryTypes, long groupId, final Locale locale) throws PortalException {
        if (this.getGroupId() == groupId) {
            return this.getName(locale);
        }
        boolean hasAmbiguousName = ListUtil.exists(dlFileEntryTypes, (PredicateFilter)new PredicateFilter<DLFileEntryType>(){

            public boolean filter(DLFileEntryType fileEntryType) {
                String name = fileEntryType.getName(locale);
                return name.equals(DLFileEntryTypeImpl.this.getName(locale)) && fileEntryType.getFileEntryTypeId() != DLFileEntryTypeImpl.this.getFileEntryTypeId();
            }
        });
        if (hasAmbiguousName) {
            Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            return group.getUnambiguousName(this.getName(locale), locale);
        }
        return this.getName(locale);
    }

    public boolean isExportable() {
        return this.getFileEntryTypeId() != 0L;
    }
}

