/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.messaging;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.model.Repository;
import com.liferay.portal.service.RepositoryLocalServiceUtil;

public class TempFileEntriesMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(TempFileEntriesMessageListener.class);

    protected void deleteExpiredTemporaryFileEntries(Repository repository) {
        block6: {
            LocalRepository localRepository = null;
            try {
                localRepository = RepositoryLocalServiceUtil.getLocalRepositoryImpl((long)repository.getRepositoryId());
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get implementation for repository " + repository.getRepositoryId()), (Throwable)pe);
                }
                return;
            }
            try {
                if (localRepository.isCapabilityProvided(TemporaryFileEntriesCapability.class)) {
                    TemporaryFileEntriesCapability temporaryFileEntriesCapability = (TemporaryFileEntriesCapability)localRepository.getCapability(TemporaryFileEntriesCapability.class);
                    temporaryFileEntriesCapability.deleteExpiredTemporaryFileEntries();
                }
            }
            catch (Exception pe) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)("Unable to delete expired temporary file entries in repository " + repository.getRepositoryId()), (Throwable)pe);
            }
        }
    }

    protected void doReceive(Message message) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = RepositoryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) {
                Repository repository = (Repository)object;
                TempFileEntriesMessageListener.this.deleteExpiredTemporaryFileEntries(repository);
            }
        });
        actionableDynamicQuery.performActions();
    }
}

