/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import java.util.List;
import java.util.Map;

public class RepositoryEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<RepositoryEntry> {
    public static final String[] CLASS_NAMES = new String[]{RepositoryEntry.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        RepositoryEntry repositoryEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (repositoryEntry != null) {
            RepositoryEntryLocalServiceUtil.deleteRepositoryEntry((long)repositoryEntry.getRepositoryId());
        }
    }

    public RepositoryEntry fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List entries = RepositoryEntryLocalServiceUtil.getRepositoryEntriesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)entries)) {
            return null;
        }
        return (RepositoryEntry)entries.get(0);
    }

    public RepositoryEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return RepositoryEntryLocalServiceUtil.fetchRepositoryEntryByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, RepositoryEntry repositoryEntry) throws Exception {
        Element repositoryEntryElement = portletDataContext.getExportDataElement((ClassedModel)repositoryEntry);
        portletDataContext.addClassedModel(repositoryEntryElement, ExportImportPathUtil.getModelPath((StagedModel)repositoryEntry), (ClassedModel)repositoryEntry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, RepositoryEntry repositoryEntry) throws Exception {
        long userId = portletDataContext.getUserId(repositoryEntry.getUserUuid());
        Map repositoryIds = portletDataContext.getNewPrimaryKeysMap(Repository.class);
        long repositoryId = MapUtil.getLong((Map)repositoryIds, (long)repositoryEntry.getRepositoryId(), (long)repositoryEntry.getRepositoryId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)repositoryEntry);
        RepositoryEntry importedRepositoryEntry = null;
        if (portletDataContext.isDataStrategyMirror()) {
            RepositoryEntry existingRepositoryEntry = this.fetchStagedModelByUuidAndGroupId(repositoryEntry.getUuid(), portletDataContext.getScopeGroupId());
            if (existingRepositoryEntry == null) {
                serviceContext.setUuid(repositoryEntry.getUuid());
                importedRepositoryEntry = RepositoryEntryLocalServiceUtil.addRepositoryEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)repositoryId, (String)repositoryEntry.getMappedId(), (ServiceContext)serviceContext);
            } else {
                importedRepositoryEntry = RepositoryEntryLocalServiceUtil.updateRepositoryEntry((long)existingRepositoryEntry.getRepositoryEntryId(), (String)repositoryEntry.getMappedId());
            }
        } else {
            importedRepositoryEntry = RepositoryEntryLocalServiceUtil.addRepositoryEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)repositoryId, (String)repositoryEntry.getMappedId(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)repositoryEntry, (ClassedModel)importedRepositoryEntry);
    }
}

