/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.lar.FolderUtil;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutLocalServiceUtil;
import java.util.List;
import java.util.Map;

public class DLFileShortcutStagedModelDataHandler
extends BaseStagedModelDataHandler<DLFileShortcut> {
    public static final String[] CLASS_NAMES = new String[]{DLFileShortcut.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(DLFileShortcutStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DLFileShortcut dlFileShortcut = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (dlFileShortcut != null) {
            DLFileShortcutLocalServiceUtil.deleteFileShortcut((DLFileShortcut)dlFileShortcut);
        }
    }

    public DLFileShortcut fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List fileShortcuts = DLFileShortcutLocalServiceUtil.getDLFileShortcutsByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)fileShortcuts)) {
            return null;
        }
        return (DLFileShortcut)fileShortcuts.get(0);
    }

    public DLFileShortcut fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return DLFileShortcutLocalServiceUtil.fetchDLFileShortcutByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DLFileShortcut shortcut) {
        return shortcut.getToTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DLFileShortcut fileShortcut) throws Exception {
        if (fileShortcut.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileShortcut, (StagedModel)fileShortcut.getFolder(), (String)"parent");
        }
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileShortcut.getToFileEntryId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileShortcut, (StagedModel)fileEntry, (String)"strong");
        Element fileShortcutElement = portletDataContext.getExportDataElement((ClassedModel)fileShortcut);
        fileShortcutElement.addAttribute("file-entry-uuid", fileEntry.getUuid());
        portletDataContext.addClassedModel(fileShortcutElement, ExportImportPathUtil.getModelPath((StagedModel)fileShortcut), (ClassedModel)fileShortcut);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DLFileShortcut fileShortcut) throws Exception {
        Element fileShortcutElement;
        String fileEntryUuid;
        FileEntry importedFileEntry;
        long userId = portletDataContext.getUserId(fileShortcut.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)fileShortcut.getFolderId(), (long)fileShortcut.getFolderId());
        long groupId = portletDataContext.getScopeGroupId();
        if (folderId != 0L) {
            Folder folder = FolderUtil.findByPrimaryKey(folderId);
            groupId = folder.getRepositoryId();
        }
        if ((importedFileEntry = FileEntryUtil.fetchByUUID_R(fileEntryUuid = (fileShortcutElement = portletDataContext.getImportDataStagedModelElement((StagedModel)fileShortcut)).attributeValue("file-entry-uuid"), groupId)) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to fetch file entry {uuid=" + fileEntryUuid + ", groupId=" + groupId + "}"));
            }
            return;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fileShortcut);
        DLFileShortcut importedFileShortcut = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileShortcut existingFileShortcut = this.fetchStagedModelByUuidAndGroupId(fileShortcut.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFileShortcut == null) {
                serviceContext.setUuid(fileShortcut.getUuid());
                importedFileShortcut = DLAppLocalServiceUtil.addFileShortcut((long)userId, (long)groupId, (long)folderId, (long)importedFileEntry.getFileEntryId(), (ServiceContext)serviceContext);
            } else {
                importedFileShortcut = DLAppLocalServiceUtil.updateFileShortcut((long)userId, (long)existingFileShortcut.getFileShortcutId(), (long)folderId, (long)importedFileEntry.getFileEntryId(), (ServiceContext)serviceContext);
            }
        } else {
            importedFileShortcut = DLAppLocalServiceUtil.addFileShortcut((long)userId, (long)groupId, (long)folderId, (long)importedFileEntry.getFileEntryId(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)fileShortcut, (ClassedModel)importedFileShortcut);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, DLFileShortcut fileShortcut) throws Exception {
        long userId = portletDataContext.getUserId(fileShortcut.getUserUuid());
        DLFileShortcut existingFileShortcut = this.fetchStagedModelByUuidAndGroupId(fileShortcut.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFileShortcut == null || !existingFileShortcut.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingFileShortcut.getTrashHandler();
        if (trashHandler.isRestorable(existingFileShortcut.getFileShortcutId())) {
            trashHandler.restoreTrashEntry(userId, existingFileShortcut.getFileShortcutId());
        }
    }
}

