/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DLFileEntryTypeStagedModelDataHandler
extends BaseStagedModelDataHandler<DLFileEntryType> {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntryType.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DLFileEntryType dlFileEntryType = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (dlFileEntryType != null) {
            DLFileEntryTypeLocalServiceUtil.deleteFileEntryType((DLFileEntryType)dlFileEntryType);
        }
    }

    public DLFileEntryType fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List fileEntryTypes = DLFileEntryTypeLocalServiceUtil.getDLFileEntryTypesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)fileEntryTypes)) {
            return null;
        }
        return (DLFileEntryType)fileEntryTypes.get(0);
    }

    public DLFileEntryType fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryTypeByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("file-entry-type-key", fileEntryType.getFileEntryTypeKey());
        long defaultUserId = 0L;
        try {
            defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)fileEntryType.getCompanyId());
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean preloaded = false;
        if (fileEntryType.getFileEntryTypeId() == 0L || defaultUserId == fileEntryType.getUserId()) {
            preloaded = true;
        }
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        return referenceAttributes;
    }

    public void importMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        String fileEntryTypeKey = referenceElement.attributeValue("file-entry-type-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DLFileEntryType existingFileEntryType = null;
        existingFileEntryType = this.fetchExistingFileEntryType(uuid, liveGroupId, fileEntryTypeKey, preloaded);
        Map fileEntryTypeIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntryType.class);
        long fileEntryTypeId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        fileEntryTypeIds.put(fileEntryTypeId, existingFileEntryType.getFileEntryTypeId());
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        String fileEntryTypeKey = referenceElement.attributeValue("file-entry-type-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DLFileEntryType existingFileEntryType = this.fetchExistingFileEntryType(uuid, liveGroupId, fileEntryTypeKey, preloaded);
        return existingFileEntryType != null;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) throws Exception {
        Element fileEntryTypeElement = portletDataContext.getExportDataElement((ClassedModel)fileEntryType);
        List ddmStructures = fileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element referenceElement = StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntryType, (StagedModel)ddmStructure, (String)"strong");
            referenceElement.addAttribute("structure-id", StringUtil.valueOf((Object)ddmStructure.getStructureId()));
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)fileEntryType.getCompanyId());
        if (defaultUserId == fileEntryType.getUserId()) {
            fileEntryTypeElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(fileEntryTypeElement, ExportImportPathUtil.getModelPath((StagedModel)fileEntryType), (ClassedModel)fileEntryType);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) throws Exception {
        long userId = portletDataContext.getUserId(fileEntryType.getUserUuid());
        List ddmStructureReferenceElements = portletDataContext.getReferenceElements((StagedModel)fileEntryType, DDMStructure.class);
        long[] ddmStructureIdsArray = new long[ddmStructureReferenceElements.size()];
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        for (int i = 0; i < ddmStructureReferenceElements.size(); ++i) {
            Element ddmStructureReferenceElement = (Element)ddmStructureReferenceElements.get(i);
            long ddmStructureId = GetterUtil.getLong((String)ddmStructureReferenceElement.attributeValue("class-pk"));
            ddmStructureIdsArray[i] = MapUtil.getLong((Map)ddmStructureIds, (long)ddmStructureId);
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fileEntryType);
        DLFileEntryType importedDLFileEntryType = null;
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)fileEntryType);
        boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileEntryType existingDLFileEntryType = this.fetchExistingFileEntryType(fileEntryType.getUuid(), portletDataContext.getScopeGroupId(), fileEntryType.getFileEntryTypeKey(), preloaded);
            if (existingDLFileEntryType == null) {
                serviceContext.setUuid(fileEntryType.getUuid());
                importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)portletDataContext.getScopeGroupId(), (String)fileEntryType.getFileEntryTypeKey(), (Map)fileEntryType.getNameMap(), (Map)fileEntryType.getDescriptionMap(), (long[])ddmStructureIdsArray, (ServiceContext)serviceContext);
            } else {
                DLFileEntryTypeLocalServiceUtil.updateFileEntryType((long)userId, (long)existingDLFileEntryType.getFileEntryTypeId(), (Map)fileEntryType.getNameMap(), (Map)fileEntryType.getDescriptionMap(), (long[])ddmStructureIdsArray, (ServiceContext)serviceContext);
                importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)existingDLFileEntryType.getFileEntryTypeId());
            }
        } else {
            importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)portletDataContext.getScopeGroupId(), (String)fileEntryType.getFileEntryTypeKey(), (Map)fileEntryType.getNameMap(), (Map)fileEntryType.getDescriptionMap(), (long[])ddmStructureIdsArray, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)fileEntryType, (ClassedModel)importedDLFileEntryType);
        if (preloaded) {
            return;
        }
        String importedDLFileEntryDDMStructureKey = DLUtil.getDDMStructureKey((DLFileEntryType)importedDLFileEntryType);
        List importedDDMStructures = importedDLFileEntryType.getDDMStructures();
        for (DDMStructure importedDDMStructure : importedDDMStructures) {
            String ddmStructureKey = importedDDMStructure.getStructureKey();
            if (!DLUtil.isAutoGeneratedDLFileEntryTypeDDMStructureKey((String)ddmStructureKey) || ddmStructureKey.equals(importedDLFileEntryDDMStructureKey)) continue;
            importedDDMStructure.setStructureKey(importedDLFileEntryDDMStructureKey);
            DDMStructureLocalServiceUtil.updateDDMStructure((DDMStructure)importedDDMStructure);
        }
    }

    protected DLFileEntryType fetchExistingFileEntryType(String uuid, long groupId, String fileEntryTypeKey, boolean preloaded) {
        DLFileEntryType existingDLFileEntryType = null;
        existingDLFileEntryType = !preloaded ? this.fetchStagedModelByUuidAndGroupId(uuid, groupId) : DLFileEntryTypeLocalServiceUtil.fetchFileEntryType((long)groupId, (String)fileEntryTypeKey);
        return existingDLFileEntryType;
    }
}

