/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.context;

import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.UnicodeLanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.DeleteMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavascriptMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavascriptToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavascriptUIItem;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLUIItem;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLUtil;
import com.liferay.portlet.documentlibrary.DLPortletInstanceSettings;
import com.liferay.portlet.documentlibrary.context.DLActionsDisplayContext;
import com.liferay.portlet.documentlibrary.context.DLUIItemKeys;
import com.liferay.portlet.documentlibrary.context.DLViewFileVersionDisplayContext;
import com.liferay.portlet.documentlibrary.context.helper.FileEntryDisplayContextHelper;
import com.liferay.portlet.documentlibrary.context.helper.FileVersionDisplayContextHelper;
import com.liferay.portlet.documentlibrary.context.util.JSPRenderer;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultDLViewFileVersionDisplayContext
implements DLViewFileVersionDisplayContext {
    private static final UUID _UUID = UUID.fromString("85F6C50E-3893-4E32-9D63-208528A503FA");
    private String _currentURL;
    private DLActionsDisplayContext _dlActionsDisplayContext;
    private FileEntry _fileEntry;
    private FileEntryDisplayContextHelper _fileEntryDisplayContextHelper;
    private FileVersion _fileVersion;
    private FileVersionDisplayContextHelper _fileVersionDisplayContextHelper;
    private long _folderId;
    private Boolean _ieOnWin32;
    private HttpServletRequest _request;
    private ThemeDisplay _themeDisplay;
    private Boolean _trashEnabled;

    public DefaultDLViewFileVersionDisplayContext(HttpServletRequest request, HttpServletResponse response, FileVersion fileVersion) throws PortalException {
        this._request = request;
        this._fileVersion = fileVersion;
        if (fileVersion != null) {
            this._fileEntry = fileVersion.getFileEntry();
        }
        this._folderId = BeanParamUtil.getLong((Object)this._fileEntry, (HttpServletRequest)request, (String)"folderId");
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._fileEntryDisplayContextHelper = new FileEntryDisplayContextHelper(this._themeDisplay.getPermissionChecker(), this._fileEntry);
        this._fileVersionDisplayContextHelper = new FileVersionDisplayContextHelper(fileVersion);
    }

    public List<DDMStructure> getDDMStructures() throws PortalException {
        if (this._fileVersionDisplayContextHelper.isDLFileVersion()) {
            DLFileVersion dlFileVersion = (DLFileVersion)this._fileVersion.getModel();
            return dlFileVersion.getDDMStructures();
        }
        return Collections.emptyList();
    }

    public Fields getFields(DDMStructure ddmStructure) throws PortalException {
        DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)this._fileVersion.getFileVersionId());
        return StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
    }

    public List<MenuItem> getMenuItems() throws PortalException {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        if (this._isShowActions()) {
            this._addDownloadMenuItem(menuItems);
            this._addOpenInMsOfficeMenuItem(menuItems);
            this._addEditMenuItem(menuItems);
            this._addMoveMenuItem(menuItems);
            this._addCheckoutMenuItem(menuItems);
            this._addCheckinMenuItem(menuItems);
            this._addCancelCheckoutMenuItem(menuItems);
            this._addPermissionsMenuItem(menuItems);
            this._addDeleteMenuItem(menuItems);
        }
        return menuItems;
    }

    public List<ToolbarItem> getToolbarItems() throws PortalException {
        ArrayList<ToolbarItem> toolbarItems = new ArrayList<ToolbarItem>();
        this._addDownloadToolbarItem(toolbarItems);
        this._addOpenInMsOfficeToolbarItem(toolbarItems);
        this._addEditToolbarItem(toolbarItems);
        this._addMoveToolbarItem(toolbarItems);
        this._addCheckoutToolbarItem(toolbarItems);
        this._addCancelCheckoutToolbarItem(toolbarItems);
        this._addCheckinToolbarItem(toolbarItems);
        this._addPermissionsToolbarItem(toolbarItems);
        this._addMoveToTheRecycleBinToolbarItem(toolbarItems);
        this._addDeleteToolbarItem(toolbarItems);
        return toolbarItems;
    }

    public UUID getUuid() {
        return _UUID;
    }

    public boolean isAssetMetadataVisible() {
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        String portletName = portletDisplay.getPortletName();
        if (portletName.equals("101") || portletName.equals("20") || portletName.equals("199") || portletName.equals("31") || portletName.equals("110") || portletName.equals("158") || portletName.equals("153") || portletName.equals("182")) {
            return true;
        }
        return ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"showAssetMetadata");
    }

    public boolean isCancelCheckoutDocumentButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCancelCheckoutDocumentButtonVisible();
    }

    public boolean isCheckinButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCheckinButtonVisible();
    }

    public boolean isCheckoutDocumentButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCheckoutDocumentButtonVisible();
    }

    public boolean isDeleteButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isFileEntryDeletable() && !this._isFileEntryTrashable();
    }

    public boolean isDownloadButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.hasViewPermission();
    }

    public boolean isEditButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isUpdatable();
    }

    public boolean isMoveButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isUpdatable();
    }

    public boolean isMoveToTheRecycleBinButtonVisible() throws PortalException {
        return !this.isDeleteButtonVisible() && this._fileEntryDisplayContextHelper.isFileEntryDeletable();
    }

    public boolean isOpenInMsOfficeButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.hasViewPermission() && this._fileVersionDisplayContextHelper.isMsOffice() && this._isWebDAVEnabled() && this._isIEOnWin32();
    }

    public boolean isPermissionsButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.hasPermissionsPermission();
    }

    public boolean isViewButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.hasViewPermission();
    }

    public boolean isViewOriginalFileButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.hasViewPermission();
    }

    public void renderPreview(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JSPRenderer jspRenderer = new JSPRenderer("/html/portlet/document_library/view_file_entry_preview.jsp");
        jspRenderer.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", this._fileVersion);
        jspRenderer.render(request, response);
    }

    protected String getNamespace() {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        return liferayPortletResponse.getNamespace();
    }

    protected String getSubmitFormJavascript(String cmd, String redirect) {
        StringBundler sb = new StringBundler(18);
        sb.append("document.");
        sb.append(this.getNamespace());
        sb.append("fm.");
        sb.append(this.getNamespace());
        sb.append("cmd");
        sb.append(".value = '");
        sb.append(cmd);
        sb.append("';");
        if (redirect != null) {
            sb.append("document.");
            sb.append(this.getNamespace());
            sb.append("fm.");
            sb.append(this.getNamespace());
            sb.append("redirect.value = '");
            sb.append(redirect);
            sb.append("';");
        }
        sb.append("submitForm(document.");
        sb.append(this.getNamespace());
        sb.append("fm);");
        return sb.toString();
    }

    private void _addCancelCheckoutMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCancelCheckoutDocumentButtonVisible()) {
            return;
        }
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, "icon-remove", DLUIItemKeys.CANCEL_CHECKOUT, "cancel-checkout[document]", this._getActionURL("/document_library/edit_file_entry", "cancel_checkout"));
    }

    private void _addCancelCheckoutToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isCancelCheckoutDocumentButtonVisible()) {
            return;
        }
        this._addJavascriptUIItem((JavascriptUIItem)new JavascriptToolbarItem(), (List)toolbarItems, "icon-undo", DLUIItemKeys.CANCEL_CHECKOUT, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"cancel-checkout[document]"), this.getSubmitFormJavascript("cancel_checkout", null));
    }

    private void _addCheckinMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCheckinButtonVisible()) {
            return;
        }
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, "icon-lock", DLUIItemKeys.CHECKIN, "checkin", this._getActionURL("/document_library/edit_file_entry", "checkin"));
    }

    private void _addCheckinToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isCheckinButtonVisible()) {
            return;
        }
        this._addJavascriptUIItem((JavascriptUIItem)new JavascriptToolbarItem(), (List)toolbarItems, "icon-lock", DLUIItemKeys.CHECKIN, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"checkin"), this.getSubmitFormJavascript("checkin", null));
    }

    private void _addCheckoutMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCheckoutDocumentButtonVisible()) {
            return;
        }
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, "icon-unlock", DLUIItemKeys.CHECKOUT, "checkout[document]", this._getActionURL("/document_library/edit_file_entry", "checkout"));
    }

    private void _addCheckoutToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isCheckoutDocumentButtonVisible()) {
            return;
        }
        this._addJavascriptUIItem((JavascriptUIItem)new JavascriptToolbarItem(), (List)toolbarItems, "icon-unlock", DLUIItemKeys.CHECKOUT, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"checkout[document]"), this.getSubmitFormJavascript("checkout", null));
    }

    private void _addDeleteMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this.isDeleteButtonVisible()) {
            DeleteMenuItem deleteMenuItem = new DeleteMenuItem();
            deleteMenuItem.setKey(DLUIItemKeys.DELETE);
            deleteMenuItem.setURL(this._getActionURL("/document_library/edit_file_entry", "delete"));
            menuItems.add((MenuItem)deleteMenuItem);
        } else if (this.isMoveToTheRecycleBinButtonVisible()) {
            DeleteMenuItem deleteMenuItem = new DeleteMenuItem();
            deleteMenuItem.setKey(DLUIItemKeys.DELETE);
            deleteMenuItem.setTrash(true);
            deleteMenuItem.setURL(this._getActionURL("/document_library/edit_file_entry", "move_to_trash"));
            menuItems.add((MenuItem)deleteMenuItem);
        }
    }

    private void _addDeleteToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isDeleteButtonVisible()) {
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view");
        portletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        StringBundler sb = new StringBundler(5);
        sb.append("if (confirm('");
        sb.append(UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"are-you-sure-you-want-to-delete-this"));
        sb.append("')) {");
        sb.append(this.getSubmitFormJavascript("delete", portletURL.toString()));
        sb.append("}");
        this._addJavascriptUIItem((JavascriptUIItem)new JavascriptToolbarItem(), (List)toolbarItems, "icon-remove", DLUIItemKeys.DELETE, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"delete"), sb.toString());
    }

    private void _addDownloadMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this.isDownloadButtonVisible()) {
            return;
        }
        String label = TextFormatter.formatStorageSize((double)this._fileEntry.getSize(), (Locale)this._themeDisplay.getLocale());
        label = this._themeDisplay.translate("download") + " (" + label + ")";
        String url = DLUtil.getDownloadURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)this._themeDisplay, (String)"", (boolean)false, (boolean)true);
        URLMenuItem urlMenuItem = (URLMenuItem)this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, "icon-download", DLUIItemKeys.DOWNLOAD, label, url);
        urlMenuItem.setTarget("_blank");
    }

    private void _addDownloadToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isDownloadButtonVisible()) {
            return;
        }
        this._addURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems, "icon-download", DLUIItemKeys.DOWNLOAD, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"download"), DLUtil.getDownloadURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)this._themeDisplay, (String)""));
    }

    private void _addEditMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this.isEditButtonVisible()) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/edit_file_entry");
        portletURL.setParameter("backURL", this._getCurrentURL());
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, "icon-edit", DLUIItemKeys.EDIT, "edit", portletURL.toString());
    }

    private void _addEditToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isEditButtonVisible()) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/edit_file_entry");
        this._addURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems, "icon-edit", DLUIItemKeys.EDIT, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"edit"), portletURL.toString());
    }

    private <T extends JavascriptUIItem> T _addJavascriptUIItem(T javascriptUIItem, List<? super T> javascriptUIItems, String icon, String key, String label, String onClick) {
        javascriptUIItem.setIcon(icon);
        javascriptUIItem.setKey(key);
        javascriptUIItem.setLabel(label);
        javascriptUIItem.setOnClick(onClick);
        javascriptUIItems.add(javascriptUIItem);
        return javascriptUIItem;
    }

    private void _addMoveMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this.isMoveButtonVisible()) {
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/move_entry");
        PortletURL redirectURL = liferayPortletResponse.createRenderURL();
        redirectURL.setParameter("struts_action", "/document_library/view");
        redirectURL.setParameter("folderId", String.valueOf(this._folderId));
        portletURL.setParameter("redirect", redirectURL.toString());
        portletURL.setParameter("fileEntryIds", String.valueOf(this._fileEntry.getFileEntryId()));
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, "icon-move", DLUIItemKeys.MOVE, "move", portletURL.toString());
    }

    private void _addMoveToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isMoveButtonVisible()) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/move_entry");
        this._addURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems, "icon-move", DLUIItemKeys.MOVE, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"move"), portletURL.toString());
    }

    private void _addMoveToTheRecycleBinToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isMoveToTheRecycleBinButtonVisible()) {
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view");
        portletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        this._addJavascriptUIItem((JavascriptUIItem)new JavascriptToolbarItem(), (List)toolbarItems, "icon-trash", DLUIItemKeys.MOVE_TO_THE_RECYCLE_BIN, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"move-to-the-recycle-bin"), this.getSubmitFormJavascript("move_to_trash", portletURL.toString()));
    }

    private void _addOpenInMsOfficeMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this.isOpenInMsOfficeButtonVisible()) {
            return;
        }
        String webDavURL = DLUtil.getWebDavURL((ThemeDisplay)this._themeDisplay, (Folder)this._fileEntry.getFolder(), (FileEntry)this._fileEntry, (boolean)PropsValues.DL_FILE_ENTRY_OPEN_IN_MS_OFFICE_MANUAL_CHECK_IN_REQUIRED, (boolean)true);
        String onClick = this.getNamespace() + "openDocument('" + webDavURL + "');";
        JavascriptMenuItem javascriptMenuItem = (JavascriptMenuItem)this._addJavascriptUIItem((JavascriptUIItem)new JavascriptMenuItem(), (List)menuItems, "icon-file-alt", DLUIItemKeys.OPEN_IN_MS_OFFICE, "open-in-ms-office", onClick);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("errorMessage", UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"cannot-open-the-requested-document-due-to-the-following-reason"));
        context.put("namespace", this.getNamespace());
        String javaScript = this._processFreeMarkerTemplate("/com/liferay/portlet/documentlibrary/context/dependenciesopen_in_ms_office_js.ftl", context);
        javascriptMenuItem.setJavascript(javaScript);
    }

    private void _addOpenInMsOfficeToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isOpenInMsOfficeButtonVisible()) {
            return;
        }
        String webDavURL = DLUtil.getWebDavURL((ThemeDisplay)this._themeDisplay, (Folder)this._fileEntry.getFolder(), (FileEntry)this._fileEntry, (boolean)PropsValues.DL_FILE_ENTRY_OPEN_IN_MS_OFFICE_MANUAL_CHECK_IN_REQUIRED);
        StringBundler sb = new StringBundler(4);
        sb.append(this.getNamespace());
        sb.append("openDocument('");
        sb.append(webDavURL);
        sb.append("');");
        this._addJavascriptUIItem((JavascriptUIItem)new JavascriptToolbarItem(), (List)toolbarItems, "icon-file-alt", DLUIItemKeys.OPEN_IN_MS_OFFICE, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"open-in-ms-office"), sb.toString());
    }

    private void _addPermissionsMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this.isPermissionsButtonVisible()) {
            return;
        }
        String url = null;
        try {
            url = PermissionsURLTag.doTag(null, (String)DLFileEntryConstants.getClassName(), (String)HtmlUtil.unescape((String)this._fileEntry.getTitle()), null, (String)String.valueOf(this._fileEntry.getFileEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._request);
        }
        catch (Exception e) {
            throw new SystemException("Unable to create permissions URL", (Throwable)e);
        }
        URLMenuItem urlMenuItem = (URLMenuItem)this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, "icon-lock", DLUIItemKeys.PERMISSIONS, "permissions", url);
        urlMenuItem.setMethod("get");
        urlMenuItem.setUseDialog(true);
    }

    private void _addPermissionsToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isPermissionsButtonVisible()) {
            return;
        }
        String permissionsURL = null;
        try {
            permissionsURL = PermissionsURLTag.doTag(null, (String)DLFileEntryConstants.getClassName(), (String)HtmlUtil.unescape((String)this._fileEntry.getTitle()), null, (String)String.valueOf(this._fileEntry.getFileEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._request);
        }
        catch (Exception e) {
            throw new SystemException("Unable to create permissions URL", (Throwable)e);
        }
        StringBundler sb = new StringBundler(6);
        sb.append("Liferay.Util.openWindow({");
        sb.append("title: '");
        sb.append(UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"permissions"));
        sb.append("', uri: '");
        sb.append(permissionsURL);
        sb.append("'});");
        this._addJavascriptUIItem((JavascriptUIItem)new JavascriptToolbarItem(), (List)toolbarItems, "icon-lock", DLUIItemKeys.PERMISSIONS, UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"permissions"), sb.toString());
    }

    private <T extends URLUIItem> T _addURLUIItem(T urlUIItem, List<? super T> urlUIItems, String icon, String key, String label, String url) {
        urlUIItem.setIcon(icon);
        urlUIItem.setKey(key);
        urlUIItem.setLabel(label);
        urlUIItem.setURL(url);
        urlUIItems.add(urlUIItem);
        return urlUIItem;
    }

    private String _getActionURL(String strutsAction, String cmd) {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createActionURL();
        portletURL.setParameter("struts_action", strutsAction);
        portletURL.setParameter("cmd", cmd);
        portletURL.setParameter("redirect", this._getCurrentURL());
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        return portletURL.toString();
    }

    private String _getCurrentURL() {
        if (this._currentURL != null) {
            return this._currentURL;
        }
        LiferayPortletRequest liferayPortletRequest = this._getLiferayPortletRequest();
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = PortletURLUtil.getCurrent((LiferayPortletRequest)liferayPortletRequest, (LiferayPortletResponse)liferayPortletResponse);
        this._currentURL = portletURL.toString();
        return this._currentURL;
    }

    private DLActionsDisplayContext _getDLActionsDisplayContext() throws PortalException {
        if (this._dlActionsDisplayContext != null) {
            return this._dlActionsDisplayContext;
        }
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        String portletId = portletDisplay.getId();
        if (portletId.equals("86")) {
            portletId = ParamUtil.getString((HttpServletRequest)this._request, (String)"portletResource");
        }
        DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(this._themeDisplay.getLayout(), portletId);
        this._dlActionsDisplayContext = new DLActionsDisplayContext(this._request, dlPortletInstanceSettings);
        return this._dlActionsDisplayContext;
    }

    private LiferayPortletRequest _getLiferayPortletRequest() {
        PortletRequest portletRequest = (PortletRequest)this._request.getAttribute("javax.portlet.request");
        return PortalUtil.getLiferayPortletRequest((PortletRequest)portletRequest);
    }

    private LiferayPortletResponse _getLiferayPortletResponse() {
        PortletResponse portletResponse = (PortletResponse)this._request.getAttribute("javax.portlet.response");
        return PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse);
    }

    private PortletURL _getRenderURL(String strutsAction) {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", strutsAction);
        portletURL.setParameter("redirect", this._getCurrentURL());
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        return portletURL;
    }

    private boolean _isFileEntryTrashable() throws PortalException {
        return this._fileEntryDisplayContextHelper.isDLFileEntry() && this._isTrashEnabled();
    }

    private boolean _isIEOnWin32() {
        if (this._ieOnWin32 == null) {
            this._ieOnWin32 = BrowserSnifferUtil.isIeOnWin32((HttpServletRequest)this._request);
        }
        return this._ieOnWin32;
    }

    private boolean _isShowActions() throws PortalException {
        DLActionsDisplayContext dlActionsDisplayContext = this._getDLActionsDisplayContext();
        return dlActionsDisplayContext.isShowActions();
    }

    private boolean _isTrashEnabled() throws PortalException {
        if (this._trashEnabled == null) {
            this._trashEnabled = TrashUtil.isTrashEnabled((long)this._themeDisplay.getScopeGroupId());
        }
        return this._trashEnabled;
    }

    private boolean _isWebDAVEnabled() {
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        return portletDisplay.isWebDAVEnabled();
    }

    private String _processFreeMarkerTemplate(String name, Map<String, String> context) {
        try {
            return FreeMarkerUtil.process(name, context);
        }
        catch (Exception e) {
            throw new SystemException("Unable to process Freemarker template", (Throwable)e);
        }
    }
}

