/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.context;

import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.DLPortletInstanceSettings;
import com.liferay.portlet.documentlibrary.context.DLEditFileEntryDisplayContext;
import com.liferay.portlet.documentlibrary.context.helper.FileEntryDisplayContextHelper;
import com.liferay.portlet.documentlibrary.context.helper.FileVersionDisplayContextHelper;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultDLEditFileEntryDisplayContext
implements DLEditFileEntryDisplayContext {
    private static final UUID _UUID = UUID.fromString("63326141-02F6-42B5-AE38-ABC73FA72BB5");
    private DLFileEntryType _dlFileEntryType;
    private DLPortletInstanceSettings _dlPortletInstanceSettings;
    private FileEntry _fileEntry;
    private FileEntryDisplayContextHelper _fileEntryDisplayContextHelper;
    private FileVersion _fileVersion;
    private FileVersionDisplayContextHelper _fileVersionDisplayContextHelper;
    private HttpServletRequest _request;

    public DefaultDLEditFileEntryDisplayContext(HttpServletRequest request, HttpServletResponse response, DLFileEntryType dlFileEntryType) throws PortalException {
        this._init(request, dlFileEntryType, null);
    }

    public DefaultDLEditFileEntryDisplayContext(HttpServletRequest request, HttpServletResponse response, FileEntry fileEntry) throws PortalException {
        this._init(request, null, fileEntry);
    }

    public long getMaximumUploadSize() {
        long fileMaxSize = PrefsPropsUtil.getLong((String)"dl.file.max.size");
        if (fileMaxSize == 0L) {
            fileMaxSize = PrefsPropsUtil.getLong((String)"com.liferay.portal.upload.UploadServletRequestImpl.max.size");
        }
        return fileMaxSize;
    }

    public String getPublishButtonLabel() {
        String publishButtonLabel = "publish";
        if (this._hasFolderWorkflowDefinitionLink()) {
            publishButtonLabel = "submit-for-publication";
        }
        if (this._dlPortletInstanceSettings.isEnableFileEntryDrafts()) {
            publishButtonLabel = "save";
        }
        return publishButtonLabel;
    }

    public String getSaveButtonLabel() {
        String saveButtonLabel = "save";
        if (this._fileVersion == null || this._fileVersionDisplayContextHelper.isApproved() || this._fileVersionDisplayContextHelper.isDraft()) {
            saveButtonLabel = "save-as-draft";
        }
        return saveButtonLabel;
    }

    public UUID getUuid() {
        return _UUID;
    }

    public boolean isCancelCheckoutDocumentButtonDisabled() {
        return false;
    }

    public boolean isCancelCheckoutDocumentButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCancelCheckoutDocumentButtonVisible();
    }

    public boolean isCheckinButtonDisabled() {
        return false;
    }

    public boolean isCheckinButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCheckinButtonVisible();
    }

    public boolean isCheckoutDocumentButtonDisabled() {
        return false;
    }

    public boolean isCheckoutDocumentButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCheckoutDocumentButtonVisible();
    }

    public boolean isDDMStructureVisible(DDMStructure ddmStructure) {
        return true;
    }

    public boolean isPublishButtonDisabled() {
        return this._fileEntryDisplayContextHelper.isCheckedOutByMe() || this._fileVersionDisplayContextHelper.isPending() && this._dlPortletInstanceSettings.isEnableFileEntryDrafts();
    }

    public boolean isPublishButtonVisible() {
        return true;
    }

    public boolean isSaveButtonDisabled() {
        return this._fileEntryDisplayContextHelper.isCheckedOutByOther();
    }

    public boolean isSaveButtonVisible() {
        return this._dlPortletInstanceSettings.isEnableFileEntryDrafts();
    }

    private boolean _hasFolderWorkflowDefinitionLink() {
        try {
            if (this._dlFileEntryType == null) {
                return false;
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long folderId = BeanParamUtil.getLong((Object)this._fileEntry, (HttpServletRequest)this._request, (String)"folderId");
            return DLUtil.hasWorkflowDefinitionLink((long)themeDisplay.getCompanyId(), (long)themeDisplay.getScopeGroupId(), (long)folderId, (long)this._dlFileEntryType.getFileEntryTypeId());
        }
        catch (Exception e) {
            throw new SystemException("Unable to check if folder has workflow definition link", (Throwable)e);
        }
    }

    private void _init(HttpServletRequest request, DLFileEntryType dlFileEntryType, FileEntry fileEntry) throws PortalException {
        this._request = request;
        this._dlFileEntryType = dlFileEntryType;
        this._fileEntry = fileEntry;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
        this._fileEntryDisplayContextHelper = new FileEntryDisplayContextHelper(themeDisplay.getPermissionChecker(), this._fileEntry);
        if (this._dlFileEntryType == null && this._fileEntry != null) {
            this._dlFileEntryType = this._fileEntryDisplayContextHelper.getDLFileEntryType();
        }
        if (fileEntry != null) {
            this._fileVersion = fileEntry.getFileVersion();
        }
        this._fileVersionDisplayContextHelper = new FileVersionDisplayContextHelper(this._fileVersion);
    }
}

