/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.context;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.KeyValuePairComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DLPortletInstanceSettings;
import com.liferay.portlet.documentlibrary.context.DLActionsDisplayContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DLConfigurationDisplayContext {
    private List<KeyValuePair> _availableDisplayViews;
    private List<KeyValuePair> _availableEntryColumns;
    private List<KeyValuePair> _currentDisplayViews;
    private List<KeyValuePair> _currentEntryColumns;
    private DLActionsDisplayContext _dlActionsDisplayContext;
    private DLPortletInstanceSettings _dlPortletInstanceSettings;
    private ThemeDisplay _themeDisplay;

    public DLConfigurationDisplayContext(HttpServletRequest request, DLPortletInstanceSettings dlPortletInstanceSettings) {
        this._dlPortletInstanceSettings = dlPortletInstanceSettings;
        this._dlActionsDisplayContext = new DLActionsDisplayContext(request, dlPortletInstanceSettings);
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<KeyValuePair> getAvailableDisplayViews() {
        if (this._availableDisplayViews == null) {
            this._populateDisplayViews();
        }
        return this._availableDisplayViews;
    }

    public List<KeyValuePair> getAvailableEntryColumns() {
        if (this._availableEntryColumns == null) {
            this._populateEntryColumns();
        }
        return this._availableEntryColumns;
    }

    public List<KeyValuePair> getCurrentDisplayViews() {
        if (this._currentDisplayViews == null) {
            this._populateDisplayViews();
        }
        return this._currentDisplayViews;
    }

    public List<KeyValuePair> getCurrentEntryColumns() {
        if (this._currentEntryColumns == null) {
            this._populateEntryColumns();
        }
        return this._currentEntryColumns;
    }

    public DLActionsDisplayContext getDLActionsDisplayContext() {
        return this._dlActionsDisplayContext;
    }

    private String[] _getAllEntryColumns() {
        String allEntryColumns = "name,size,status";
        if (PropsValues.DL_FILE_ENTRY_BUFFERED_INCREMENT_ENABLED) {
            allEntryColumns = allEntryColumns + ",downloads";
        }
        if (this._dlActionsDisplayContext.isShowActions()) {
            allEntryColumns = allEntryColumns + ",action";
        }
        allEntryColumns = allEntryColumns + ",modified-date,create-date";
        return StringUtil.split((String)allEntryColumns);
    }

    private void _populateDisplayViews() {
        Object[] displayViews = this._dlPortletInstanceSettings.getDisplayViews();
        this._currentDisplayViews = new ArrayList<KeyValuePair>();
        for (Object displayView : displayViews) {
            this._currentDisplayViews.add(new KeyValuePair((String)displayView, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)displayView)));
        }
        Arrays.sort(displayViews);
        this._availableDisplayViews = new ArrayList<KeyValuePair>();
        Set allDisplayViews = SetUtil.fromArray((Object[])PropsValues.DL_DISPLAY_VIEWS);
        for (String displayView : allDisplayViews) {
            if (Arrays.binarySearch(displayViews, displayView) >= 0) continue;
            this._availableDisplayViews.add(new KeyValuePair(displayView, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)displayView)));
        }
        this._availableDisplayViews = ListUtil.sort(this._availableDisplayViews, (Comparator)new KeyValuePairComparator(false, true));
    }

    private void _populateEntryColumns() {
        Object[] entryColumns = this._dlPortletInstanceSettings.getEntryColumns();
        this._currentEntryColumns = new ArrayList<KeyValuePair>();
        for (Object entryColumn : entryColumns) {
            this._currentEntryColumns.add(new KeyValuePair((String)entryColumn, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)entryColumn)));
        }
        Arrays.sort(entryColumns);
        this._availableEntryColumns = new ArrayList<KeyValuePair>();
        Set allEntryColumns = SetUtil.fromArray((Object[])this._getAllEntryColumns());
        for (String entryColumn : allEntryColumns) {
            if (Arrays.binarySearch(entryColumns, entryColumn) >= 0) continue;
            this._availableEntryColumns.add(new KeyValuePair(entryColumn, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)entryColumn)));
        }
        this._availableEntryColumns = ListUtil.sort(this._availableEntryColumns, (Comparator)new KeyValuePairComparator(false, true));
    }
}

