/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.asset.model.ClassTypeReader;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryAssetRenderer;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryClassTypeReader;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryTypePermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class DLFileEntryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "document";

    public DLFileEntryAssetRendererFactory() {
        this.setLinkable(true);
        this.setSupportsClassTypes(true);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        FileEntry fileEntry = null;
        FileVersion fileVersion = null;
        if (type == 0) {
            fileVersion = DLAppLocalServiceUtil.getFileVersion((long)classPK);
            fileEntry = fileVersion.getFileEntry();
        } else {
            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)classPK);
            fileVersion = fileEntry.getFileVersion();
        }
        DLFileEntryAssetRenderer dlFileEntryAssetRenderer = new DLFileEntryAssetRenderer(fileEntry, fileVersion);
        dlFileEntryAssetRenderer.setAssetRendererType(type);
        return dlFileEntryAssetRenderer;
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public ClassTypeReader getClassTypeReader() {
        return new DLFileEntryClassTypeReader();
    }

    public String getIconCssClass() {
        return "icon-file-alt";
    }

    public String getType() {
        return TYPE;
    }

    public String getTypeName(Locale locale, long subtypeId) {
        try {
            DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)subtypeId);
            return dlFileEntryType.getName(locale);
        }
        catch (Exception e) {
            return super.getTypeName(locale, subtypeId);
        }
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL portletURL = liferayPortletResponse.createRenderURL("20");
        portletURL.setParameter("struts_action", "/document_library/edit_file_entry");
        portletURL.setParameter("folderId", String.valueOf(AssetPublisherUtil.getRecentFolderId((PortletRequest)liferayPortletRequest, (String)this.getClassName())));
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("110", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        if (classTypeId > 0L && !DLFileEntryTypePermission.contains(permissionChecker, classTypeId, "VIEW")) {
            return false;
        }
        return DLPermission.contains(permissionChecker, groupId, "ADD_DOCUMENT");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/clip.png";
    }
}

