/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.asset.model.DDMFieldReader;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryDDMFieldReader;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class DLFileEntryAssetRenderer
extends BaseAssetRenderer
implements TrashRenderer {
    private FileEntry _fileEntry;
    private FileVersion _fileVersion;

    public DLFileEntryAssetRenderer(FileEntry fileEntry, FileVersion fileVersion) {
        this._fileEntry = fileEntry;
        this._fileVersion = fileVersion;
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public long getClassPK() {
        if (!this._fileVersion.isApproved() && this._fileVersion.isDraft() && !this._fileVersion.isPending() && !this._fileVersion.getVersion().equals("1.0")) {
            return this._fileVersion.getFileVersionId();
        }
        return this._fileEntry.getFileEntryId();
    }

    public DDMFieldReader getDDMFieldReader() {
        return new DLFileEntryDDMFieldReader(this._fileEntry, this._fileVersion);
    }

    public String getDiscussionPath() {
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            return "edit_file_entry_discussion";
        }
        return null;
    }

    public Date getDisplayDate() {
        return this._fileEntry.getModifiedDate();
    }

    public long getGroupId() {
        return this._fileEntry.getGroupId();
    }

    public String getIconCssClass() {
        return this._fileEntry.getIconCssClass();
    }

    public String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/file_system/small/" + this._fileEntry.getIcon() + ".png";
    }

    public String getNewName(String oldName, String token) {
        String extension = FileUtil.getExtension((String)oldName);
        if (Validator.isNull((String)extension)) {
            return super.getNewName(oldName, token);
        }
        StringBundler sb = new StringBundler(5);
        int index = oldName.lastIndexOf(46);
        sb.append(oldName.substring(0, index));
        sb.append(" ");
        sb.append(token);
        sb.append(".");
        sb.append(extension);
        return sb.toString();
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._fileEntry.getDescription();
    }

    public String[] getSupportedConversions() {
        return DocumentConversionUtil.getConversions(this._fileEntry.getExtension());
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String thumbnailSrc = DLUtil.getThumbnailSrc((FileEntry)this._fileEntry, null, (ThemeDisplay)themeDisplay);
        if (Validator.isNotNull((String)thumbnailSrc)) {
            return thumbnailSrc;
        }
        return themeDisplay.getPathThemeImages() + "/file_system/large/document.png";
    }

    public String getTitle(Locale locale) {
        String title = null;
        title = this.getAssetRendererType() == 0 ? this._fileVersion.getTitle() : this._fileEntry.getTitle();
        return TrashUtil.getOriginalTitle((String)title);
    }

    public String getType() {
        return "document";
    }

    public String getURLDownload(ThemeDisplay themeDisplay) {
        return DLUtil.getPreviewURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)themeDisplay, (String)"");
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "20", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/edit_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        return portletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL portletURL = liferayPortletResponse.createActionURL();
        portletURL.setParameter("struts_action", "/asset_publisher/get_file");
        portletURL.setParameter("groupId", String.valueOf(this._fileEntry.getRepositoryId()));
        portletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        portletURL.setParameter("title", String.valueOf(this._fileEntry.getTitle()));
        return portletURL;
    }

    public String getURLImagePreview(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return DLUtil.getImagePreviewURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)themeDisplay);
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("struts_action", "/document_library_display/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        portletURL.setWindowState(windowState);
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/document_library/find_file_entry", "fileEntryId", this._fileEntry.getFileEntryId());
    }

    public long getUserId() {
        return this._fileEntry.getUserId();
    }

    public String getUserName() {
        return this._fileEntry.getUserName();
    }

    public String getUuid() {
        return this._fileEntry.getUuid();
    }

    public boolean hasDeletePermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry.getFileEntryId(), "DELETE");
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry.getFileEntryId(), "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry.getFileEntryId(), "VIEW");
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isPrintable() {
        return false;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY", (Object)this._fileEntry);
            String version = ParamUtil.getString((PortletRequest)renderRequest, (String)"version");
            if (this.getAssetRendererType() == 0 || Validator.isNotNull((String)version)) {
                if (this._fileEntry != null && Validator.isNotNull((String)version)) {
                    this._fileVersion = this._fileEntry.getFileVersion(version);
                }
                renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)this._fileVersion);
            } else {
                renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)this._fileEntry.getFileVersion());
            }
            return "/html/portlet/document_library/asset/file_entry_" + template + ".jsp";
        }
        return null;
    }

    public void setAddToPagePreferences(PortletPreferences preferences, String portletId, ThemeDisplay themeDisplay) throws Exception {
        preferences.setValue("showAssetTitle", Boolean.FALSE.toString());
        preferences.setValue("showExtraInfo", Boolean.FALSE.toString());
        super.setAddToPagePreferences(preferences, portletId, themeDisplay);
    }
}

