/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.RequiredFileEntryTypeException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFolderAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFolder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFolders(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFolders(actionRequest, true);
            } else if (cmd.equals("subscribe")) {
                this.subscribeFolder(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeFolder(actionRequest);
            } else if (cmd.equals("deleteExpiredTemporaryFiles")) {
                this.deleteExpiredTemporaryFileEntries(actionRequest);
            } else if (cmd.equals("updateWorkflowDefinitions")) {
                this.updateWorkflowDefinitions(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e instanceof DuplicateFileException || e instanceof DuplicateFolderNameException || e instanceof FolderNameException || e instanceof RequiredFileEntryTypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFolder((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.document_library.edit_folder"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        this.downloadFolder(resourceRequest, resourceResponse);
    }

    protected void deleteExpiredTemporaryFileEntries(ActionRequest actionRequest) throws PortalException {
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        LocalRepository localRepository = RepositoryLocalServiceUtil.getLocalRepositoryImpl((long)repositoryId);
        if (localRepository.isCapabilityProvided(TemporaryFileEntriesCapability.class)) {
            TemporaryFileEntriesCapability temporaryFileEntriesCapability = (TemporaryFileEntriesCapability)localRepository.getCapability(TemporaryFileEntriesCapability.class);
            temporaryFileEntriesCapability.deleteExpiredTemporaryFileEntries();
        }
    }

    protected void deleteFolders(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteFolderIds = null;
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        deleteFolderIds = folderId > 0L ? new long[]{folderId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ArrayList<DLFolder> trashedModels = new ArrayList<DLFolder>();
        for (long deleteFolderId : deleteFolderIds) {
            if (moveToTrash) {
                Folder folder = DLAppServiceUtil.moveFolderToTrash((long)deleteFolderId);
                if (folder.getModel() instanceof DLFolder) {
                    trashedModels.add((DLFolder)folder.getModel());
                }
            } else {
                DLAppServiceUtil.deleteFolder((long)deleteFolderId);
            }
            AssetPublisherUtil.removeRecentFolderId((PortletRequest)actionRequest, (String)DLFileEntry.class.getName(), (long)deleteFolderId);
        }
        if (moveToTrash && deleteFolderIds.length > 0) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadFolder(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"folderId");
        File file = null;
        FileInputStream inputStream = null;
        try {
            String zipFileName = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"documents-and-media");
            if (folderId != 0L) {
                Folder folder = DLAppServiceUtil.getFolder((long)folderId);
                zipFileName = folder.getName();
            }
            ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
            this.zipFolder(repositoryId, folderId, "/", zipWriter);
            file = zipWriter.getFile();
            inputStream = new FileInputStream(file);
            PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)zipFileName, (InputStream)inputStream, (String)"application/zip");
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            if (file != null) {
                file.delete();
            }
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        if (file != null) {
            file.delete();
        }
    }

    protected void subscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        DLAppServiceUtil.subscribeFolder((long)themeDisplay.getScopeGroupId(), (long)folderId);
    }

    protected void unsubscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        DLAppServiceUtil.unsubscribeFolder((long)themeDisplay.getScopeGroupId(), (long)folderId);
    }

    protected void updateFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            DLAppServiceUtil.addFolder((long)repositoryId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            DLAppServiceUtil.updateFolder((long)folderId, (String)name, (String)description, (ServiceContext)serviceContext);
        }
    }

    protected void updateWorkflowDefinitions(ActionRequest actionRequest) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        DLAppServiceUtil.updateFolder((long)0L, null, null, (ServiceContext)serviceContext);
    }

    protected void zipFolder(long repositoryId, long folderId, String path, ZipWriter zipWriter) throws Exception {
        List foldersAndFileEntriesAndFileShortcuts = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcuts((long)repositoryId, (long)folderId, (int)0, (boolean)false, (int)-1, (int)-1);
        for (Object entry : foldersAndFileEntriesAndFileShortcuts) {
            if (entry instanceof Folder) {
                Folder folder = (Folder)entry;
                this.zipFolder(folder.getRepositoryId(), folder.getFolderId(), path.concat("/").concat(folder.getName()), zipWriter);
                continue;
            }
            if (!(entry instanceof FileEntry)) continue;
            FileEntry fileEntry = (FileEntry)entry;
            zipWriter.addEntry(path + "/" + HtmlUtil.escapeURL((String)fileEntry.getTitle()), fileEntry.getContentStream());
        }
    }
}

