/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.FileShortcutPermissionException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileShortcutException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFileShortcutAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFileShortcut(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFileShortcut(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFileShortcut(actionRequest, true);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileShortcutException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e instanceof FileShortcutPermissionException || e instanceof NoSuchFileEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFileShortcut((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileShortcutException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.document_library.edit_file_shortcut"));
    }

    protected void deleteFileShortcut(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
        if (moveToTrash) {
            DLFileShortcut fileShortcut = DLAppServiceUtil.moveFileShortcutToTrash((long)fileShortcutId);
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, (TrashedModel)fileShortcut);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        } else {
            DLAppServiceUtil.deleteFileShortcut((long)fileShortcutId);
        }
    }

    protected void updateFileShortcut(ActionRequest actionRequest) throws Exception {
        long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long toFileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"toFileEntryId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileShortcut.class.getName(), (PortletRequest)actionRequest);
        if (fileShortcutId <= 0L) {
            DLFileShortcut fileShortcut = DLAppServiceUtil.addFileShortcut((long)repositoryId, (long)folderId, (long)toFileEntryId, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, (String)DLFileShortcut.class.getName(), (long)fileShortcut.getFileShortcutId(), (int)-1);
        } else {
            DLAppServiceUtil.updateFileShortcut((long)fileShortcutId, (long)folderId, (long)toFileEntryId, (ServiceContext)serviceContext);
            AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, (String)DLFileShortcut.class.getName(), (long)folderId);
        }
    }
}

