/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.DLPortletInstanceSettings;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileMimeTypeException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.InvalidFileEntryTypeException;
import com.liferay.portlet.documentlibrary.InvalidFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.SourceFileNameException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFileEntryAction
extends PortletAction {
    public static final String TEMP_RANDOM_SUFFIX = "--tempRandomSuffix--";
    private static final String _TEMP_FOLDER_NAME = EditFileEntryAction.class.getName();

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        FileEntry fileEntry = null;
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException();
                }
                if (uploadException.isExceededSizeLimit()) {
                    throw new FileSizeException(uploadException.getCause());
                }
                throw new PortalException(uploadException.getCause());
            }
            if (cmd.equals("add") || cmd.equals("add_dynamic") || cmd.equals("update") || cmd.equals("update_and_checkin")) {
                fileEntry = this.updateFileEntry(portletConfig, actionRequest, actionResponse);
            } else if (cmd.equals("add_multiple")) {
                this.addMultipleFileEntries(portletConfig, actionRequest, actionResponse);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            } else if (cmd.equals("add_temp")) {
                this.addTempFileEntry(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteFileEntry(actionRequest, false);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempFileEntry(actionRequest, actionResponse);
            } else if (cmd.equals("cancel_checkout")) {
                this.cancelFileEntriesCheckOut(actionRequest);
            } else if (cmd.equals("checkin")) {
                this.checkInFileEntries(actionRequest);
            } else if (cmd.equals("checkout")) {
                this.checkOutFileEntries(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFileEntry(actionRequest, true);
            } else if (cmd.equals("revert")) {
                this.revertFileEntry(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
            } else if (!cmd.equals("preview")) {
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    this.sendRedirect(actionRequest, actionResponse);
                } else {
                    String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                    int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)2);
                    if (fileEntry != null && workflowAction == 2) {
                        redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, fileEntry, redirect);
                        this.sendRedirect(actionRequest, actionResponse, redirect);
                    } else if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                        this.sendRedirect(actionRequest, actionResponse);
                    } else {
                        redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                        if (Validator.isNotNull((String)redirect)) {
                            if (cmd.equals("add") && fileEntry != null) {
                                String portletId = HttpUtil.getParameter((String)redirect, (String)"p_p_id", (boolean)false);
                                String namespace = PortalUtil.getPortletNamespace((String)portletId);
                                redirect = HttpUtil.addParameter((String)redirect, (String)(namespace + "className"), (String)DLFileEntry.class.getName());
                                redirect = HttpUtil.addParameter((String)redirect, (String)(namespace + "classPK"), (long)fileEntry.getFileEntryId());
                            }
                            actionResponse.sendRedirect(redirect);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleUploadException(portletConfig, actionRequest, actionResponse, cmd, e);
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFileEntry((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof NoSuchFileVersionException || e instanceof NoSuchRepositoryEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        String forward = "portlet.document_library.edit_file_entry";
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/document_library/upload_multiple_file_entries_resources.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void addMultipleFileEntries(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        JSONObject jsonObject;
        String fileName;
        String[] selectedFileNames;
        ArrayList<KeyValuePair> validFileNameKVPs = new ArrayList<KeyValuePair>();
        ArrayList<KeyValuePair> invalidFileNameKVPs = new ArrayList<KeyValuePair>();
        for (String selectedFileName : selectedFileNames = ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)"selectedFileName", (String[])new String[0], (boolean)false)) {
            this.addMultipleFileEntries(portletConfig, actionRequest, actionResponse, selectedFileName, validFileNameKVPs, invalidFileNameKVPs);
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (KeyValuePair validFileNameKVP : validFileNameKVPs) {
            fileName = validFileNameKVP.getKey();
            String originalFileName = validFileNameKVP.getValue();
            jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("added", Boolean.TRUE.booleanValue());
            jsonObject.put("fileName", fileName);
            jsonObject.put("originalFileName", originalFileName);
            jsonArray.put(jsonObject);
        }
        for (KeyValuePair invalidFileNameKVP : invalidFileNameKVPs) {
            fileName = invalidFileNameKVP.getKey();
            String errorMessage = invalidFileNameKVP.getValue();
            jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("added", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
            jsonObject.put("fileName", fileName);
            jsonObject.put("originalFileName", fileName);
            jsonArray.put(jsonObject);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMultipleFileEntries(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String selectedFileName, List<KeyValuePair> validFileNameKVPs, List<KeyValuePair> invalidFileNameKVPs) throws Exception {
        String originalSelectedFileName = selectedFileName;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String changeLog = ParamUtil.getString((PortletRequest)actionRequest, (String)"changeLog");
        FileEntry tempFileEntry = null;
        try {
            tempFileEntry = TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)_TEMP_FOLDER_NAME, (String)selectedFileName);
            String mimeType = tempFileEntry.getMimeType();
            String extension = FileUtil.getExtension((String)selectedFileName);
            int pos = selectedFileName.lastIndexOf(TEMP_RANDOM_SUFFIX);
            if (pos != -1) {
                selectedFileName = selectedFileName.substring(0, pos);
                if (Validator.isNotNull((String)extension)) {
                    selectedFileName = selectedFileName + "." + extension;
                }
            }
            try {
                while (true) {
                    DLAppLocalServiceUtil.getFileEntry((long)themeDisplay.getScopeGroupId(), (long)folderId, (String)selectedFileName);
                    StringBundler sb = new StringBundler(5);
                    sb.append(FileUtil.stripExtension((String)selectedFileName));
                    sb.append("-");
                    sb.append(StringUtil.randomString());
                    if (Validator.isNotNull((String)extension)) {
                        sb.append(".");
                        sb.append(extension);
                    }
                    selectedFileName = sb.toString();
                }
            }
            catch (Exception e) {
                InputStream inputStream = tempFileEntry.getContentStream();
                long size = tempFileEntry.getSize();
                ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
                FileEntry fileEntry = DLAppServiceUtil.addFileEntry((long)repositoryId, (long)folderId, (String)selectedFileName, (String)mimeType, (String)selectedFileName, (String)description, (String)changeLog, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
                AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, (String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId(), (int)-1);
                AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, (String)DLFileEntry.class.getName(), (long)folderId);
                validFileNameKVPs.add(new KeyValuePair(selectedFileName, originalSelectedFileName));
                return;
            }
        }
        catch (Exception e) {
            String errorMessage = this.getAddMultipleFileEntriesErrorMessage(portletConfig, actionRequest, actionResponse, e);
            invalidFileNameKVPs.add(new KeyValuePair(originalSelectedFileName, errorMessage));
        }
        finally {
            if (tempFileEntry != null) {
                TempFileEntryUtil.deleteTempFileEntry((long)tempFileEntry.getFileEntryId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String sourceFileName;
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        String title = sourceFileName = uploadPortletRequest.getFileName("file");
        StringBundler sb = new StringBundler(5);
        sb.append(FileUtil.stripExtension((String)sourceFileName));
        sb.append(TEMP_RANDOM_SUFFIX);
        sb.append(StringUtil.randomString());
        String extension = FileUtil.getExtension((String)sourceFileName);
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        sourceFileName = sb.toString();
        InputStream inputStream = null;
        try {
            inputStream = uploadPortletRequest.getFileAsStream("file");
            String contentType = uploadPortletRequest.getContentType("file");
            DLAppServiceUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)folderId, (String)_TEMP_FOLDER_NAME, (String)sourceFileName, (InputStream)inputStream, (String)contentType);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("name", sourceFileName);
            jsonObject.put("title", title);
            this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
        }
        catch (Exception e) {
            block6: {
                try {
                    UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                    if (uploadException != null && uploadException.getCause() instanceof FileUploadBase.IOFileUploadException) break block6;
                    if (uploadException != null && uploadException.isExceededSizeLimit()) {
                        throw new FileSizeException(uploadException.getCause());
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void cancelFileEntriesCheckOut(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            DLAppServiceUtil.cancelCheckOut((long)fileEntryId);
        } else {
            long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
            for (int i = 0; i < fileEntryIds.length; ++i) {
                DLAppServiceUtil.cancelCheckOut((long)fileEntryIds[i]);
            }
        }
    }

    protected void checkInFileEntries(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (fileEntryId > 0L) {
            DLAppServiceUtil.checkInFileEntry((long)fileEntryId, (boolean)false, (String)"", (ServiceContext)serviceContext);
        } else {
            long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
            for (int i = 0; i < fileEntryIds.length; ++i) {
                DLAppServiceUtil.checkInFileEntry((long)fileEntryIds[i], (boolean)false, (String)"", (ServiceContext)serviceContext);
            }
        }
    }

    protected void checkOutFileEntries(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (fileEntryId > 0L) {
            DLAppServiceUtil.checkOutFileEntry((long)fileEntryId, (ServiceContext)serviceContext);
        } else {
            long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
            for (int i = 0; i < fileEntryIds.length; ++i) {
                DLAppServiceUtil.checkOutFileEntry((long)fileEntryIds[i], (ServiceContext)serviceContext);
            }
        }
    }

    protected void deleteFileEntry(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId == 0L) {
            return;
        }
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        if (Validator.isNotNull((String)version)) {
            DLAppServiceUtil.deleteFileVersion((long)fileEntryId, (String)version);
            return;
        }
        if (!moveToTrash) {
            DLAppServiceUtil.deleteFileEntry((long)fileEntryId);
            return;
        }
        FileEntry fileEntry = DLAppServiceUtil.moveFileEntryToTrash((long)fileEntryId);
        if (fileEntry.getModel() instanceof DLFileEntry) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, (TrashedModel)((DLFileEntry)fileEntry.getModel()));
        }
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
    }

    protected void deleteTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            DLAppServiceUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)folderId, (String)_TEMP_FOLDER_NAME, (String)fileName);
            jsonObject.put("deleted", Boolean.TRUE.booleanValue());
        }
        catch (Exception e) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
    }

    protected String getAddMultipleFileEntriesErrorMessage(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, Exception e) throws Exception {
        String errorMessage = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (e instanceof AntivirusScannerException) {
            AntivirusScannerException ase = (AntivirusScannerException)e;
            errorMessage = themeDisplay.translate(ase.getMessageKey());
        } else if (e instanceof AssetCategoryException) {
            AssetCategoryException ace = (AssetCategoryException)e;
            AssetVocabulary assetVocabulary = ace.getVocabulary();
            String vocabularyTitle = "";
            if (assetVocabulary != null) {
                vocabularyTitle = assetVocabulary.getTitle(themeDisplay.getLocale());
            }
            if (ace.getType() == 1) {
                errorMessage = themeDisplay.translate("please-select-at-least-one-category-for-x", new Object[]{vocabularyTitle});
            } else if (ace.getType() == 2) {
                errorMessage = themeDisplay.translate("you-cannot-select-more-than-one-category-for-x", new Object[]{vocabularyTitle});
            }
        } else if (e instanceof DuplicateFileException) {
            errorMessage = themeDisplay.translate("the-folder-you-selected-already-has-an-entry-with-this-name.-please-select-a-different-folder");
        } else if (e instanceof FileExtensionException) {
            errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-extension-x", new Object[]{StringUtil.merge((Object[])this.getAllowedFileExtensions(portletConfig, (PortletRequest)actionRequest, (PortletResponse)actionResponse))});
        } else if (e instanceof FileNameException) {
            errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-name");
        } else if (e instanceof FileSizeException) {
            long fileMaxSize = PrefsPropsUtil.getLong("dl.file.max.size");
            if (fileMaxSize == 0L) {
                fileMaxSize = PrefsPropsUtil.getLong("com.liferay.portal.upload.UploadServletRequestImpl.max.size");
            }
            errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{TextFormatter.formatStorageSize((double)fileMaxSize, (Locale)themeDisplay.getLocale())});
        } else {
            errorMessage = e instanceof InvalidFileEntryTypeException ? themeDisplay.translate("the-document-type-you-selected-is-not-valid-for-this-folder") : themeDisplay.translate("an-unexpected-error-occurred-while-saving-your-document");
        }
        return errorMessage;
    }

    protected String[] getAllowedFileExtensions(PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        String[] mimeTypes;
        String portletName = portletConfig.getPortletName();
        if (!portletName.equals("31")) {
            return PrefsPropsUtil.getStringArray("dl.file.extensions", ",");
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
        HashSet extensions = new HashSet();
        for (String mimeType : mimeTypes = dlPortletInstanceSettings.getMimeTypes()) {
            extensions.addAll(MimeTypesUtil.getExtensions((String)mimeType));
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, FileEntry fileEntry, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/edit_file_entry");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
        portletURL.setParameter("referringPortletResource", referringPortletResource, false);
        portletURL.setParameter("groupId", String.valueOf(fileEntry.getGroupId()), false);
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntry.getFileEntryId()), false);
        portletURL.setParameter("version", String.valueOf(fileEntry.getVersion()), false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected void handleUploadException(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String cmd, Exception e) throws Exception {
        if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        } else if (e instanceof AntivirusScannerException || e instanceof DuplicateFileException || e instanceof DuplicateFolderNameException || e instanceof FileExtensionException || e instanceof FileMimeTypeException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof LiferayFileItemException || e instanceof NoSuchFolderException || e instanceof SourceFileNameException || e instanceof StorageFieldRequiredException) {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null && !cmd.equals("add_temp")) {
                String uploadExceptionRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"uploadExceptionRedirect");
                actionResponse.sendRedirect(uploadExceptionRedirect);
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                return;
            }
            if (!(cmd.equals("add_dynamic") || cmd.equals("add_multiple") || cmd.equals("add_temp"))) {
                if (e instanceof AntivirusScannerException) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                }
                return;
            }
            if (cmd.equals("add_temp")) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            }
            if (e instanceof AntivirusScannerException || e instanceof DuplicateFileException || e instanceof FileExtensionException || e instanceof FileNameException || e instanceof FileSizeException) {
                HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                response.setContentType("text/html");
                response.setStatus(200);
                String errorMessage = "";
                int errorType = 0;
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                if (e instanceof AntivirusScannerException) {
                    AntivirusScannerException ase = (AntivirusScannerException)e;
                    errorMessage = themeDisplay.translate(ase.getMessageKey());
                    errorType = 494;
                }
                if (e instanceof DuplicateFileException) {
                    errorMessage = themeDisplay.translate("please-enter-a-unique-document-name");
                    errorType = 490;
                } else if (e instanceof FileExtensionException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-extension-x", new Object[]{StringUtil.merge((Object[])this.getAllowedFileExtensions(portletConfig, (PortletRequest)actionRequest, (PortletResponse)actionResponse))});
                    errorType = 491;
                } else if (e instanceof FileNameException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-name");
                    errorType = 492;
                } else if (e instanceof FileSizeException) {
                    long fileMaxSize = PrefsPropsUtil.getLong("dl.file.max.size");
                    if (fileMaxSize == 0L) {
                        fileMaxSize = PrefsPropsUtil.getLong("com.liferay.portal.upload.UploadServletRequestImpl.max.size");
                    }
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{TextFormatter.formatStorageSize((double)fileMaxSize, (Locale)themeDisplay.getLocale())});
                    errorType = 493;
                }
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("message", errorMessage);
                jsonObject.put("status", errorType);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
            }
            if (e instanceof AntivirusScannerException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
        } else if (e instanceof DuplicateLockException || e instanceof InvalidFileVersionException || e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
            if (e instanceof DuplicateLockException) {
                DuplicateLockException dle = (DuplicateLockException)((Object)e);
                SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)dle)).getClass(), (Object)dle.getLock());
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
        } else {
            throw e;
        }
    }

    protected void revertFileEntry(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        DLAppServiceUtil.revertFileEntry((long)fileEntryId, (String)version, (ServiceContext)serviceContext);
    }

    protected FileEntry updateFileEntry(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        FileEntry fileEntry;
        Folder folder;
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"fileEntryId");
        long repositoryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        String title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"title");
        String description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"description");
        String changeLog = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"changeLog");
        boolean majorVersion = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"majorVersion");
        if (folderId > 0L && (folder = DLAppServiceUtil.getFolder((long)folderId)).getGroupId() != themeDisplay.getScopeGroupId()) {
            throw new NoSuchFolderException("{folderId=" + folderId + "}");
        }
        InputStream inputStream = null;
        try {
            String portletName;
            String contentType = uploadPortletRequest.getContentType("file");
            long size = uploadPortletRequest.getSize("file");
            if ((cmd.equals("add") || cmd.equals("add_dynamic")) && size == 0L) {
                contentType = MimeTypesUtil.getContentType((String)title);
            }
            if ((cmd.equals("add") || cmd.equals("add_dynamic") || size > 0L) && (portletName = portletConfig.getPortletName()).equals("31")) {
                PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
                DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
                Object[] mimeTypes = dlPortletInstanceSettings.getMimeTypes();
                if (Arrays.binarySearch(mimeTypes, contentType) < 0) {
                    throw new FileMimeTypeException(contentType);
                }
            }
            inputStream = uploadPortletRequest.getFileAsStream("file");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (UploadPortletRequest)uploadPortletRequest);
            FileEntry fileEntry2 = null;
            if (cmd.equals("add") || cmd.equals("add_dynamic")) {
                fileEntry2 = DLAppServiceUtil.addFileEntry((long)repositoryId, (long)folderId, (String)sourceFileName, (String)contentType, (String)title, (String)description, (String)changeLog, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
                AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, (String)DLFileEntry.class.getName(), (long)fileEntry2.getFileEntryId(), (int)-1);
                if (cmd.equals("add_dynamic")) {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                    jsonObject.put("fileEntryId", fileEntry2.getFileEntryId());
                    this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
                }
            } else {
                fileEntry2 = cmd.equals("update_and_checkin") ? DLAppServiceUtil.updateFileEntryAndCheckIn((long)fileEntryId, (String)sourceFileName, (String)contentType, (String)title, (String)description, (String)changeLog, (boolean)majorVersion, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext) : DLAppServiceUtil.updateFileEntry((long)fileEntryId, (String)sourceFileName, (String)contentType, (String)title, (String)description, (String)changeLog, (boolean)majorVersion, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
            }
            AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, (String)DLFileEntry.class.getName(), (long)folderId);
            fileEntry = fileEntry2;
        }
        catch (Exception e) {
            try {
                UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                if (uploadException != null) {
                    if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                        throw new LiferayFileItemException();
                    }
                    if (uploadException.isExceededSizeLimit()) {
                        throw new FileSizeException(uploadException.getCause());
                    }
                }
                throw e;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        return fileEntry;
    }
}

