/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.SourceFileNameException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("cancel_checkout")) {
                this.cancelCheckedOutEntries(actionRequest);
            } else if (cmd.equals("checkin")) {
                this.checkInEntries(actionRequest);
            } else if (cmd.equals("checkout")) {
                this.checkOutEntries(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest, false);
            } else if (cmd.equals("move")) {
                this.moveEntries(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntries(actionRequest, true);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else {
                String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof DuplicateLockException || e instanceof NoSuchFileEntryException || e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                if (e instanceof DuplicateLockException) {
                    DuplicateLockException dle = (DuplicateLockException)((Object)e);
                    SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)dle)).getClass(), (Object)dle.getLock());
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                }
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e instanceof DuplicateFileException || e instanceof DuplicateFolderNameException || e instanceof SourceFileNameException) {
                if (e instanceof DuplicateFileException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(490);
                }
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFileEntries((PortletRequest)renderRequest);
            ActionUtil.getFileShortcuts((PortletRequest)renderRequest);
            ActionUtil.getFolders((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        String forward = "portlet.document_library.edit_entry";
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    protected void cancelCheckedOutEntries(ActionRequest actionRequest) throws Exception {
        long[] fileShortcutIds;
        long[] fileEntryIds;
        for (long fileEntryId : fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L)) {
            DLAppServiceUtil.cancelCheckOut((long)fileEntryId);
        }
        for (long fileShortcutId : fileShortcutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileShortcutIds"), (long)0L)) {
            DLFileShortcut fileShortcut = DLAppLocalServiceUtil.getFileShortcut((long)fileShortcutId);
            DLAppServiceUtil.cancelCheckOut((long)fileShortcut.getToFileEntryId());
        }
    }

    protected void checkInEntries(ActionRequest actionRequest) throws Exception {
        long[] fileShortcutIds;
        long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        for (long fileEntryId : fileEntryIds) {
            DLAppServiceUtil.checkInFileEntry((long)fileEntryId, (boolean)false, (String)"", (ServiceContext)serviceContext);
        }
        for (long fileShortcutId : fileShortcutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileShortcutIds"), (long)0L)) {
            DLFileShortcut fileShortcut = DLAppLocalServiceUtil.getFileShortcut((long)fileShortcutId);
            DLAppServiceUtil.checkInFileEntry((long)fileShortcut.getToFileEntryId(), (boolean)false, (String)"", (ServiceContext)serviceContext);
        }
    }

    protected void checkOutEntries(ActionRequest actionRequest) throws Exception {
        long[] fileShortcutIds;
        long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        for (long fileEntryId : fileEntryIds) {
            DLAppServiceUtil.checkOutFileEntry((long)fileEntryId, (ServiceContext)serviceContext);
        }
        for (long fileShortcutId : fileShortcutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileShortcutIds"), (long)0L)) {
            DLFileShortcut fileShortcut = DLAppLocalServiceUtil.getFileShortcut((long)fileShortcutId);
            DLAppServiceUtil.checkOutFileEntry((long)fileShortcut.getToFileEntryId(), (ServiceContext)serviceContext);
        }
    }

    protected void deleteEntries(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteFileEntryIds;
        long[] deleteFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ArrayList<Object> trashedModels = new ArrayList<Object>();
        for (int i = 0; i < deleteFolderIds.length; ++i) {
            long deleteFolderId = deleteFolderIds[i];
            if (moveToTrash) {
                Folder folder = DLAppServiceUtil.moveFolderToTrash((long)deleteFolderId);
                if (!(folder.getModel() instanceof DLFolder)) continue;
                trashedModels.add((DLFolder)folder.getModel());
                continue;
            }
            DLAppServiceUtil.deleteFolder((long)deleteFolderId);
        }
        long[] deleteFileShortcutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileShortcutIds"), (long)0L);
        for (int i = 0; i < deleteFileShortcutIds.length; ++i) {
            long deleteFileShortcutId = deleteFileShortcutIds[i];
            if (moveToTrash) {
                DLFileShortcut fileShortcut = DLAppServiceUtil.moveFileShortcutToTrash((long)deleteFileShortcutId);
                trashedModels.add(fileShortcut);
                continue;
            }
            DLAppServiceUtil.deleteFileShortcut((long)deleteFileShortcutId);
        }
        for (long deleteFileEntryId : deleteFileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L)) {
            if (moveToTrash) {
                FileEntry fileEntry = DLAppServiceUtil.moveFileEntryToTrash((long)deleteFileEntryId);
                if (!(fileEntry.getModel() instanceof DLFileEntry)) continue;
                trashedModels.add((DLFileEntry)fileEntry.getModel());
                continue;
            }
            DLAppServiceUtil.deleteFileEntry((long)deleteFileEntryId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void moveEntries(ActionRequest actionRequest) throws Exception {
        long[] fileShortcutIds;
        long[] fileEntryIds;
        long[] folderIds;
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        for (long folderId : folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L)) {
            DLAppServiceUtil.moveFolder((long)folderId, (long)newFolderId, (ServiceContext)serviceContext);
        }
        for (long fileEntryId : fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L)) {
            DLAppServiceUtil.moveFileEntry((long)fileEntryId, (long)newFolderId, (ServiceContext)serviceContext);
        }
        for (long fileShortcutId : fileShortcutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileShortcutIds"), (long)0L)) {
            if (fileShortcutId == 0L) continue;
            DLFileShortcut fileShortcut = DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
            DLAppServiceUtil.updateFileShortcut((long)fileShortcutId, (long)newFolderId, (long)fileShortcut.getToFileEntryId(), (ServiceContext)serviceContext);
        }
    }
}

