/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.diff.DiffUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CompareVersionsAction
extends PortletAction {
    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            this.compareVersions(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                this.setForward((PortletRequest)renderRequest, "portlet.document_library.error");
            }
            throw e;
        }
        return actionMapping.findForward("portlet.document_library.compare_versions");
    }

    protected void compareVersions(RenderRequest renderRequest) throws Exception {
        long sourceFileVersionId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"sourceFileVersionId");
        long targetFileVersionId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"targetFileVersionId");
        FileVersion sourceFileVersion = DLAppServiceUtil.getFileVersion((long)sourceFileVersionId);
        InputStream sourceIs = sourceFileVersion.getContentStream(false);
        String sourceExtension = sourceFileVersion.getExtension();
        if (sourceExtension.equals("css") || sourceExtension.equals("htm") || sourceExtension.equals("html") || sourceExtension.equals("js") || sourceExtension.equals("txt") || sourceExtension.equals("xml")) {
            String sourceContent = HtmlUtil.escape((String)StringUtil.read((InputStream)sourceIs));
            sourceIs = new UnsyncByteArrayInputStream(sourceContent.getBytes("UTF-8"));
        }
        FileVersion targetFileVersion = DLAppLocalServiceUtil.getFileVersion((long)targetFileVersionId);
        InputStream targetIs = targetFileVersion.getContentStream(false);
        String targetExtension = targetFileVersion.getExtension();
        if (targetExtension.equals("css") || targetExtension.equals("htm") || targetExtension.equals("html") || targetExtension.equals("js") || targetExtension.equals("txt") || targetExtension.equals("xml")) {
            String targetContent = HtmlUtil.escape((String)StringUtil.read((InputStream)targetIs));
            targetIs = new UnsyncByteArrayInputStream(targetContent.getBytes("UTF-8"));
        }
        if (DocumentConversionUtil.isEnabled()) {
            if (DocumentConversionUtil.isConvertBeforeCompare(sourceExtension)) {
                String sourceTempFileId = DLUtil.getTempFileId((long)sourceFileVersion.getFileEntryId(), (String)sourceFileVersion.getVersion());
                sourceIs = new FileInputStream(DocumentConversionUtil.convert(sourceTempFileId, sourceIs, sourceExtension, "txt"));
            }
            if (DocumentConversionUtil.isConvertBeforeCompare(targetExtension)) {
                String targetTempFileId = DLUtil.getTempFileId((long)targetFileVersion.getFileEntryId(), (String)targetFileVersion.getVersion());
                targetIs = new FileInputStream(DocumentConversionUtil.convert(targetTempFileId, targetIs, targetExtension, "txt"));
            }
        }
        List[] diffResults = DiffUtil.diff((Reader)new InputStreamReader(sourceIs), (Reader)new InputStreamReader(targetIs));
        renderRequest.setAttribute("SOURCE_NAME", (Object)(sourceFileVersion.getTitle() + " " + sourceFileVersion.getVersion()));
        renderRequest.setAttribute("TARGET_NAME", (Object)(targetFileVersion.getTitle() + " " + targetFileVersion.getVersion()));
        renderRequest.setAttribute("DIFF_RESULTS", (Object)diffResults);
    }
}

