/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.util.Collection;
import java.util.Map;

public class DLPortletInstanceSettings {
    public static final String[] ALL_KEYS = new String[]{"rootFolderId", "displayViews", "enableFileEntryDrafts", "entriesPerPage", "entryColumns", "fileEntriesPerPage", "fileEntryColumns", "folderColumns", "foldersPerPage", "mimeTypes", "enableCommentRatings", "enableRatings", "enableRelatedAssets", "showActions", "showFolderMenu", "showFoldersSearch", "showSubfolders", "showTabs"};
    private static final String[] _MIME_TYPES_DEFAULT = ArrayUtil.toStringArray((Collection)DLUtil.getAllMediaGalleryMimeTypes());
    private static final String[] _MULTI_VALUED_KEYS = new String[]{"displayViews", "entryColumns", "fileEntryColumns", "folderColumns", "mimeTypes"};
    private TypedSettings _typedSettings;

    public static DLPortletInstanceSettings getInstance(Layout layout, String portletId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getPortletInstanceSettings((Layout)layout, (String)portletId);
        return new DLPortletInstanceSettings(settings);
    }

    public static DLPortletInstanceSettings getInstance(Layout layout, String portletId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getPortletInstanceSettings((Layout)layout, (String)portletId);
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new DLPortletInstanceSettings((Settings)parameterMapSettings);
    }

    public DLPortletInstanceSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public long getDefaultFolderId() {
        return this._typedSettings.getLongValue("rootFolderId", 0L);
    }

    public String[] getDisplayViews() {
        return this._typedSettings.getValues("displayViews");
    }

    public int getEntriesPerPage() {
        return this._typedSettings.getIntegerValue("entriesPerPage");
    }

    public String[] getEntryColumns() {
        return this._typedSettings.getValues("entryColumns");
    }

    public int getFileEntriesPerPage() {
        return this._typedSettings.getIntegerValue("fileEntriesPerPage");
    }

    public String[] getFileEntryColumns() {
        return this._typedSettings.getValues("fileEntryColumns");
    }

    public String[] getFolderColumns() {
        return this._typedSettings.getValues("folderColumns");
    }

    public int getFoldersPerPage() {
        return this._typedSettings.getIntegerValue("foldersPerPage");
    }

    public String[] getMimeTypes() {
        return this._typedSettings.getValues("mimeTypes", _MIME_TYPES_DEFAULT);
    }

    public long getRootFolderId() {
        return this._typedSettings.getLongValue("rootFolderId", 0L);
    }

    public boolean isEnableCommentRatings() {
        return this._typedSettings.getBooleanValue("enableCommentRatings");
    }

    public boolean isEnableFileEntryDrafts() {
        return this._typedSettings.getBooleanValue("enableFileEntryDrafts");
    }

    public boolean isEnableRatings() {
        return this._typedSettings.getBooleanValue("enableRatings");
    }

    public boolean isEnableRelatedAssets() {
        return this._typedSettings.getBooleanValue("enableRelatedAssets");
    }

    public boolean isShowActions() {
        return this._typedSettings.getBooleanValue("showActions");
    }

    public boolean isShowFolderMenu() {
        return this._typedSettings.getBooleanValue("showFolderMenu");
    }

    public boolean isShowFoldersSearch() {
        return this._typedSettings.getBooleanValue("showFoldersSearch");
    }

    public boolean isShowSubfolders() {
        return this._typedSettings.getBooleanValue("showSubfolders");
    }

    public boolean isShowTabs() {
        return this._typedSettings.getBooleanValue("showTabs");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("displayViews", new String[]{"dl.display.views"});
        fallbackKeys.add("enableCommentRatings", new String[]{"dl.comment.ratings.enabled"});
        fallbackKeys.add("enableFileEntryDrafts", new String[]{"dl.file.entry.drafts.enabled"});
        fallbackKeys.add("enableRatings", new String[]{"dl.ratings.enabled"});
        fallbackKeys.add("enableRelatedAssets", new String[]{"dl.related.assets.enabled"});
        fallbackKeys.add("entriesPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("entryColumns", new String[]{"dl.entry.columns"});
        fallbackKeys.add("fileEntryColumns", new String[]{"dl.file.entry.columns"});
        fallbackKeys.add("folderColumns", new String[]{"dl.folder.columns"});
        fallbackKeys.add("foldersPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("fileEntriesPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("showActions", new String[]{"dl.actions.visible"});
        fallbackKeys.add("showFolderMenu", new String[]{"dl.folder.menu.visible"});
        fallbackKeys.add("showFoldersSearch", new String[]{"dl.folders.search.visible"});
        fallbackKeys.add("showSubfolders", new String[]{"dl.subfolders.visible"});
        fallbackKeys.add("showTabs", new String[]{"dl.tabs.visible"});
        return fallbackKeys;
    }

    static {
        SettingsFactory settingsFactory = SettingsFactoryUtil.getSettingsFactory();
        settingsFactory.registerSettingsMetadata("20", DLPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
        settingsFactory.registerSettingsMetadata("199", DLPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
        settingsFactory.registerSettingsMetadata("110", DLPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
        settingsFactory.registerSettingsMetadata("31", DLPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
    }
}

