/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class CalIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{CalEvent.class.getName()};
    public static final String PORTLET_ID = "8";

    public CalIndexer() {
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    protected void doDelete(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        this.deleteDocument(event.getCompanyId(), event.getEventId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)event);
        document.addText("description", HtmlUtil.extractText((String)event.getDescription()));
        document.addText("title", event.getTitle());
        document.addKeyword("type", event.getType());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        String eventId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/calendar/view_event");
        portletURL.setParameter("eventId", eventId);
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        Document document = this.getDocument(event);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)event.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        CalEvent event = CalEventLocalServiceUtil.getEvent((long)classPK);
        this.doReindex(event);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEvents(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEvents(long companyId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = CalEventLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                CalEvent event = (CalEvent)object;
                Document document = CalIndexer.this.getDocument(event);
                actionableDynamicQuery.addDocument(document);
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

