/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Company;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.util.comparator.EntryCreateDateComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryModifiedDateComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryNameComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryPriorityComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryURLComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryVisitsComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class BookmarksUtil {
    private static Log _log = LogFactoryUtil.getLog(BookmarksUtil.class);

    public static void addPortletBreadcrumbEntries(BookmarksEntry entry, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        BookmarksFolder folder = entry.getFolder();
        if (folder.getFolderId() != 0L) {
            BookmarksUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        BookmarksEntry unescapedEntry = entry.toUnescapedModel();
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/bookmarks/view_entry");
        portletURL.setParameter("entryId", String.valueOf(entry.getEntryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedEntry.getName(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(BookmarksFolder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/bookmarks/select_folder")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            portletURL.setParameter("struts_action", "/bookmarks/select_folder");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/bookmarks/view");
        }
        List ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (BookmarksFolder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        if (folder.getFolderId() != 0L) {
            BookmarksFolder unescapedFolder = folder.toUnescapedModel();
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFolder.getName(), (String)portletURL.toString());
        }
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (folderId == 0L) {
            return;
        }
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
        BookmarksUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
    }

    public static String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.fetchBookmarksFolder((long)folderId);
        List folders = folder.getAncestors();
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        Collections.reverse(folders);
        for (BookmarksFolder curFolder : folders) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public static String getControlPanelLink(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"198", (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/bookmarks/view");
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$BOOKMARKS_ENTRY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-bookmark-entry"));
        definitionTerms.put("[$BOOKMARKS_ENTRY_STATUS_BY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-updated-the-bookmark-entry"));
        definitionTerms.put("[$BOOKMARKS_ENTRY_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-bookmark-entry-url"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)portletRequest));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public static List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Document document : hits.getDocs()) {
            String entryClassName = document.get("entryClassName");
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                BookmarksEntry obj = null;
                if (entryClassName.equals(BookmarksEntry.class.getName())) {
                    obj = BookmarksEntryLocalServiceUtil.getEntry((long)entryClassPK);
                } else if (entryClassName.equals(BookmarksFolder.class.getName())) {
                    obj = BookmarksFolderLocalServiceUtil.getFolder((long)entryClassPK);
                }
                entries.add(obj);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Bookmarks search index is stale and contains entry " + entryClassPK));
            }
        }
        return entries;
    }

    public static OrderByComparator<BookmarksEntry> getEntryOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        EntryCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new EntryCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new EntryModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new EntryNameComparator(orderByAsc);
        } else if (orderByCol.equals("priority")) {
            orderByComparator = new EntryPriorityComparator(orderByAsc);
        } else if (orderByCol.equals("url")) {
            orderByComparator = new EntryURLComparator(orderByAsc);
        } else if (orderByCol.equals("visits")) {
            orderByComparator = new EntryVisitsComparator(orderByAsc);
        }
        return orderByComparator;
    }
}

