/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import com.liferay.portlet.bookmarks.trash.BookmarksBaseTrashHandler;
import com.liferay.portlet.bookmarks.util.BookmarksUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import javax.portlet.PortletRequest;

public class BookmarksEntryTrashHandler
extends BookmarksBaseTrashHandler {
    public void deleteTrashEntry(long classPK) throws PortalException {
        BookmarksEntryLocalServiceUtil.deleteEntry((long)classPK);
    }

    public String getClassName() {
        return BookmarksEntry.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        long parentFolderId = entry.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        BookmarksEntry entry = (BookmarksEntry)trashedModel;
        return this.getContainerModel(entry.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return BookmarksUtil.getControlPanelLink(portletRequest, entry.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return BookmarksUtil.getAbsolutePath(portletRequest, entry.getFolderId());
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.getTrashEntry();
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return BookmarksFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_ENTRY");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isInTrash(long classPK) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.isInTrashContainer();
    }

    public boolean isRestorable(long classPK) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        if (entry.getFolderId() > 0L && BookmarksFolderLocalServiceUtil.fetchBookmarksFolder((long)entry.getFolderId()) == null) {
            return false;
        }
        return !entry.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        BookmarksEntryLocalServiceUtil.moveEntry((long)classPK, (long)containerModelId);
    }

    public void moveTrashEntry(long userId, long classPK, long containerId, ServiceContext serviceContext) throws PortalException {
        BookmarksEntryLocalServiceUtil.moveEntryFromTrash((long)userId, (long)classPK, (long)containerId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        BookmarksEntryLocalServiceUtil.restoreEntryFromTrash((long)userId, (long)classPK);
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.getGroupId();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return BookmarksEntryPermission.contains(permissionChecker, entry, actionId);
    }
}

