/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksPermission;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portlet.bookmarks.model.BookmarksFolder"})
public class BookmarksFolderPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, BookmarksFolder folder, String actionId) throws PortalException {
        if (!BookmarksFolderPermission.contains(permissionChecker, folder, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException {
        if (!BookmarksFolderPermission.contains(permissionChecker, groupId, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, BookmarksFolder folder, String actionId) throws PortalException {
        Boolean hasPermission;
        if (actionId.equals("ADD_FOLDER")) {
            actionId = "ADD_SUBFOLDER";
        }
        if ((hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)folder.getGroupId(), (String)BookmarksFolder.class.getName(), (long)folder.getFolderId(), (String)"28", (String)actionId)) != null) {
            return hasPermission;
        }
        if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            block7: {
                try {
                    long folderId = folder.getFolderId();
                    while (folderId != 0L) {
                        folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
                        if (!BookmarksFolderPermission._hasPermission(permissionChecker, folder, actionId)) {
                            return false;
                        }
                        folderId = folder.getParentFolderId();
                    }
                }
                catch (NoSuchFolderException nsfe) {
                    if (folder.isInTrash()) break block7;
                    throw nsfe;
                }
            }
            return BookmarksPermission.contains(permissionChecker, folder.getGroupId(), actionId);
        }
        return BookmarksFolderPermission._hasPermission(permissionChecker, folder, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException {
        if (folderId == 0L) {
            return BookmarksPermission.contains(permissionChecker, groupId, actionId);
        }
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getBookmarksFolder((long)folderId);
        return BookmarksFolderPermission.contains(permissionChecker, folder, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        BookmarksFolderPermission.check(permissionChecker, groupId, primaryKey, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, BookmarksFolder folder, String actionId) {
        return permissionChecker.hasOwnerPermission(folder.getCompanyId(), BookmarksFolder.class.getName(), folder.getFolderId(), folder.getUserId(), actionId) || permissionChecker.hasPermission(folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), actionId);
    }
}

