/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksPermission;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portlet.bookmarks.model.BookmarksEntry"})
public class BookmarksEntryPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, BookmarksEntry entry, String actionId) throws PortalException {
        if (!BookmarksEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        if (!BookmarksEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, BookmarksEntry entry, String actionId) throws PortalException {
        block9: {
            Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)entry.getGroupId(), (String)BookmarksEntry.class.getName(), (long)entry.getEntryId(), (String)"28", (String)actionId);
            if (hasPermission != null) {
                return hasPermission;
            }
            if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                long folderId = entry.getFolderId();
                if (folderId == 0L) {
                    if (!BookmarksPermission.contains(permissionChecker, entry.getGroupId(), actionId)) {
                        return false;
                    }
                } else {
                    try {
                        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
                        if (!BookmarksFolderPermission.contains(permissionChecker, folder, "ACCESS") && !BookmarksFolderPermission.contains(permissionChecker, folder, "VIEW")) {
                            return false;
                        }
                    }
                    catch (NoSuchFolderException nsfe) {
                        if (entry.isInTrash()) break block9;
                        throw nsfe;
                    }
                }
            }
        }
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), BookmarksEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)entryId);
        return BookmarksEntryPermission.contains(permissionChecker, entry, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        BookmarksEntryPermission.check(permissionChecker, primaryKey, actionId);
    }
}

